/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.util.Date;
import net.whirljack.sdj.gui.MainWindow;
import org.apache.log4j.Logger;

public class AlarmThread
implements Runnable {
    private Logger logger = Logger.getLogger(AlarmThread.class);
    private Date nextEvent = null;
    private MainWindow myWindow = null;
    private Thread runner = null;
    private boolean alarmSet = false;

    public AlarmThread(MainWindow myWindow) {
        this.myWindow = myWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextEvent(Date nextEvent) {
        this.nextEvent = nextEvent;
        if (this.runner != null) {
            try {
                this.alarmSet = false;
                this.runner.interrupt();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.info((Object)"Interrupted runner to set new alarm.", (Throwable)e);
            }
            finally {
                this.runner = null;
            }
        }
        this.alarmSet = true;
        this.runner = new Thread((Runnable)this, "AlarmThread@" + this.nextEvent);
        this.runner.setDaemon(true);
        this.runner.start();
    }

    @Override
    public void run() {
        this.logger.debug((Object)("Alarm thread started, next event at " + this.nextEvent));
        while (this.alarmSet) {
            try {
                Thread.sleep(60000L);
                if (!this.alarmSet || !new Date().after(this.nextEvent)) continue;
                this.logger.info((Object)"Waking up.");
                this.nextEvent = null;
                this.myWindow.wakeup();
            }
            catch (Exception e) {
                this.logger.warn((Object)"Interrupted", (Throwable)e);
            }
        }
        this.logger.info((Object)"Thread finished.");
    }

    public Date getNextEvent() {
        return this.nextEvent;
    }
}

