/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.util.ArrayList;
import java.util.List;
import net.whirljack.sdj.EntryElementParseHandler;
import net.whirljack.sdj.bo.SDJEntryElement;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EntryElementListParseHandler
extends DefaultHandler {
    private Logger logger = Logger.getLogger(EntryElementParseHandler.class);
    private SDJEntryElement entry;
    private List<SDJEntryElement> entryList;
    private boolean inHeading = false;
    private boolean inText = false;
    private StringBuffer buf = new StringBuffer();

    public EntryElementListParseHandler() {
        this.entryList = new ArrayList<SDJEntryElement>();
        this.entry = new SDJEntryElement();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("heading")) {
            this.inHeading = false;
            this.entry.setHeading(this.buf.toString());
            this.buf.delete(0, this.buf.length());
            this.logger.debug((Object)"inHeading=false");
            this.logger.debug((Object)("Set heading: " + this.entry.getHeading()));
        } else if (qName.equals("text")) {
            this.inText = false;
            this.entry.setText(this.buf.toString());
            this.buf.delete(0, this.buf.length());
            this.logger.debug((Object)"inText=false");
            this.logger.debug((Object)("Set text: " + this.entry.getText()));
        } else if (qName.equals("entry")) {
            this.entryList.add(this.entry);
            this.entry = new SDJEntryElement();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("entry")) {
            this.entry.setDate(attributes.getValue("date"));
            if (new Boolean(attributes.getValue("read")).booleanValue()) {
                this.entry.setRead(true);
            } else {
                this.entry.setRead(false);
            }
        } else if (qName.equals("heading")) {
            this.inHeading = true;
            this.logger.debug((Object)"inHeading=true");
        } else if (qName.equals("text")) {
            this.inText = true;
            this.logger.debug((Object)"inText=true");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inText || this.inHeading) {
            this.logger.debug((Object)"Got character data");
            for (int i = start; i < start + length; ++i) {
                this.buf.append(ch[i]);
            }
        }
    }

    public List<SDJEntryElement> getEntryElementList() {
        return this.entryList;
    }
}

