/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.whirljack.sdj.bo.SDJEntryElement;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EntryElementParseHandler
extends DefaultHandler {
    private Logger logger = Logger.getLogger(EntryElementParseHandler.class);
    private SDJEntryElement entry;
    private String targetDate;
    private boolean foundDate = false;
    private boolean inHeading = false;
    private boolean inText = false;
    private StringBuffer buf = new StringBuffer();
    private boolean ignoreYear = false;

    private EntryElementParseHandler() {
    }

    public EntryElementParseHandler(Date date, boolean ignoreYear) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        this.targetDate = format.format(date);
        if (ignoreYear) {
            this.targetDate = this.targetDate.substring(4);
        }
        this.ignoreYear = ignoreYear;
        this.logger.debug((Object)("Searching for date " + this.targetDate + " ignore year is " + ignoreYear));
        this.entry = new SDJEntryElement();
        this.entry.setHeading("No data found for " + this.targetDate);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.foundDate) {
            if (qName.equals("heading")) {
                this.inHeading = false;
                this.entry.setHeading(this.buf.toString());
                this.buf.delete(0, this.buf.length());
                this.logger.debug((Object)"inHeading=false");
                this.logger.debug((Object)("Set heading: " + this.entry.getHeading()));
            } else if (qName.equals("text")) {
                this.inText = false;
                this.entry.setText(this.buf.toString());
                this.buf.delete(0, this.buf.length());
                this.logger.debug((Object)"inContent=false");
                this.logger.debug((Object)("Set text: " + this.entry.getText()));
            } else if (qName.equals("entry")) {
                this.foundDate = false;
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.foundDate) {
            if (qName.equals("heading")) {
                this.inHeading = true;
                this.logger.debug((Object)"inHeading=true");
            } else if (qName.equals("text")) {
                this.inText = true;
                this.logger.debug((Object)"inContent=true");
            }
        } else if (qName.equals("entry")) {
            String date = attributes.getValue("date");
            if (this.ignoreYear) {
                date = date.substring(4);
            }
            if (date.equals(this.targetDate)) {
                this.foundDate = true;
                this.entry.setDate(attributes.getValue("date"));
                if (new Boolean(attributes.getValue("read")).booleanValue()) {
                    this.entry.setRead(true);
                } else {
                    this.entry.setRead(false);
                }
                this.logger.debug((Object)("Found target date " + this.targetDate));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inText || this.inHeading) {
            this.logger.debug((Object)"Got character data");
            for (int i = start; i < start + length; ++i) {
                this.buf.append(ch[i]);
            }
        }
    }

    public SDJEntryElement getSDJEntryElement() {
        return this.entry;
    }
}

