/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger logger = Logger.getLogger(FileUtil.class);

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.warn((Object)"ERROR CLOSING INPUT STREAM.", (Throwable)e);
            }
            finally {
                in = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                logger.warn((Object)"ERROR CLOSING OUTPUT STREAM.", (Throwable)e);
            }
            finally {
                out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Writer w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (Exception e) {
                logger.warn((Object)"ERROR CLOSING WRITER.", (Throwable)e);
            }
            finally {
                w = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Reader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception e) {
                logger.warn((Object)"ERROR CLOSING WRITER.", (Throwable)e);
            }
            finally {
                r = null;
            }
        }
    }

    public static void copy(File source, File dest) throws IOException {
        BufferedReader in = null;
        BufferedWriter out = null;
        String line = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF-8"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8"));
            while ((line = in.readLine()) != null) {
                out.write(line);
                out.newLine();
            }
            out.flush();
        }
        catch (IOException ioe) {
            try {
                throw ioe;
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(in);
        FileUtil.close(out);
    }

    public static void convertToSDJ(File source, File dest) throws IOException {
        BufferedReader in = null;
        BufferedWriter out = null;
        String line = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF-8"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.indexOf("<dailyReader") != -1) {
                    line = line.replaceFirst("<dailyReader", "<document");
                } else if (line.indexOf("</dailyReader>") != -1) {
                    line = line.replaceFirst("</dailyReader>", "</document>");
                }
                out.write(line);
                out.newLine();
            }
            out.flush();
        }
        catch (IOException ioe) {
            try {
                throw ioe;
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(in);
        FileUtil.close(out);
    }
}

