/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.whirljack.sdj.FileUtil;
import net.whirljack.sdj.SDJMain;
import org.apache.log4j.Logger;

public class PropertyManager {
    private Logger logger = Logger.getLogger(PropertyManager.class);
    private static PropertyManager instance = null;
    private Properties props = new Properties();
    public static final String PROPERTY_CHECK_FOR_UPDATES = "sdj.checkForUpdates";
    public static final String PROPERTY_ALARM_CLOCK_MODE = "sdj.alarmClockMode";
    public static final String PROPERTY_ALARM_CLOCK_TIME = "sdj.alarmClockTime";
    public static final String PROPERTY_WINDOW_HIDE_MODE = "sdj.windowHideMode";
    public static final String PROPERTY_FONT_SIZE = "sdj.font.size";
    public static final String PROPERTY_WINDOW_WIDTH = "sdj.window.width";
    public static final String PROPERTY_WINDOW_HEIGHT = "sdj.window.height";
    public static final String PROPERTY_WINDOW_X = "sdj.window.x";
    public static final String PROPERTY_WINDOW_Y = "sdj.window.y";
    public static final String MODE_MINIMIZE = "minimize";
    public static final String MODE_HIDE = "hide";

    private PropertyManager() {
    }

    public static PropertyManager getInstance() {
        if (instance == null) {
            instance = new PropertyManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        FileInputStream in = null;
        File configFile = new File(SDJMain.getDataDir(), "scripdujour.properties");
        try {
            if (!configFile.exists()) {
                SDJMain.getDataDir().mkdirs();
                configFile.createNewFile();
                String logfile = new File(SDJMain.getDataDir(), "scripdujour.log").getAbsolutePath();
                this.props = new Properties();
                this.props.setProperty(PROPERTY_CHECK_FOR_UPDATES, "true");
                this.props.setProperty("log4j.rootLogger", "DEBUG, FILE");
                this.props.setProperty("log4j.appender.FILE", "org.apache.log4j.RollingFileAppender");
                this.props.setProperty("log4j.appender.FILE.Threshold", "DEBUG");
                this.props.setProperty("log4j.appender.FILE.file", logfile);
                this.props.setProperty("log4j.appender.FILE.layout", "org.apache.log4j.PatternLayout");
                this.props.setProperty("log4j.appender.FILE.layout.ConversionPattern", "%5p %c [%t] %d{ISO8601} - %m%n");
                this.props.setProperty("log4j.appender.FILE.MaxFileSize", "2000KB");
                this.props.setProperty("log4j.appender.FILE.MaxBackupIndex", "5");
                this.saveProperties();
            }
            in = new FileInputStream(configFile);
            this.props.load(in);
            if (this.props.getProperty(PROPERTY_ALARM_CLOCK_MODE) == null) {
                this.props.setProperty(PROPERTY_ALARM_CLOCK_MODE, "false");
                this.props.setProperty(PROPERTY_ALARM_CLOCK_TIME, "06.00");
                this.saveProperties();
            }
            if (this.props.getProperty(PROPERTY_WINDOW_HIDE_MODE) == null) {
                this.props.setProperty(PROPERTY_WINDOW_HIDE_MODE, MODE_MINIMIZE);
                this.saveProperties();
            }
            if (this.props.getProperty(PROPERTY_FONT_SIZE) == null) {
                this.props.setProperty(PROPERTY_FONT_SIZE, "12");
                this.saveProperties();
            }
            if (this.props.getProperty(PROPERTY_WINDOW_HEIGHT) == null) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.props.setProperty(PROPERTY_WINDOW_X, Integer.toString((screenSize.width - 600) / 2));
                this.props.setProperty(PROPERTY_WINDOW_Y, Integer.toString((screenSize.height - 426) / 2));
                this.props.setProperty(PROPERTY_WINDOW_WIDTH, "600");
                this.props.setProperty(PROPERTY_WINDOW_HEIGHT, "426");
                this.saveProperties();
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(in);
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties() {
        FileOutputStream out = null;
        try {
            File configFile = new File(SDJMain.getDataDir(), "scripdujour.properties");
            out = new FileOutputStream(configFile);
            this.props.store(out, "Scrip du Jour configuration file\t");
            FileUtil.close(out);
        }
        catch (Exception e) {
            this.logger.error((Object)"COULD NOT SAVE PROPERTIES.", (Throwable)e);
        }
        finally {
            FileUtil.close(out);
        }
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public boolean getPropertyAsBoolean(String name) {
        boolean retval = false;
        String val = this.props.getProperty(name);
        if (val != null && (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes"))) {
            retval = true;
        }
        return retval;
    }

    public float getPropertyAsFloat(String name) {
        float ret;
        try {
            ret = Float.valueOf(this.props.getProperty(name)).floatValue();
        }
        catch (Exception e) {
            ret = 0.0f;
        }
        return ret;
    }

    public int getPropertyAsInt(String name) {
        int ret;
        try {
            ret = Integer.valueOf(this.props.getProperty(name));
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
        this.saveProperties();
    }
}

