/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.JOptionPane;
import net.whirljack.sdj.FileUtil;
import net.whirljack.sdj.PropertyManager;
import net.whirljack.sdj.ShutdownHook;
import net.whirljack.sdj.XMLParser;
import net.whirljack.sdj.gui.MacOSEventHandler;
import net.whirljack.sdj.gui.MainWindow;
import net.whirljack.sdj.gui.SplashWindow;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SDJMain {
    public static String VERSION = "";
    private static Logger logger = Logger.getLogger(SDJMain.class);
    private static MainWindow mainWindow;
    private static File dataDir;

    private SDJMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            new MacOSEventHandler();
        }
        System.setProperty("WORDNIK_API_KEY", "5458ce49330219f23e0020790810f29b3818096f5fbbf8560");
        Reader in = null;
        try {
            Properties appProps = new Properties();
            appProps.load(SDJMain.class.getClassLoader().getResourceAsStream("net/whirljack/sdj/VERSION"));
            VERSION = appProps.getProperty("app.version");
        }
        catch (Exception e) {
            VERSION = "0.0.0";
        }
        finally {
            FileUtil.close(in);
        }
        SplashWindow.getInstance().setStatus("Reading files...");
        new SDJMain().startup();
    }

    public static MainWindow getMainWindow() {
        return mainWindow;
    }

    public static File getDataDir() {
        return dataDir;
    }

    private void startup() {
        try {
            this.configure();
        }
        catch (Exception e) {
            SplashWindow.getInstance().setVisible(false);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            JOptionPane.showMessageDialog(null, "An error occured while running configuration routines." + System.getProperty("line.separator") + sw.toString() + System.getProperty("line.separator") + "Program will abort.", "Fatal Error", 0);
            System.exit(1);
        }
        logger.debug((Object)"Building main window.");
        SplashWindow.getInstance().setStatus("Building main window...");
        mainWindow = new MainWindow();
        mainWindow.prepareDisplay();
        SplashWindow.getInstance().close();
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook(mainWindow)));
        mainWindow.setVisible(true);
    }

    private void configure() throws Exception {
        PropertyManager.getInstance().init();
        PropertyConfigurator.configure((Properties)PropertyManager.getInstance().getProperties());
        logger.debug((Object)"Logging configured.");
        if (XMLParser.getInstance() == null) {
            throw new Exception("Could not initialize XML Parser.");
        }
        logger.debug((Object)"XML Parser initialized successfully.");
        File oldDataDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".dailyreader");
        if (oldDataDir.exists()) {
            File[] files;
            StringBuffer err = new StringBuffer();
            for (File f : files = oldDataDir.listFiles()) {
                File newFile = new File(dataDir, f.getName());
                if (f.getName().toLowerCase().endsWith(".xml")) {
                    try {
                        FileUtil.convertToSDJ(f, newFile);
                    }
                    catch (IOException ioe) {
                        err.append(f.getAbsolutePath()).append(System.getProperty("line.separator"));
                    }
                }
                if (f.delete()) {
                    logger.info((Object)("Deleted old file " + f.getAbsolutePath()));
                    continue;
                }
                logger.error((Object)("ERROR DELETING OLD FILE " + f.getAbsolutePath()));
            }
            if (oldDataDir.delete()) {
                logger.info((Object)"All settings migrated.");
            } else {
                logger.error((Object)("ERROR WHILE ATTEMPTING TO DELETE OLD DIRECTORY " + oldDataDir.getAbsolutePath()));
            }
            if (err.length() != 0) {
                SplashWindow.getInstance().setVisible(false);
                JOptionPane.showMessageDialog(null, "Errors occured while migrating these files:" + System.getProperty("line.separator") + err.toString() + "You may need to reinstall data files.", "Data Migration Error", 2);
            }
        }
    }

    static {
        dataDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".scripdujour");
    }
}

