/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.whirljack.sdj.FileUtil;
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.gui.MainWindow;
import org.apache.log4j.Logger;

public class VersionChecker
implements Runnable {
    private Logger logger = Logger.getLogger(VersionChecker.class);
    private static final String VERSION_URL = "http://www.whirljack.net/software/scripdujour/VERSION";
    private MainWindow mainWindow = null;

    public VersionChecker(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection conn = null;
        BufferedReader in = null;
        String latestVersion = null;
        try {
            Thread.sleep(2000L);
            conn = (HttpURLConnection)new URL(VERSION_URL).openConnection();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            latestVersion = in.readLine();
            this.logger.debug((Object)("Got version " + latestVersion + " from " + VERSION_URL));
            if (latestVersion.compareTo(SDJMain.VERSION) == 1) {
                this.mainWindow.newVersionAvailable();
            }
            FileUtil.close(in);
            conn.disconnect();
        }
        catch (Exception e) {
            this.logger.warn((Object)"ERROR WHILE CHECKING FOR A NEW VERSION.", (Throwable)e);
        }
        finally {
            FileUtil.close(in);
            conn.disconnect();
        }
    }
}

