/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.whirljack.sdj.EntryElementListParseHandler;
import net.whirljack.sdj.EntryElementParseHandler;
import net.whirljack.sdj.RootElementParseHandler;
import net.whirljack.sdj.bo.SDJEntryElement;
import net.whirljack.sdj.bo.SDJRootElement;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(XMLParser.class);
    private XMLReader xr;
    private static XMLParser instance = null;

    private XMLParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        this.xr = sp.getXMLReader();
    }

    public static XMLParser getInstance() {
        if (instance == null) {
            try {
                instance = new XMLParser();
            }
            catch (Exception e) {
                logger.error((Object)"COULD NOT CREATE XML PARSER!", (Throwable)e);
                instance = null;
            }
        }
        return instance;
    }

    public SDJRootElement parseRootElement(File file) throws Exception {
        RootElementParseHandler handler = new RootElementParseHandler(file);
        this.xr.setContentHandler(handler);
        this.parse(file);
        return handler.getSDJRootElement();
    }

    public SDJEntryElement parseEntryForDate(File file, Date date, boolean ignoreYear) throws Exception {
        EntryElementParseHandler handler = new EntryElementParseHandler(date, ignoreYear);
        this.xr.setContentHandler(handler);
        this.parse(file);
        return handler.getSDJEntryElement();
    }

    public List<SDJEntryElement> parseEntryElementsToList(File file) throws Exception {
        EntryElementListParseHandler handler = new EntryElementListParseHandler();
        this.xr.setContentHandler(handler);
        this.parse(file);
        return handler.getEntryElementList();
    }

    private void parse(File file) throws Exception {
        this.xr.setErrorHandler(this);
        InputSource inputSource = new InputSource(new FileInputStream(file));
        this.xr.parse(inputSource);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        logger.warn((Object)"Got a warning during parsing.", (Throwable)sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        logger.error((Object)"Got an error during parsing.", (Throwable)sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        logger.fatal((Object)"Got a fatal error during parsing.", (Throwable)sAXParseException);
    }
}

