/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.bo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.whirljack.sdj.FileUtil;
import net.whirljack.sdj.XMLParser;
import net.whirljack.sdj.bo.SDJEntryElement;
import net.whirljack.sdj.bo.SDJRootElement;
import org.apache.log4j.Logger;

public class SDJDataFile {
    private static final String XML_ELEMENT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private Logger logger = Logger.getLogger(SDJDataFile.class);
    private SDJRootElement root;
    private List<SDJEntryElement> entryList = new ArrayList<SDJEntryElement>();
    private Map<String, SDJEntryElement> dateMap = new HashMap<String, SDJEntryElement>();
    private int index = 0;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");

    private SDJDataFile() {
    }

    public SDJDataFile(int year, File file, String description, String shortDescription, boolean ignoreYear) throws IOException {
        this.root = new SDJRootElement();
        this.root.setFile(file);
        this.root.setDescription(description);
        this.root.setShortDescription(shortDescription);
        this.root.setIgnoreYear(ignoreYear);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(2, 0);
        cal.set(1, year);
        while (cal.get(1) == year) {
            SDJEntryElement entry = new SDJEntryElement();
            entry.setDate(this.dateFormatter.format(cal.getTime()));
            this.entryList.add(entry);
            ((Calendar)cal).add(5, 1);
        }
        this.write();
    }

    public SDJDataFile(File file) throws Exception {
        String date = null;
        this.root = XMLParser.getInstance().parseRootElement(file);
        this.entryList = XMLParser.getInstance().parseEntryElementsToList(file);
        for (SDJEntryElement element : this.entryList) {
            date = this.root.isIgnoreYear() ? element.getDate().substring(4, 8) : element.getDate();
            this.dateMap.put(date, element);
        }
    }

    public void incrementIndex() {
        ++this.index;
        if (this.index == this.entryList.size()) {
            this.index = 0;
        }
    }

    public void decrementIndex() {
        --this.index;
        if (this.index < 0) {
            this.index = this.entryList.size() - 1;
        }
    }

    public SDJEntryElement getCurrentEntry() {
        return this.entryList.get(this.index);
    }

    public SDJEntryElement getFirstUnreadEntry() {
        for (SDJEntryElement element : this.entryList) {
            if (element.isRead()) continue;
            return element;
        }
        return null;
    }

    public void setReadFlag(Date date, boolean read) {
        this.setReadFlag(this.dateFormatter.format(date), read);
    }

    public void setReadFlag(String date, boolean read) {
        if (this.root.isIgnoreYear()) {
            date = date.substring(4, 8);
        }
        this.dateMap.get(date).setRead(read);
    }

    public int getUnreadItemCount() {
        int count = 0;
        Date today = null;
        String todayString = this.dateFormatter.format(new Date());
        try {
            today = this.dateFormatter.parse(todayString);
        }
        catch (ParseException ex) {
            today = new Date();
        }
        for (SDJEntryElement element : this.entryList) {
            if (element.isRead()) continue;
            try {
                Date date;
                String theDate;
                if (this.root.isIgnoreYear()) {
                    theDate = todayString.substring(0, 4);
                    theDate = theDate + element.getDate().substring(4);
                } else {
                    theDate = element.getDate();
                }
                if (!(date = this.dateFormatter.parse(theDate)).before(today)) continue;
                ++count;
            }
            catch (ParseException pe) {
                this.logger.warn((Object)("Could not parse date " + element.getDate()), (Throwable)pe);
            }
        }
        return count;
    }

    public int getIndex() {
        return this.index;
    }

    public SDJRootElement getSDJRootElement() {
        return this.root;
    }

    public void setIndex(int index) {
        this.index = index > this.entryList.size() ? this.entryList.size() : index;
    }

    public SDJEntryElement getEntryForDate(Date date) {
        return this.getEntryForDate(this.dateFormatter.format(date));
    }

    public SDJEntryElement getEntryForDate(String date) {
        if (this.root.isIgnoreYear()) {
            date = date.substring(4, 8);
        }
        return this.dateMap.get(date);
    }

    public void write() throws IOException {
        File f = this.root.getFile();
        BufferedWriter out = null;
        this.logger.debug((Object)("File is " + f.getAbsolutePath()));
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
            out.write(XML_ELEMENT);
            out.newLine();
            out.write("<document description=\"");
            out.write(this.root.getDescription());
            out.write("\" shortDescription=\"");
            out.write(this.root.getShortDescription());
            out.write("\" ignoreYear=\"");
            out.write(new Boolean(this.root.isIgnoreYear()).toString());
            out.write("\">");
            out.newLine();
            this.logger.debug((Object)("Ready to write " + this.entryList.size() + " records."));
            for (SDJEntryElement entry : this.entryList) {
                out.write("<entry date=\"");
                out.write(entry.getDate());
                out.write("\" read=\"");
                if (entry.isRead()) {
                    out.write("true");
                } else {
                    out.write("false");
                }
                out.write("\">");
                out.newLine();
                out.write("<heading>");
                out.write(entry.getHeading());
                out.write("</heading>");
                out.newLine();
                out.write("<text>");
                out.write(entry.getText());
                out.write("</text>");
                out.newLine();
                out.write("</entry>");
                out.newLine();
            }
            this.logger.debug((Object)"Wrote entry list successfully.");
            out.write("</document>");
            out.newLine();
            out.flush();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("ERROR WRITING FILE " + f.getAbsolutePath()), (Throwable)e);
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new IOException("Error writing file " + f.getAbsolutePath() + sw.toString());
            }
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(out);
    }
}

