/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.whirljack.sdj.FileUtil;
import net.whirljack.sdj.SDJMain;
import org.apache.log4j.Logger;

public class AboutDialog
extends JDialog {
    private Logger logger = Logger.getLogger(AboutDialog.class);
    private JTextArea helpTextArea;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea1;
    private JTextArea licenseTextArea;
    private JLabel versionLabel;

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jTextArea1.setSelectionStart(1);
        this.jTextArea1.setCaretPosition(0);
        this.helpTextArea.setCaretPosition(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = this.getPreferredSize();
        this.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.versionLabel = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.helpTextArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.licenseTextArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("About Scrip du Jour");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/splash.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.versionLabel.setText("Scrip du Jour version " + SDJMain.VERSION);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.versionLabel, gridBagConstraints);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(10);
        this.jTextArea1.setText("Scrip du Jour is a program to make it easy to read something every day.  It gets data from xml files, which can contain any text.  Scrip du Jour is copyright 2006-2010 by Jeremy Brooks, and is distributed under the terms of the Gnu General Public License, version 2.  \n\nThis program uses the log4j library from the Apache foundation and BrowserLauncher from Eric Albert.\n\nThanks to Patrick McIlhenny for coming up with a name for the program.\n\nFor support or questions, contact jeremyb@whirljack.net.\n\n\nCHANGELOG:\nVersion 1.4.1\n10-JAN-2011\n * Using the latest version of the Knicker library for word definition lookup.\n\nVersion 1.4.0\n22-OCT-2010\n * Added right-click context menu.\n * Added ability to define a selected word.\n * Use fast splash screen.\n * Now requires Java 1.6 or higher.\n\nVersion 1.3.1\n7-DEC-2009\n * Added font size option to preferences dialog.\n * Save the window position and size when the program exits.\n * Restore window position and size when the program starts.\n\nVersion 1.3.0\n30-NOV-2009\n * Updated Mac package to use Intel JavaApplicationStub.\n * Updated the icons in the menus and toolbar.\n * Various tweaks to be more Mac-like on the Mac platform.\n * Commenting and cleanup.\n * Use latest version of log4j.\n\nVersion 1.2.1\n1/10/2007\n * Fixed ignore year logic in find first unread item.\n\nVersion 1.2.0\n12/5/2006\n * Added count of unread items older than the current day.\n * Added find first unread item.\n * Added ability to display window at a certain time each day.\n * Window is slightly bigger.\n * Cursor moves to the beginning of document when you change days.\n * Improved performance.\n\nVersion 1.1.0\n2/4/2006\n * This program is now called Scrip du Jour, rather than Daily Reader.\n   Thank you Patrick McIlhenny for the name suggestion.\n * Added better display of date to main window.\n * Fixed some typos.\n * Replaced literal \\n with System.getProperty(\"line.separator\")\n * Fixed a bug where the wait dialog was not centered in the parent window.\n * Added week & month navigation to view menu.\n * Added ability to check for updates automatically.\n * Added ability to launch browser to download update.\n\nVersion 1.0.0\n1/19/2006\n * Editor is working, and can edit existing files or create new files.\n * Custom icons and splash screen.\n * Cleaned up the code.\n * Added better feedback during long operations.\n * Added inset to tab panels to make the text more readable.\n");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setMargin(new Insets(3, 3, 3, 3));
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jTabbedPane1.addTab("Credits", this.jScrollPane1);
        this.helpTextArea.setColumns(20);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setRows(5);
        this.helpTextArea.setText("There are several options in the Preferences dialog for Scrip Du Jour.\n\nTo check for updates automatically, check the \"Check for Updates At Startup\" box.  This will connect to the Scrip du Jour home page, and see if there is a newer version.  No information is sent from your computer during this check.\n\nTo have Scrip du Jour pop up every day, you can put it in the startup items for your computer.  If you don't log in every day, you can use the Alarm Clock Mode.\n\nIf you enable Alarm Clock Mode, Scrip du Jour will continue to run after you close it, but will become visible again at the time you specify in the preferences dialog.  It can hide the window by minimizing it (which will cause the Scrip du Jour window to stay in your taskbar/dock as a minimized window), or by hiding it.  If you choose to hide the Scrip du Jour window, you will not be able to access the window again until it comes up automatically.\n\nIf you need help, or have suggestions, you can email jeremyb@whirljack.net.\n");
        this.helpTextArea.setWrapStyleWord(true);
        this.jScrollPane3.setViewportView(this.helpTextArea);
        this.jTabbedPane1.addTab("Help", this.jScrollPane3);
        this.licenseTextArea.setEditable(false);
        this.licenseTextArea.setLineWrap(true);
        this.licenseTextArea.setRows(15);
        this.licenseTextArea.setText("license");
        this.licenseTextArea.setWrapStyleWord(true);
        this.populateLicenseTextArea();
        this.jScrollPane2.setViewportView(this.licenseTextArea);
        this.jTabbedPane1.addTab("License", this.jScrollPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateLicenseTextArea() {
        BufferedReader in = null;
        InputStream is = null;
        try {
            String line = null;
            StringBuffer buf = new StringBuffer();
            is = this.getClass().getClassLoader().getResourceAsStream("net/whirljack/sdj/LICENSE.txt");
            in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append(System.getProperty("line.separator"));
            }
            this.licenseTextArea.setText(buf.toString());
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)"ERROR DISPLAYING LICENSE.", (Throwable)e);
                this.licenseTextArea.setText("There was an error while trying to display the license." + System.getProperty("line.separator") + "A copy of the license was included with this program." + System.getProperty("line.separator") + "You can also view the text of the license at:" + System.getProperty("line.separator") + "http://www.gnu.org/copyleft/gpl.html");
            }
            catch (Throwable throwable) {
                this.licenseTextArea.setCaretPosition(0);
                FileUtil.close(is);
                FileUtil.close(in);
                throw throwable;
            }
            this.licenseTextArea.setCaretPosition(0);
            FileUtil.close(is);
            FileUtil.close(in);
        }
        this.licenseTextArea.setCaretPosition(0);
        FileUtil.close(is);
        FileUtil.close(in);
    }
}

