/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import net.jeremybrooks.knicker.Knicker;
import net.jeremybrooks.knicker.dto.Definition;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class DefinitionDialog
extends JDialog {
    private Logger logger = Logger.getLogger(DefinitionDialog.class);
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public DefinitionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.logger.info((Object)"init complete");
        this.setBounds(parent.getWidth() / 2 + parent.getX() - 200, parent.getHeight() / 2 + parent.getY() - 161, 400, 322);
        this.logger.info((Object)"bounds set");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }

    public void define(String word) {
        StringBuilder sb = new StringBuilder("<html><body><h1>");
        sb.append(word).append("</h1><p><i>please wait, looking up definition...</i></p></body></html>");
        this.jTextPane1.setText(sb.toString());
        new Lookup(word).execute();
    }

    class Lookup
    extends SwingWorker<List<Definition>, Object> {
        private String word;

        private Lookup() {
        }

        public Lookup(String word) {
            this.word = word;
        }

        @Override
        protected List<Definition> doInBackground() throws Exception {
            List<Definition> retList = this.getDefintions();
            if (retList.isEmpty()) {
                DefinitionDialog.this.logger.info((Object)"Nothing found; trying again with lowercase version.");
                this.word = this.word.toLowerCase();
                retList = this.getDefintions();
            }
            return retList;
        }

        @Override
        protected void done() {
            try {
                List list = (List)this.get();
                if (list == null) {
                    this.showError("Null value returned. The service may be unavailable. Try again later.");
                } else if (list.isEmpty()) {
                    this.showError("Could not find definition for \"" + this.word + "\"");
                } else {
                    StringBuilder sb = new StringBuilder("<html><body><h1>");
                    sb.append(this.word).append("</h1>");
                    int i = 1;
                    for (Definition def : list) {
                        sb.append("<p><b>").append(i++).append(".</b> ");
                        sb.append("<i>").append(def.getPartOfSpeech()).append(": </i>");
                        sb.append(def.getText());
                        if (def.getExampleUses().size() <= 0) continue;
                        sb.append(": <i>");
                        sb.append((String)def.getExampleUses().get(0));
                        sb.append("</i>");
                    }
                    sb.append("</body></html>");
                    DefinitionDialog.this.jTextPane1.setText(sb.toString());
                }
            }
            catch (Exception e) {
                DefinitionDialog.this.logger.error((Object)"Error looking up word.", (Throwable)e);
                this.showError(e.toString());
            }
        }

        private void showError(String error) {
            StringBuilder sb = new StringBuilder("<html><body><h1>");
            sb.append(this.word).append("</h1>");
            sb.append("<p>Could not get the definition. Error was:</p>");
            sb.append("<p>").append(error).append("</p>");
            DefinitionDialog.this.jTextPane1.setText(sb.toString());
        }

        private List<Definition> getDefintions() {
            List retList = null;
            try {
                DefinitionDialog.this.logger.info((Object)"Looking in ahd");
                retList = Knicker.definitions((String)this.word, (Knicker.SourceDictionary)Knicker.SourceDictionary.ahd);
                if (retList.isEmpty()) {
                    DefinitionDialog.this.logger.info((Object)"Looking in wordnet");
                    retList = Knicker.definitions((String)this.word, (Knicker.SourceDictionary)Knicker.SourceDictionary.wordnet);
                }
                if (retList.isEmpty()) {
                    DefinitionDialog.this.logger.info((Object)"Looking in wiktionary");
                    retList = Knicker.definitions((String)this.word, (Knicker.SourceDictionary)Knicker.SourceDictionary.wiktionary);
                }
                if (retList.isEmpty()) {
                    DefinitionDialog.this.logger.info((Object)"Looking in webster");
                    retList = Knicker.definitions((String)this.word, (Knicker.SourceDictionary)Knicker.SourceDictionary.webster);
                }
                if (retList.isEmpty()) {
                    DefinitionDialog.this.logger.info((Object)"Looking in century");
                    retList = Knicker.definitions((String)this.word, (Knicker.SourceDictionary)Knicker.SourceDictionary.century);
                }
            }
            catch (Exception e) {
                DefinitionDialog.this.logger.error((Object)"Error looking up word.", (Throwable)e);
                this.showError(e.toString());
            }
            return retList;
        }
    }
}

