/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.bo.SDJDataFile;
import net.whirljack.sdj.gui.EditorWindow;
import net.whirljack.sdj.gui.SwingXMLFileFilter;
import org.apache.log4j.Logger;

public class EditorStartWindow
extends JFrame {
    private Logger logger = Logger.getLogger(EditorStartWindow.class);
    private JButton btnBrowse;
    private JButton btnCancel;
    private JButton btnNew;
    private JCheckBox cbxIgnoreYear;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField txtDescription;
    private JTextField txtFilename;
    private JTextField txtShortDescription;
    private JTextField txtYear;

    public EditorStartWindow() {
        this.initComponents();
        this.setLocation(SDJMain.getMainWindow().getX(), SDJMain.getMainWindow().getY());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.txtFilename = new JTextField();
        this.jLabel3 = new JLabel();
        this.txtDescription = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtShortDescription = new JTextField();
        this.jLabel5 = new JLabel();
        this.txtYear = new JTextField();
        this.cbxIgnoreYear = new JCheckBox();
        this.btnNew = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.btnBrowse = new JButton();
        this.jPanel3 = new JPanel();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Scrip du Jour Editor: File Selection");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/icon_16.png")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditorStartWindow.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("Create New File"));
        this.jLabel2.setText("Filename (optional)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.txtFilename.setToolTipText("Filename to create.  This is relative to your home directory.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.txtFilename, gridBagConstraints);
        this.jLabel3.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.txtDescription.setToolTipText("The description attribute for the data file.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.txtDescription, gridBagConstraints);
        this.jLabel4.setText("Short Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.txtShortDescription.setToolTipText("The short description attribute.  This is shown on the tab.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.txtShortDescription, gridBagConstraints);
        this.jLabel5.setText("Year");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.txtYear.setColumns(6);
        this.txtYear.setToolTipText("Year that data is valid for (if applicable).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.txtYear, gridBagConstraints);
        this.cbxIgnoreYear.setText("Ignore Year");
        this.cbxIgnoreYear.setToolTipText("If checked, the file is good for any year.");
        this.cbxIgnoreYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorStartWindow.this.cbxIgnoreYearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.cbxIgnoreYear, gridBagConstraints);
        this.btnNew.setText("Create File");
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorStartWindow.this.btnNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.btnNew, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("Edit Existing File"));
        this.jLabel1.setText("To edit an existing file, locate it by clicking the \"Browse\" button");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.btnBrowse.setText("Browse...");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorStartWindow.this.btnBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.btnBrowse, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel3.setLayout(new FlowLayout(2));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorStartWindow.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.btnCancel);
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeEditorWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnBrowseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(System.getProperty("user.home"));
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileFilter(new SwingXMLFileFilter());
        jfc.setFileHidingEnabled(false);
        if (jfc.showOpenDialog(this) == 0) {
            File f = jfc.getSelectedFile();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                SDJDataFile dataFile = new SDJDataFile(f);
                this.openEditorWindow(dataFile);
            }
            catch (Exception e) {
                this.logger.error((Object)("ERROR CREATING SDJDataFile OBJECT FROM FILE " + f.getAbsolutePath()), (Throwable)e);
                JOptionPane.showMessageDialog(this, "Could not parse the selected file.", "Parse Error", 0);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeEditorWindow();
    }

    private void closeEditorWindow() {
        SDJMain.getMainWindow().setVisible(true);
        this.setVisible(false);
        this.dispose();
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        if (this.validateEntry()) {
            int year = Integer.parseInt(this.txtYear.getText());
            String filename = this.txtFilename.getText();
            if (!filename.endsWith(".xml")) {
                filename = filename + ".xml";
            }
            File file = new File(System.getProperty("user.home"), filename);
            try {
                SDJDataFile dataFile = new SDJDataFile(year, file, this.txtDescription.getText(), this.txtShortDescription.getText(), this.cbxIgnoreYear.isSelected());
                this.openEditorWindow(dataFile);
            }
            catch (IOException ioe) {
                this.logger.error((Object)("ERROR CREATING FILE " + file.getAbsolutePath()), (Throwable)ioe);
                JOptionPane.showMessageDialog(this, "There was an error while trying to create the file" + System.getProperty("line.separator") + file.getAbsolutePath(), "File Error", 0);
            }
        }
    }

    private boolean validateEntry() {
        boolean valid = true;
        StringBuffer err = new StringBuffer();
        if (this.txtDescription.getText().trim().length() == 0) {
            err.append("  * You must enter a Description." + System.getProperty("line.separator"));
            valid = false;
        }
        if (this.txtShortDescription.getText().trim().length() == 0) {
            err.append("  * You must enter a Short Description." + System.getProperty("line.separator"));
            valid = false;
        }
        if (!this.cbxIgnoreYear.isSelected()) {
            try {
                Integer.parseInt(this.txtYear.getText());
            }
            catch (Exception e) {
                err.append("  * You must enter a valid Year." + System.getProperty("line.separator"));
                valid = false;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(this, "Please correct the following errors:" + System.getProperty("line.separator") + err.toString(), "Error", 0);
        } else if (this.txtFilename.getText().trim().length() == 0) {
            this.txtFilename.setText(this.txtShortDescription.getText());
        }
        return valid;
    }

    private void openEditorWindow(SDJDataFile dataFile) {
        new EditorWindow(dataFile).setVisible(true);
        this.setVisible(false);
        this.dispose();
    }

    private void cbxIgnoreYearActionPerformed(ActionEvent evt) {
        if (this.cbxIgnoreYear.isSelected()) {
            this.txtYear.setText("2010");
            this.txtYear.setEnabled(false);
        } else {
            this.txtYear.setText("");
            this.txtYear.setEnabled(true);
        }
    }
}

