/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.bo.SDJDataFile;
import org.apache.log4j.Logger;

public class EditorWindow
extends JFrame {
    private Logger logger = Logger.getLogger(EditorWindow.class);
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");
    private DateFormat prettyDateFormat = DateFormat.getDateInstance(2);
    private SDJDataFile dataFile = null;
    private JCheckBox cbxIgnoreYear;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JLabel lblDate;
    private JLabel lblFilename;
    private JTextField txtDescription;
    private JTextField txtHeading;
    private JTextField txtShortDescription;
    private JTextArea txtText;

    public EditorWindow(SDJDataFile dataFile) {
        this.dataFile = dataFile;
        this.initComponents();
        this.setLocation(SDJMain.getMainWindow().getX(), SDJMain.getMainWindow().getY());
        this.updateDisplay();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.cbxIgnoreYear = new JCheckBox();
        this.txtDescription = new JTextField();
        this.txtShortDescription = new JTextField();
        this.lblDate = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel5 = new JLabel();
        this.txtHeading = new JTextField();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtText = new JTextArea();
        this.jLabel3 = new JLabel();
        this.lblFilename = new JLabel();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle(this.dataFile.getSDJRootElement().getFile().getAbsolutePath());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/icon_16.png")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditorWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("Description");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Short Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.cbxIgnoreYear.setText("Ignore Year");
        this.cbxIgnoreYear.setToolTipText("Ignore the year part of the date when displaying data from this file.");
        this.cbxIgnoreYear.setSelected(this.dataFile.getSDJRootElement().isIgnoreYear());
        this.cbxIgnoreYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.cbxIgnoreYearActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.cbxIgnoreYear, gridBagConstraints);
        this.txtDescription.setColumns(40);
        this.txtDescription.setText(this.dataFile.getSDJRootElement().getDescription());
        this.txtDescription.setToolTipText("A description of the data in this file.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtDescription, gridBagConstraints);
        this.txtShortDescription.setColumns(40);
        this.txtShortDescription.setText(this.dataFile.getSDJRootElement().getShortDescription());
        this.txtShortDescription.setToolTipText("The short description is shown in the tab when the file is displayed.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtShortDescription, gridBagConstraints);
        this.lblDate.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblDate, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/back.png")));
        this.jButton1.setToolTipText("Go to the previous day.");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/next.png")));
        this.jButton2.setToolTipText("Go to the next day.");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton2, gridBagConstraints);
        this.jLabel5.setText("Heading");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.txtHeading.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtHeading, gridBagConstraints);
        this.jLabel6.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.txtText.setLineWrap(true);
        this.txtText.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.txtText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel3.setText("Filename");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.lblFilename.setText(this.dataFile.getSDJRootElement().getFile().getAbsolutePath());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblFilename, gridBagConstraints);
        this.jButton3.setText("Done");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorWindow.this.jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.getContentPane().add((Component)this.jButton3, gridBagConstraints);
        this.setBounds(0, 0, 600, 400);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.saveEntry();
        JOptionPane.showMessageDialog(this, "File saved successfully.", "Save", 1);
        SDJMain.getMainWindow().setVisible(true);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.saveEntry();
        this.dataFile.incrementIndex();
        this.updateDisplay();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.saveEntry();
        this.dataFile.decrementIndex();
        this.updateDisplay();
    }

    private void cbxIgnoreYearActionPerformed(ActionEvent evt) {
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void updateDisplay() {
        StringBuffer buf = new StringBuffer();
        try {
            Date d = this.dateFormatter.parse(this.dataFile.getCurrentEntry().getDate());
            buf.append(this.prettyDateFormat.format(d));
            buf.append(" (");
            buf.append(this.dataFile.getCurrentEntry().getDate());
            buf.append(')');
        }
        catch (ParseException ex) {
            this.logger.error((Object)"Could not parse date.", (Throwable)ex);
            buf.append(this.dataFile.getCurrentEntry().getDate());
        }
        this.lblDate.setText(buf.toString());
        this.txtHeading.setText(this.dataFile.getCurrentEntry().getHeading());
        this.txtHeading.setCaretPosition(0);
        this.txtText.setText(this.dataFile.getCurrentEntry().getText());
        this.txtText.setCaretPosition(0);
        this.txtHeading.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEntry() {
        if (this.dataFile != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.dataFile.getCurrentEntry().setHeading(this.txtHeading.getText());
            this.dataFile.getCurrentEntry().setText(this.txtText.getText());
            this.dataFile.getSDJRootElement().setDescription(this.txtDescription.getText());
            this.dataFile.getSDJRootElement().setShortDescription(this.txtShortDescription.getText());
            this.dataFile.getSDJRootElement().setIgnoreYear(this.cbxIgnoreYear.isSelected());
            try {
                this.dataFile.write();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "There was a fatal error while writing the file.", "Error", 0);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

