/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.whirljack.sdj.AlarmThread;
import net.whirljack.sdj.BrowserLauncher;
import net.whirljack.sdj.FileUtil;
import net.whirljack.sdj.PropertyManager;
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.VersionChecker;
import net.whirljack.sdj.bo.SDJEntryElement;
import net.whirljack.sdj.gui.AboutDialog;
import net.whirljack.sdj.gui.DefinitionDialog;
import net.whirljack.sdj.gui.EditorStartWindow;
import net.whirljack.sdj.gui.PreferencesDialog;
import net.whirljack.sdj.gui.SwingWorker;
import net.whirljack.sdj.gui.SwingXMLFileFilter;
import net.whirljack.sdj.gui.TabBuilder;
import net.whirljack.sdj.gui.TabPanel;
import net.whirljack.sdj.gui.WaitDialog;
import org.apache.log4j.Logger;

public class MainWindow
extends JFrame {
    private Logger logger = Logger.getLogger(MainWindow.class);
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("EEEE, MMMM dd, yyyy");
    private SimpleDateFormat weekDateFormatter = new SimpleDateFormat("MMMM dd, yyyy");
    private SimpleDateFormat entryDateFormatter = new SimpleDateFormat("yyyyMMdd");
    private Calendar currentDate = new GregorianCalendar();
    private List<TabPanel> tabList;
    private AlarmThread timer = null;
    private JMenuItem aboutMenu;
    private JButton backButton;
    private JMenuItem defineMenu;
    private JMenuItem deleteMenu;
    private JMenuItem editorMenu;
    private JMenu fileMenu;
    private JMenu goMenu;
    private JMenu helpMenu;
    private JButton homeButton;
    private JMenuItem installMenu;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar jToolBar1;
    private JLabel lblDate;
    private JMenuItem menuFirstUnread;
    private JMenuItem menuItemExit;
    private JMenuItem menuNextDay;
    private JMenuItem menuNextMonth;
    private JMenuItem menuNextWeek;
    private JMenuItem menuPreviousDay;
    private JMenuItem menuPreviousMonth;
    private JMenuItem menuPreviousWeek;
    private JMenuItem menuToday;
    private JButton nextButton;
    private JMenuItem preferencesMenu;
    private JTabbedPane tabPane;
    private JMenu toolsMenu;
    private JButton updateButton;

    public MainWindow() {
        this.currentDate.setTime(new Date());
        this.tabList = TabBuilder.getInstance().createTabs();
        this.initComponents();
        this.setBounds(PropertyManager.getInstance().getPropertyAsInt("sdj.window.x"), PropertyManager.getInstance().getPropertyAsInt("sdj.window.y"), PropertyManager.getInstance().getPropertyAsInt("sdj.window.width"), PropertyManager.getInstance().getPropertyAsInt("sdj.window.height"));
        if (System.getProperty("mrj.version") != null) {
            Component[] items;
            for (Component item : items = this.fileMenu.getMenuComponents()) {
                JMenuItem jmi = (JMenuItem)item;
                if (!jmi.getText().equals("Exit")) continue;
                this.fileMenu.remove(item);
            }
        }
        this.timer = new AlarmThread(this);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.backButton = new JButton();
        this.homeButton = new JButton();
        this.nextButton = new JButton();
        this.updateButton = new JButton();
        this.tabPane = new JTabbedPane();
        this.lblDate = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.installMenu = new JMenuItem();
        this.deleteMenu = new JMenuItem();
        this.menuItemExit = new JMenuItem();
        this.goMenu = new JMenu();
        this.menuPreviousDay = new JMenuItem();
        this.menuToday = new JMenuItem();
        this.menuNextDay = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.menuPreviousWeek = new JMenuItem();
        this.menuNextWeek = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.menuPreviousMonth = new JMenuItem();
        this.menuNextMonth = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.menuFirstUnread = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.toolsMenu.addMenuListener(new ToolsMenuHandler());
        this.editorMenu = new JMenuItem();
        this.preferencesMenu = new JMenuItem();
        this.defineMenu = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenu = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Scrip du Jour " + SDJMain.VERSION);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/icon_16.png")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainWindow.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/back.png")));
        this.backButton.setToolTipText("Go to the previous day.");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.backButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.backButton);
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/home.png")));
        this.homeButton.setToolTipText("Go to today.");
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.homeButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.homeButton);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/next.png")));
        this.nextButton.setToolTipText("Go to the next day.");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.nextButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.nextButton);
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/new.png")));
        this.updateButton.setText("Update available!");
        this.updateButton.setToolTipText("A new version is available!  Click here for information.");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.updateButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.updateButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.lblDate.setText("Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblDate, gridBagConstraints);
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.installMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/add.png")));
        this.installMenu.setMnemonic('i');
        this.installMenu.setText("Install Data Files");
        this.installMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.installMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.installMenu);
        this.deleteMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/remove.png")));
        this.deleteMenu.setMnemonic('d');
        this.deleteMenu.setText("Delete Data Files");
        this.deleteMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.deleteMenuActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.deleteMenu);
        this.menuItemExit.setMnemonic('x');
        this.menuItemExit.setText("Exit");
        this.menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuItemExitActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuItemExit);
        this.jMenuBar1.add(this.fileMenu);
        this.goMenu.setMnemonic('g');
        this.goMenu.setText("Go");
        this.menuPreviousDay.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        this.menuPreviousDay.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/back.png")));
        this.menuPreviousDay.setMnemonic('p');
        this.menuPreviousDay.setText("Previous Day");
        this.menuPreviousDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuPreviousDayActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuPreviousDay);
        this.menuToday.setAccelerator(KeyStroke.getKeyStroke(36, 8));
        this.menuToday.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/home.png")));
        this.menuToday.setMnemonic('t');
        this.menuToday.setText("Today");
        this.menuToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuTodayActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuToday);
        this.menuNextDay.setAccelerator(KeyStroke.getKeyStroke(39, 8));
        this.menuNextDay.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/next.png")));
        this.menuNextDay.setMnemonic('n');
        this.menuNextDay.setText("Next Day");
        this.menuNextDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuNextDayActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuNextDay);
        this.goMenu.add(this.jSeparator1);
        this.menuPreviousWeek.setText("Previous Week");
        this.menuPreviousWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuPreviousWeekActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuPreviousWeek);
        this.menuNextWeek.setText("Next Week");
        this.menuNextWeek.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuNextWeekActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuNextWeek);
        this.goMenu.add(this.jSeparator2);
        this.menuPreviousMonth.setText("Previous Month");
        this.menuPreviousMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuPreviousMonthActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuPreviousMonth);
        this.menuNextMonth.setText("Next Month");
        this.menuNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuNextMonthActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuNextMonth);
        this.goMenu.add(this.jSeparator3);
        this.menuFirstUnread.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.menuFirstUnread.setText("First Unread Item");
        this.menuFirstUnread.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.menuFirstUnreadActionPerformed(evt);
            }
        });
        this.goMenu.add(this.menuFirstUnread);
        this.jMenuBar1.add(this.goMenu);
        this.toolsMenu.setMnemonic('t');
        this.toolsMenu.setText("Tools");
        this.editorMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/edit.png")));
        this.editorMenu.setText("Open Editor");
        this.editorMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.editorMenuActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.editorMenu);
        this.preferencesMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/process.png")));
        this.preferencesMenu.setText("Preferences");
        this.preferencesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.preferencesMenuActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.preferencesMenu);
        this.defineMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/dictionary.png")));
        this.defineMenu.setText("jMenuItem1");
        this.defineMenu.setName("define");
        this.defineMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.defineMenuActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.defineMenu);
        this.jMenuBar1.add(this.toolsMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.aboutMenu.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.aboutMenu.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/help.png")));
        this.aboutMenu.setText("About");
        this.aboutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.aboutMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenu);
        this.jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void formWindowClosing(WindowEvent evt) {
        if (PropertyManager.getInstance().getPropertyAsBoolean("sdj.alarmClockMode")) {
            if (PropertyManager.getInstance().getProperty("sdj.windowHideMode").equals("minimize")) {
                this.setExtendedState(1);
            } else {
                this.setVisible(false);
            }
            int h = 0;
            int m = 0;
            try {
                String time = PropertyManager.getInstance().getProperty("sdj.alarmClockTime");
                StringTokenizer tok = new StringTokenizer(time, ".");
                String hour = tok.nextToken();
                String minute = tok.nextToken();
                h = Integer.parseInt(hour);
                m = Integer.parseInt(minute);
            }
            catch (Exception e) {
                // empty catch block
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(5, cal.get(5) + 1);
            cal.set(11, h);
            cal.set(12, m);
            this.timer.setNextEvent(cal.getTime());
        } else {
            PropertyManager.getInstance().setProperty("sdj.window.x", Integer.toString(this.getX()));
            PropertyManager.getInstance().setProperty("sdj.window.y", Integer.toString(this.getY()));
            PropertyManager.getInstance().setProperty("sdj.window.width", Integer.toString(this.getWidth()));
            PropertyManager.getInstance().setProperty("sdj.window.height", Integer.toString(this.getHeight()));
            System.exit(0);
        }
    }

    public void savePositionAndSize() {
        PropertyManager.getInstance().setProperty("sdj.window.x", Integer.toString(this.getX()));
        PropertyManager.getInstance().setProperty("sdj.window.y", Integer.toString(this.getY()));
        PropertyManager.getInstance().setProperty("sdj.window.width", Integer.toString(this.getWidth()));
        PropertyManager.getInstance().setProperty("sdj.window.height", Integer.toString(this.getHeight()));
    }

    private void preferencesMenuActionPerformed(ActionEvent evt) {
        try {
            new PreferencesDialog((Frame)this, true).setVisible(true);
        }
        catch (Throwable t) {
            this.logger.error((Object)"ERROR", t);
        }
    }

    private void menuFirstUnreadActionPerformed(ActionEvent evt) {
        block8: {
            Date unreadItemDate = null;
            Component c = this.tabPane.getSelectedComponent();
            if (c != null) {
                if (c instanceof TabPanel) {
                    this.logger.debug((Object)"Found tab panel.");
                    try {
                        SDJEntryElement entry = ((TabPanel)c).getDataFile().getFirstUnreadEntry();
                        if (entry == null) {
                            JOptionPane.showMessageDialog(this, "No unread items were found.", "Nothing Found", 1);
                            break block8;
                        }
                        this.logger.debug((Object)("Found " + entry + " as first unread item."));
                        String theDate = entry.getDate();
                        if (((TabPanel)c).getDataFile().getSDJRootElement().isIgnoreYear()) {
                            String year = this.entryDateFormatter.format(new Date()).substring(0, 4);
                            theDate = year + entry.getDate().substring(4);
                        }
                        unreadItemDate = this.entryDateFormatter.parse(theDate);
                        this.currentDate.setTime(unreadItemDate);
                        this.updateDisplay();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"ERROR WHILE LOOKING FOR UNREAD ITEM.", (Throwable)e);
                        JOptionPane.showMessageDialog(this, "An error occured while looking for the first\nunread item (" + e.getMessage(), "Error", 0);
                    }
                } else {
                    this.logger.debug((Object)"Not a tab panel.");
                }
            } else {
                this.logger.debug((Object)"No tab is selected.");
            }
        }
    }

    public void wakeup() {
        this.logger.debug((Object)"Time to wake up.");
        this.updateButton.setVisible(false);
        if (PropertyManager.getInstance().getPropertyAsBoolean("sdj.checkForUpdates")) {
            Thread t = new Thread(new VersionChecker(this));
            t.setDaemon(true);
            t.start();
        }
        this.today();
        this.setExtendedState(0);
        this.setVisible(true);
    }

    public void prepareDisplay() {
        boolean index = false;
        this.createTabs();
        this.updateButton.setVisible(false);
        if (PropertyManager.getInstance().getPropertyAsBoolean("sdj.checkForUpdates")) {
            Thread t = new Thread(new VersionChecker(this));
            t.setDaemon(true);
            t.start();
        }
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        String HOME_PAGE = "http://www.whirljack.net/software/scripdujour/";
        int response = JOptionPane.showOptionDialog(this, "A new version or Scrip du Jour is available!" + System.getProperty("line.separator") + "The new version can be downloaded from" + System.getProperty("line.separator") + HOME_PAGE + System.getProperty("line.separator") + System.getProperty("line.separator") + "Would you like to go there now?", "New Version", 0, 1, null, null, null);
        if (response == 0) {
            try {
                BrowserLauncher.openURL(HOME_PAGE);
            }
            catch (Exception e) {
                this.logger.error((Object)"Could not launch browser.", (Throwable)e);
                JOptionPane.showMessageDialog(this, "There was an error while launching a browser." + System.getProperty("line.separator") + "Point your browser to " + HOME_PAGE + System.getProperty("line.separator") + "to download the new version.", "Error Launching Browser", 1);
            }
        }
    }

    private void menuPreviousMonthActionPerformed(ActionEvent evt) {
        this.previous(DateChangeMode.MONTH);
    }

    private void menuNextMonthActionPerformed(ActionEvent evt) {
        this.next(DateChangeMode.MONTH);
    }

    private void menuNextWeekActionPerformed(ActionEvent evt) {
        this.next(DateChangeMode.WEEK);
    }

    private void menuPreviousWeekActionPerformed(ActionEvent evt) {
        this.previous(DateChangeMode.WEEK);
    }

    private void editorMenuActionPerformed(ActionEvent evt) {
        EditorStartWindow editorStartWindow = new EditorStartWindow();
        this.setVisible(false);
        editorStartWindow.setVisible(true);
    }

    private void deleteMenuActionPerformed(ActionEvent evt) {
        ArrayList<String> errList = new ArrayList<String>();
        JFileChooser jfc = new JFileChooser(SDJMain.getDataDir());
        jfc.setMultiSelectionEnabled(true);
        jfc.setFileFilter(new SwingXMLFileFilter());
        jfc.setApproveButtonText("Delete Files");
        jfc.setDialogTitle("Select Files to Delete");
        if (jfc.showOpenDialog(this) == 0) {
            File[] files = jfc.getSelectedFiles();
            StringBuffer buf = new StringBuffer();
            buf.append("You are about to delete the following files:" + System.getProperty("line.separator"));
            for (File f : files) {
                buf.append(f.getAbsolutePath()).append(System.getProperty("line.separator"));
            }
            buf.append("Are you sure you want to do this?");
            if (JOptionPane.showConfirmDialog(this, buf.toString(), "Delete Files?", 0, 3) == 0) {
                for (File f : files) {
                    if (f.delete()) continue;
                    this.logger.warn((Object)("Could not delete " + f.getAbsolutePath()));
                    errList.add(f.getAbsolutePath());
                }
                if (errList.size() > 0) {
                    buf.delete(0, buf.length());
                    buf.append("The following files could not be deleted:" + System.getProperty("line.separator"));
                    for (String s : errList) {
                        buf.append(s).append(System.getProperty("line.separator"));
                    }
                    JOptionPane.showMessageDialog(this, buf.toString(), "Error Deleting Files", 0);
                } else {
                    JOptionPane.showMessageDialog(this, "Files deleted successfully.", "Success", 1);
                }
                this.tabList = null;
                this.createTabs();
            }
        }
    }

    private void installMenuActionPerformed(ActionEvent evt) {
        ArrayList<String> errList = new ArrayList<String>();
        ArrayList<String> successList = new ArrayList<String>();
        JFileChooser jfc = new JFileChooser(System.getProperty("user.home"));
        jfc.setApproveButtonText("Install Files");
        jfc.setMultiSelectionEnabled(true);
        jfc.setFileFilter(new SwingXMLFileFilter());
        if (jfc.showOpenDialog(this) == 0) {
            StringBuilder sb;
            File[] files;
            for (File source : files = jfc.getSelectedFiles()) {
                File dest = new File(SDJMain.getDataDir(), source.getName());
                this.logger.debug((Object)("Copying " + source.getAbsolutePath() + " to " + dest.getAbsolutePath()));
                try {
                    FileUtil.copy(source, dest);
                    successList.add(source.getName());
                }
                catch (IOException ioe) {
                    errList.add(source.getAbsolutePath());
                }
            }
            if (errList.size() > 0) {
                sb = new StringBuilder();
                sb.append("The following files could not be copied:" + System.getProperty("line.separator"));
                for (String s : errList) {
                    sb.append(s).append(System.getProperty("line.separator"));
                }
                JOptionPane.showMessageDialog(this, sb.toString(), "Error Copying Files", 0);
            } else {
                sb = new StringBuilder();
                sb.append("The following files have been copied into Scrip du Jour's data directory:");
                sb.append(System.getProperty("line.separator"));
                for (String s : successList) {
                    sb.append(s).append(System.getProperty("line.separator"));
                }
                sb.append("You can delete these files if you wish.");
                JOptionPane.showMessageDialog(this, sb.toString(), "Files Copied Successfully", 1);
            }
            this.tabList = null;
            this.createTabs();
        }
    }

    private void aboutMenuActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    private void menuNextDayActionPerformed(ActionEvent evt) {
        this.next(DateChangeMode.DAY);
    }

    private void menuTodayActionPerformed(ActionEvent evt) {
        this.today();
    }

    private void menuPreviousDayActionPerformed(ActionEvent evt) {
        this.previous(DateChangeMode.DAY);
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        this.today();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.next(DateChangeMode.DAY);
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        this.previous(DateChangeMode.DAY);
    }

    void today() {
        this.currentDate.setTime(new Date());
        this.updateDisplay();
    }

    void next(DateChangeMode changeBy) {
        switch (changeBy) {
            case DAY: {
                this.currentDate.add(5, 1);
                break;
            }
            case WEEK: {
                this.currentDate.add(3, 1);
                break;
            }
            case MONTH: {
                this.currentDate.add(2, 1);
                break;
            }
            default: {
                this.logger.warn((Object)("INVALID CHANGE MODE: " + (Object)((Object)changeBy)));
            }
        }
        this.updateDisplay();
    }

    void previous(DateChangeMode changeBy) {
        switch (changeBy) {
            case DAY: {
                this.currentDate.add(5, -1);
                break;
            }
            case WEEK: {
                this.currentDate.add(3, -1);
                break;
            }
            case MONTH: {
                this.currentDate.add(2, -1);
                break;
            }
            default: {
                this.logger.warn((Object)("INVALID CHANGE MODE: " + (Object)((Object)changeBy)));
            }
        }
        this.updateDisplay();
    }

    public void newVersionAvailable() {
        this.updateButton.setVisible(true);
    }

    protected List<TabPanel> getTabList() {
        return this.tabList;
    }

    private void menuItemExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void defineMenuActionPerformed(ActionEvent evt) {
        TabPanel tp = (TabPanel)this.tabPane.getSelectedComponent();
        DefinitionDialog def = new DefinitionDialog((Frame)SDJMain.getMainWindow(), false);
        def.setVisible(true);
        def.define(tp.getWordToDefine());
    }

    private void updateDisplay() {
        this.lblDate.setText("Showing data for " + this.dateFormatter.format(this.currentDate.getTime()));
        this.setCursor(Cursor.getPredefinedCursor(3));
        final WaitDialog wait = new WaitDialog((Frame)SDJMain.getMainWindow(), true, "Updating display...");
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new UpdateDisplay();
            }

            @Override
            public void finished() {
                while (!wait.isVisible()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        MainWindow.this.logger.warn((Object)"Interrupted.", (Throwable)e);
                    }
                }
                wait.setVisible(false);
                wait.dispose();
                MainWindow.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.start();
        wait.setVisible(true);
    }

    private void createTabs() {
        this.lblDate.setText("Showing data for " + this.dateFormatter.format(this.currentDate.getTime()));
        this.setCursor(Cursor.getPredefinedCursor(3));
        final WaitDialog wait = new WaitDialog((Frame)SDJMain.getMainWindow(), true, "Updating display...");
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new CreateTabs();
            }

            @Override
            public void finished() {
                while (!wait.isVisible()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        MainWindow.this.logger.warn((Object)"Interrupted.", (Throwable)e);
                    }
                }
                wait.setVisible(false);
                wait.dispose();
                MainWindow.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.start();
        wait.setVisible(true);
    }

    class ToolsMenuHandler
    implements MenuListener {
        ToolsMenuHandler() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            Component c = MainWindow.this.tabPane.getSelectedComponent();
            if (c instanceof TabPanel) {
                TabPanel tp = (TabPanel)c;
                String word = tp.getWordToDefine();
                JMenu m = (JMenu)e.getSource();
                for (Component menu : m.getMenuComponents()) {
                    JMenuItem jmenu;
                    String name;
                    if (!(menu instanceof JMenuItem) || (name = (jmenu = (JMenuItem)menu).getName()) == null || !name.equals("define")) continue;
                    if (word == null) {
                        jmenu.setText("Define");
                        jmenu.setEnabled(false);
                        continue;
                    }
                    jmenu.setText("Define \"" + word + "\"");
                    jmenu.setEnabled(true);
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    class UpdateDisplay {
        UpdateDisplay() {
            Date date = MainWindow.this.currentDate.getTime();
            for (TabPanel tab : MainWindow.this.tabList) {
                tab.displayDataForDate(date);
                tab.updateTabTitle();
            }
        }
    }

    class CreateTabs {
        CreateTabs() {
            if (MainWindow.this.tabList == null) {
                MainWindow.this.tabList = TabBuilder.getInstance().createTabs();
            }
            MainWindow.this.tabPane.removeAll();
            if (MainWindow.this.tabList.size() > 0) {
                int index = 0;
                for (TabPanel tab : MainWindow.this.tabList) {
                    tab.displayDataForDate(MainWindow.this.currentDate.getTime());
                    MainWindow.this.tabPane.add(tab.getTabTitle(), tab);
                    tab.setIndex(index);
                    tab.setTabbedPane(MainWindow.this.tabPane);
                    ++index;
                }
            } else {
                JTextArea t = new JTextArea();
                t.setText("Welcome to Scrip du Jour!" + System.getProperty("line.separator") + System.getProperty("line.separator") + "The program is installed and ready to display things for you to read, " + "but there are no data files installed.  Use the \"Install Data Files\" option " + "in the \"File\" menu to locate and install data files.");
                t.setWrapStyleWord(true);
                t.setEditable(false);
                t.setLineWrap(true);
                MainWindow.this.tabPane.add(t);
            }
        }
    }

    static enum DateChangeMode {
        DAY,
        WEEK,
        MONTH;

    }
}

