/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import net.whirljack.sdj.PropertyManager;
import net.whirljack.sdj.gui.CyclingSpinnerListModel;
import net.whirljack.sdj.gui.MainWindow;
import net.whirljack.sdj.gui.TabPanel;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class PreferencesDialog
extends JDialog {
    Logger logger = Logger.getLogger(PreferencesDialog.class);
    private Object[] hours = new Object[24];
    private Object[] minutes = new Object[60];
    private Object initialFontSize;
    private JButton btnCancel;
    private JRadioButton btnHide;
    private JRadioButton btnMinimize;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private JCheckBox cbxAlarm;
    private JCheckBox cbxUpdates;
    private JComboBox cmbFont;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblHide;
    private JLabel lblTime;
    private JSpinner spnHour;
    private JSpinner spnMinute;

    public PreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        int i;
        for (i = 0; i < 24; ++i) {
            this.hours[i] = new Integer(i);
        }
        for (i = 0; i < 60; ++i) {
            this.minutes[i] = new Integer(i);
        }
        this.initComponents();
        Integer h = 0;
        Integer m = 0;
        try {
            String time = PropertyManager.getInstance().getProperty("sdj.alarmClockTime");
            StringTokenizer tok = new StringTokenizer(time, ".");
            String hour = tok.nextToken();
            String minute = tok.nextToken();
            h = new Integer(hour);
            m = new Integer(minute);
        }
        catch (Exception e) {
            this.logger.error((Object)"There was an error creating the preferences dialog.", (Throwable)e);
            JOptionPane.showMessageDialog(this, "There was an error creating the Preferences dialog." + System.getProperty("line.separator") + "The error was: " + e.getMessage(), "Error", 0);
        }
        this.spnHour.setValue(h);
        this.spnMinute.setValue(m);
        this.cbxUpdates.setSelected(PropertyManager.getInstance().getPropertyAsBoolean("sdj.checkForUpdates"));
        this.cbxAlarm.setSelected(PropertyManager.getInstance().getPropertyAsBoolean("sdj.alarmClockMode"));
        if (PropertyManager.getInstance().getProperty("sdj.windowHideMode").equals("hide")) {
            this.btnHide.setSelected(true);
        } else {
            this.btnMinimize.setSelected(true);
        }
        boolean selected = this.cbxAlarm.isSelected();
        this.spnHour.setEnabled(selected);
        this.spnMinute.setEnabled(selected);
        this.lblTime.setEnabled(selected);
        this.lblHide.setEnabled(selected);
        this.btnHide.setEnabled(selected);
        this.btnMinimize.setEnabled(selected);
        this.getRootPane().setDefaultButton(this.btnOk);
        this.initialFontSize = this.cmbFont.getSelectedItem();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.cbxUpdates = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.cbxAlarm = new JCheckBox();
        this.lblTime = new JLabel();
        this.lblHide = new JLabel();
        this.spnHour = new JSpinner();
        this.jLabel1 = new JLabel();
        this.spnMinute = new JSpinner();
        this.btnMinimize = new JRadioButton();
        this.btnHide = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.cmbFont = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("ScripDuJour Preferences");
        this.setAlwaysOnTop(true);
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Updates"));
        this.cbxUpdates.setText("Check for Updates At Startup");
        this.cbxUpdates.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbxUpdates.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.cbxUpdates).addContainerGap(139, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.cbxUpdates).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Alarm Clock Mode"));
        this.cbxAlarm.setText("Enable Alarm Clock Mode");
        this.cbxAlarm.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbxAlarm.setMargin(new Insets(0, 0, 0, 0));
        this.cbxAlarm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cbxAlarmActionPerformed(evt);
            }
        });
        this.lblTime.setText("Display every day at this time:");
        this.lblHide.setText("Window hiding:");
        this.spnHour.setModel(new CyclingSpinnerListModel(this.hours));
        this.jLabel1.setText(":");
        this.spnMinute.setModel(new CyclingSpinnerListModel(this.minutes));
        this.buttonGroup1.add(this.btnMinimize);
        this.btnMinimize.setText("Minimize");
        this.btnMinimize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.btnMinimize.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.btnHide);
        this.btnHide.setText("Hide");
        this.btnHide.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.btnHide.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(22, 22, 22).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.lblHide).add((Component)this.lblTime)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnHide).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.spnHour, -2, 45, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.spnMinute, -2, 43, -2)).add((Component)this.btnMinimize))).add((Component)this.cbxAlarm)).addContainerGap(22, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.cbxAlarm).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblTime).add((Component)this.spnHour, -2, -1, -2).add((Component)this.spnMinute, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblHide).add((Component)this.btnMinimize)).addPreferredGap(0).add((Component)this.btnHide).addContainerGap(57, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Font Size"));
        this.cmbFont.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "10", "12", "14", "18", "20", "24", "30", "36"}));
        this.cmbFont.setSelectedItem(PropertyManager.getInstance().getProperty("sdj.font.size"));
        this.cmbFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cmbFontActionPerformed(evt);
            }
        });
        this.cmbFont.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PreferencesDialog.this.cmbFontPropertyChange(evt);
            }
        });
        this.jLabel2.setText("This font size will be used for the");
        this.jLabel3.setText("main window heading and text display.");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.cmbFont, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.cmbFont, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((Component)this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.btnCancel).addPreferredGap(0).add((Component)this.btnOk).add(9, 9, 9)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(3, 3, 3).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.btnOk).add((Component)this.btnCancel)).add(48, 48, 48)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 374) / 2, (screenSize.height - 416) / 2, 374, 416);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.cbxAlarm.isSelected()) {
            PropertyManager.getInstance().setProperty("sdj.alarmClockMode", "true");
            String time = this.spnHour.getValue().toString() + "." + this.spnMinute.getValue().toString();
            PropertyManager.getInstance().setProperty("sdj.alarmClockTime", time);
        } else {
            PropertyManager.getInstance().setProperty("sdj.alarmClockMode", "false");
        }
        if (this.cbxUpdates.isSelected()) {
            PropertyManager.getInstance().setProperty("sdj.checkForUpdates", "true");
        } else {
            PropertyManager.getInstance().setProperty("sdj.checkForUpdates", "false");
        }
        if (this.btnHide.isSelected()) {
            PropertyManager.getInstance().setProperty("sdj.windowHideMode", "hide");
        } else {
            PropertyManager.getInstance().setProperty("sdj.windowHideMode", "minimize");
        }
        PropertyManager.getInstance().setProperty("sdj.font.size", this.cmbFont.getSelectedItem().toString());
        this.setVisible(false);
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cmbFont.setSelectedItem(this.initialFontSize);
        this.setVisible(false);
        this.dispose();
    }

    private void cbxAlarmActionPerformed(ActionEvent evt) {
        boolean selected = this.cbxAlarm.isSelected();
        this.spnHour.setEnabled(selected);
        this.spnMinute.setEnabled(selected);
        this.lblTime.setEnabled(selected);
        this.lblHide.setEnabled(selected);
        this.btnHide.setEnabled(selected);
        this.btnMinimize.setEnabled(selected);
    }

    private void cmbFontPropertyChange(PropertyChangeEvent evt) {
    }

    private void cmbFontActionPerformed(ActionEvent evt) {
        float size = 12.0f;
        try {
            size = Float.valueOf(this.cmbFont.getSelectedItem().toString()).floatValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        List<TabPanel> tabs = ((MainWindow)this.getParent()).getTabList();
        for (TabPanel tab : tabs) {
            tab.updateFontSize(size);
        }
    }
}

