/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.XMLParser;
import net.whirljack.sdj.bo.SDJRootElement;
import net.whirljack.sdj.gui.SplashWindow;
import net.whirljack.sdj.gui.TabPanel;
import org.apache.log4j.Logger;

public class TabBuilder {
    private Logger logger = Logger.getLogger(TabBuilder.class);
    private static TabBuilder instance = null;
    private FileFilter fileFilter = new XMLFileFilter();

    private TabBuilder() {
    }

    public static TabBuilder getInstance() {
        if (instance == null) {
            instance = new TabBuilder();
        }
        return instance;
    }

    public List<TabPanel> createTabs() {
        Object[] files = SDJMain.getDataDir().listFiles(this.fileFilter);
        if (files != null) {
            Arrays.sort(files);
            this.logger.debug((Object)("Got " + files.length + " files."));
        }
        LinkedList<TabPanel> tabList = new LinkedList<TabPanel>();
        SDJRootElement root = null;
        for (Object file : files) {
            try {
                String name = ((File)file).getName();
                if (!name.endsWith(".xml")) continue;
                this.logger.debug((Object)("Parsing file " + ((File)file).getAbsolutePath()));
                root = XMLParser.getInstance().parseRootElement((File)file);
                if (root != null) {
                    tabList.add(new TabPanel(root));
                    continue;
                }
                this.logger.warn((Object)("XML file " + ((File)file).getAbsolutePath() + " does not appear to be a Scrip du Jour file."));
            }
            catch (Exception e) {
                SplashWindow.getInstance().close();
                this.logger.error((Object)"ERROR WHILE PARSING FILE.", (Throwable)e);
                JOptionPane.showMessageDialog(null, "There was an error while parsing file '" + ((File)file).getName() + System.getProperty("line.separator") + "I will attempt to continue, but the data in the bad file" + System.getProperty("line.separator") + "will not be used.  Perhaps the file was corrupted?" + System.getProperty("line.separator") + System.getProperty("line.separator") + "Hint: You can use Tools -> Delete Data Files to" + System.getProperty("line.separator") + "delete problem files.", "Parse Error", 2);
            }
        }
        return tabList;
    }

    private class XMLFileFilter
    implements FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            boolean ok = false;
            if (pathname != null && pathname.getName().toLowerCase().endsWith(".xml")) {
                ok = true;
            }
            return ok;
        }
    }
}

