/*
 * Decompiled with CFR 0.152.
 */
package net.whirljack.sdj.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.whirljack.sdj.PropertyManager;
import net.whirljack.sdj.SDJMain;
import net.whirljack.sdj.bo.SDJDataFile;
import net.whirljack.sdj.bo.SDJEntryElement;
import net.whirljack.sdj.bo.SDJRootElement;
import net.whirljack.sdj.gui.DefinitionDialog;
import net.whirljack.sdj.gui.MainWindow;
import net.whirljack.sdj.gui.SwingWorker;
import net.whirljack.sdj.gui.WaitDialog;
import org.apache.log4j.Logger;

public class TabPanel
extends JPanel {
    private Logger logger = Logger.getLogger(TabPanel.class);
    private SDJRootElement root;
    private SDJDataFile dataFile;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd");
    private Date currentDate = null;
    private int index;
    private JTabbedPane tabbedPane;
    private JCheckBox cbxRead;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JLabel lblDescription;
    private JMenuItem mnuDefine;
    private JMenuItem mnuNext;
    private JPopupMenu mnuPopup;
    private JMenuItem mnuPrevious;
    private JCheckBoxMenuItem mnuRead;
    private JMenuItem mnuToday;
    private JTextArea txtHeading;
    private JTextArea txtText;

    private TabPanel() {
    }

    public TabPanel(SDJRootElement root) throws Exception {
        this.root = root;
        this.dataFile = new SDJDataFile(root.getFile());
        this.initComponents();
    }

    public String getShortDescription() {
        return this.root.getShortDescription();
    }

    public String getTabTitle() {
        int unreadItemCount = this.dataFile.getUnreadItemCount();
        if (unreadItemCount == 0) {
            return this.getShortDescription();
        }
        return this.getShortDescription() + " [" + unreadItemCount + "]";
    }

    public void updateTabTitle() {
        this.tabbedPane.setTitleAt(this.index, this.getTabTitle());
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setTabbedPane(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void updateFontSize(float size) {
        this.txtHeading.setFont(this.txtHeading.getFont().deriveFont(size));
        this.txtText.setFont(this.txtText.getFont().deriveFont(size));
    }

    public void displayDataForDate(Date date) {
        this.logger.debug((Object)("Trying to find entry for date " + date.toString() + " - ignore year is " + this.root.isIgnoreYear()));
        this.currentDate = date;
        try {
            SDJEntryElement entry = this.dataFile.getEntryForDate(date);
            if (entry == null) {
                this.txtHeading.setText("No entry found for date.");
                this.txtText.setText("");
                this.cbxRead.setSelected(false);
                this.cbxRead.setEnabled(false);
            } else {
                this.txtHeading.setText(entry.getHeading());
                this.txtText.setText(entry.getText());
                this.cbxRead.setSelected(entry.isRead());
                this.cbxRead.setEnabled(true);
            }
            this.txtText.setSelectionStart(1);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error getting entry for date " + date), (Throwable)e);
        }
    }

    private void initComponents() {
        this.mnuPopup = new JPopupMenu();
        this.mnuPrevious = new JMenuItem();
        this.mnuToday = new JMenuItem();
        this.mnuNext = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mnuRead = new JCheckBoxMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mnuDefine = new JMenuItem();
        this.lblDescription = new JLabel();
        this.txtHeading = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.txtText = new JTextArea();
        this.cbxRead = new JCheckBox();
        this.mnuPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/back.png")));
        this.mnuPrevious.setText("Previous Day");
        this.mnuPrevious.setToolTipText("Go to the previous day.");
        this.mnuPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.mnuPreviousActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuPrevious);
        this.mnuToday.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/home.png")));
        this.mnuToday.setText("Today");
        this.mnuToday.setToolTipText("Go to today.");
        this.mnuToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.mnuTodayActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuToday);
        this.mnuNext.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/next.png")));
        this.mnuNext.setText("Next Day");
        this.mnuNext.setToolTipText("Go to the next day.");
        this.mnuNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.mnuNextActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuNext);
        this.mnuPopup.add(this.jSeparator1);
        this.mnuRead.setSelected(true);
        this.mnuRead.setText("I've read it");
        this.mnuRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.mnuReadActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuRead);
        this.mnuPopup.add(this.jSeparator2);
        this.mnuDefine.setIcon(new ImageIcon(this.getClass().getResource("/net/whirljack/sdj/images/dictionary.png")));
        this.mnuDefine.setText("Define");
        this.mnuDefine.setToolTipText("Define the selected word.");
        this.mnuDefine.setName("define");
        this.mnuDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.mnuDefineActionPerformed(evt);
            }
        });
        this.mnuPopup.add(this.mnuDefine);
        this.setLayout(new GridBagLayout());
        this.lblDescription.setFont(new Font("SansSerif", 3, 12));
        this.lblDescription.setText(this.root.getDescription());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblDescription, gridBagConstraints);
        this.txtHeading.setEditable(false);
        this.txtHeading.setFont(this.txtHeading.getFont().deriveFont(PropertyManager.getInstance().getPropertyAsFloat("sdj.font.size")));
        this.txtHeading.setLineWrap(true);
        this.txtHeading.setWrapStyleWord(true);
        this.txtHeading.setMargin(new Insets(3, 3, 3, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.txtHeading, gridBagConstraints);
        this.jScrollPane1.setAutoscrolls(true);
        this.txtText.setEditable(false);
        this.txtText.setFont(this.txtText.getFont().deriveFont(PropertyManager.getInstance().getPropertyAsFloat("sdj.font.size")));
        this.txtText.setLineWrap(true);
        this.txtText.setWrapStyleWord(true);
        this.txtText.setMargin(new Insets(3, 3, 3, 3));
        this.txtText.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TabPanel.this.txtTextMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TabPanel.this.txtTextMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.txtText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.cbxRead.setText("I've read it");
        this.cbxRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TabPanel.this.cbxReadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.cbxRead, gridBagConstraints);
    }

    private void cbxReadActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        final WaitDialog wait = new WaitDialog((Frame)SDJMain.getMainWindow(), true, "Updating file...");
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                return new UpdateReadFlag();
            }

            @Override
            public void finished() {
                while (!wait.isVisible()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception e) {
                        TabPanel.this.logger.warn((Object)"Interrupted.", (Throwable)e);
                    }
                }
                wait.setVisible(false);
                wait.dispose();
                TabPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        worker.start();
        wait.setVisible(true);
    }

    private void txtTextMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopup(evt);
        } else if (evt.getClickCount() == 2) {
            // empty if block
        }
    }

    public void showPopup(MouseEvent e) {
        if (e.getComponent() instanceof JTextArea) {
            for (Component c : this.mnuPopup.getComponents()) {
                JMenuItem menu;
                String name;
                if (c instanceof JCheckBoxMenuItem) {
                    ((JCheckBoxMenuItem)c).setSelected(this.cbxRead.isSelected());
                    continue;
                }
                if (!(c instanceof JMenuItem) || (name = (menu = (JMenuItem)c).getName()) == null || !name.equals("define")) continue;
                if (this.getWordToDefine() == null) {
                    menu.setText("Define");
                    menu.setEnabled(false);
                    continue;
                }
                menu.setText("Define \"" + this.getWordToDefine() + "\"");
                menu.setEnabled(true);
            }
            this.mnuPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public String getWordToDefine() {
        String selection = this.txtText.getSelectedText();
        String retString = null;
        if (selection != null && !selection.isEmpty() && !selection.contains(" ")) {
            StringBuilder sb = new StringBuilder();
            for (char c : selection.toCharArray()) {
                if (!Character.isLetter(c)) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                retString = sb.toString();
            }
        }
        return retString;
    }

    private void mnuNextActionPerformed(ActionEvent evt) {
        SDJMain.getMainWindow().next(MainWindow.DateChangeMode.DAY);
    }

    private void mnuTodayActionPerformed(ActionEvent evt) {
        SDJMain.getMainWindow().today();
    }

    private void mnuPreviousActionPerformed(ActionEvent evt) {
        SDJMain.getMainWindow().previous(MainWindow.DateChangeMode.DAY);
    }

    private void mnuReadActionPerformed(ActionEvent evt) {
        this.cbxRead.setSelected(!this.cbxRead.isSelected());
        this.cbxReadActionPerformed(null);
    }

    private void mnuDefineActionPerformed(ActionEvent evt) {
        DefinitionDialog def = new DefinitionDialog((Frame)SDJMain.getMainWindow(), false);
        def.setVisible(true);
        def.define(this.getWordToDefine());
    }

    private void txtTextMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.showPopup(evt);
        } else if (evt.getClickCount() == 2) {
            // empty if block
        }
    }

    public SDJDataFile getSdjDataFile() {
        return this.dataFile;
    }

    public int getUnreadItemCount() {
        return this.dataFile.getUnreadItemCount();
    }

    public SDJDataFile getDataFile() {
        return this.dataFile;
    }

    class UpdateReadFlag {
        UpdateReadFlag() {
            TabPanel.this.dataFile.setReadFlag(TabPanel.this.currentDate, TabPanel.this.cbxRead.isSelected());
            try {
                TabPanel.this.dataFile.write();
                TabPanel.this.updateTabTitle();
            }
            catch (Exception e) {
                TabPanel.this.logger.error((Object)"ERROR SAVING FILE.", (Throwable)e);
                JOptionPane.showMessageDialog(null, "There was an error while saving the file.\nError message: " + e.toString(), "Save Error", 0);
            }
        }
    }
}

