/*
 * Decompiled with CFR 0.152.
 */
package net.jeremybrooks.knicker;

import java.util.ArrayList;
import java.util.List;
import net.jeremybrooks.knicker.Knicker;
import net.jeremybrooks.knicker.KnickerException;
import net.jeremybrooks.knicker.Util;
import net.jeremybrooks.knicker.dto.AuthenticationToken;
import net.jeremybrooks.knicker.dto.Definition;
import net.jeremybrooks.knicker.dto.Example;
import net.jeremybrooks.knicker.dto.FrequencySummary;
import net.jeremybrooks.knicker.dto.Phrase;
import net.jeremybrooks.knicker.dto.Pronunciation;
import net.jeremybrooks.knicker.dto.PunctuationFactor;
import net.jeremybrooks.knicker.dto.Related;
import net.jeremybrooks.knicker.dto.SearchResult;
import net.jeremybrooks.knicker.dto.TokenStatus;
import net.jeremybrooks.knicker.dto.Word;
import net.jeremybrooks.knicker.dto.WordFrequency;
import net.jeremybrooks.knicker.dto.WordList;
import net.jeremybrooks.knicker.dto.WordListWord;
import net.jeremybrooks.knicker.dto.WordOfTheDay;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DTOBuilder {
    DTOBuilder() {
    }

    static Word buildWord(Document doc) throws KnickerException {
        Word w = new Word();
        try {
            w.setId(Util.getValueByXPath(doc, "/word/id"));
            w.setWordstring(Util.getValueByXPath(doc, "/word/wordstring"));
            w.setCanonicalForm(Util.getValueByXPath(doc, "/word/canonicalForm"));
            NodeList sugs = doc.getElementsByTagName("suggestions");
            for (int i = 0; i < sugs.getLength(); ++i) {
                Node sug = sugs.item(i);
                w.addSuggestion(Util.getNamedChildTextContent(sug, "suggestion"));
            }
        }
        catch (Exception e) {
            throw new KnickerException("Error while building Word.", e);
        }
        return w;
    }

    static List<Phrase> buildPhrase(Document doc) throws KnickerException {
        ArrayList<Phrase> phrases = new ArrayList<Phrase>();
        try {
            NodeList nodes = doc.getElementsByTagName("bigram");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Phrase p = new Phrase();
                Node node = nodes.item(i);
                p.setCount(Util.getNamedChildTextContentAsInt(node, "count"));
                p.setMi(Util.getNamedChildTextContent(node, "mi"));
                p.setWlmi(Util.getNamedChildTextContent(node, "wlmi"));
                p.setGram1(Util.getNamedChildTextContent(node, "gram1"));
                p.setGram2(Util.getNamedChildTextContent(node, "gram2"));
                phrases.add(p);
            }
        }
        catch (Exception e) {
            throw new KnickerException("Error while building BiGram list.", e);
        }
        return phrases;
    }

    static List<Definition> buildDefinitions(Document doc) throws KnickerException {
        ArrayList<Definition> definitions = new ArrayList<Definition>();
        NodeList defNodes = doc.getElementsByTagName("definition");
        for (int i = 0; i < defNodes.getLength(); ++i) {
            Node examplesNode;
            Node notesNode;
            Node labelsNode;
            Definition definition = new Definition();
            Node defNode = defNodes.item(i);
            NamedNodeMap nnm = defNode.getAttributes();
            definition.setSequence(Util.getAttributeAsInt(nnm, "sequence"));
            definition.setId(Util.getAttribute(nnm, "id"));
            definition.setText(Util.getNamedChildTextContent(defNode, "text"));
            definition.setHeadword(Util.getNamedChildTextContent(defNode, "headword"));
            definition.setPartOfSpeech(Util.getNamedChildTextContent(defNode, "partOfSpeech"));
            definition.setSeqString(Util.getNamedChildTextContent(defNode, "seqString"));
            Node citeNode = Util.getNamedChildNode(defNode, "citations");
            if (citeNode != null) {
                NodeList citeNodes = citeNode.getChildNodes();
                for (int j = 0; j < citeNodes.getLength(); ++j) {
                    Node cite = citeNodes.item(j);
                    if (!cite.getNodeName().equals("citation")) continue;
                    definition.addCitation(Util.getNamedChildTextContent(cite, "cite"), Util.getNamedChildTextContent(cite, "source"));
                }
            }
            if ((labelsNode = Util.getNamedChildNode(defNode, "labels")) != null) {
                NodeList labelNodes = labelsNode.getChildNodes();
                for (int j = 0; j < labelNodes.getLength(); ++j) {
                    Node node = labelNodes.item(j);
                    if (!node.getNodeName().equals("label")) continue;
                    definition.addLabel(Util.getAttribute(node.getAttributes(), "type"), Util.getNamedChildTextContent(node, "text"));
                }
            }
            if ((notesNode = Util.getNamedChildNode(defNode, "notes")) != null) {
                NodeList noteNodes = notesNode.getChildNodes();
                for (int j = 0; j < noteNodes.getLength(); ++j) {
                    Node node = noteNodes.item(j);
                    if (!node.getNodeName().equals("note")) continue;
                    definition.addNote(Util.getAttributeAsInt(node.getAttributes(), "pos"), Util.getNamedChildTextContent(node, "value"));
                }
            }
            if ((examplesNode = Util.getNamedChildNode(defNode, "exampleUses")) != null) {
                NodeList exampleNodes = examplesNode.getChildNodes();
                for (int j = 0; j < exampleNodes.getLength(); ++j) {
                    Node node = exampleNodes.item(j);
                    if (!node.getNodeName().equals("exampleUsage")) continue;
                    definition.addExampleUse(Util.getNamedChildTextContent(node, "text"));
                }
            }
            definitions.add(definition);
        }
        return definitions;
    }

    public static List<Example> buildExamples(Document doc) throws KnickerException {
        ArrayList<Example> examples = new ArrayList<Example>();
        NodeList exampleNodes = doc.getElementsByTagName("example");
        for (int i = 0; i < exampleNodes.getLength(); ++i) {
            Example example = new Example();
            Node exampleNode = exampleNodes.item(i);
            example.setDisplay(Util.getNamedChildTextContent(exampleNode, "display"));
            example.setDocumentId(Util.getNamedChildTextContent(exampleNode, "documentId"));
            example.setExampleId(Util.getNamedChildTextContent(exampleNode, "exampleId"));
            example.setScoreId(Util.getNamedChildTextContent(exampleNode, "scoreId"));
            example.setRating(Util.getNamedChildTextContent(exampleNode, "rating"));
            example.setTitle(Util.getNamedChildTextContent(exampleNode, "title"));
            example.setUrl(Util.getNamedChildTextContent(exampleNode, "url"));
            example.setWordstring(Util.getNamedChildTextContent(exampleNode, "wordstring"));
            example.setYear(Util.getNamedChildTextContent(exampleNode, "year"));
            NodeList providerNodes = exampleNode.getChildNodes();
            for (int j = 0; j < providerNodes.getLength(); ++j) {
                Node node = providerNodes.item(j);
                if (!node.getNodeName().equals("provider")) continue;
                example.addProvider(Util.getNamedChildTextContent(node, "id"), Util.getNamedChildTextContent(node, "name"));
            }
            examples.add(example);
        }
        return examples;
    }

    static List<Related> buildRelated(Document doc) throws KnickerException {
        ArrayList<Related> relateds = new ArrayList<Related>();
        NodeList relatedNodes = doc.getElementsByTagName("related");
        if (relatedNodes != null) {
            for (int i = 0; i < relatedNodes.getLength(); ++i) {
                Node node = relatedNodes.item(i);
                Related r = new Related();
                r.setRelType(Util.getAttribute(node.getAttributes(), "relType"));
                NodeList wsNodes = Util.getNamedChildNode(node, "wordstrings").getChildNodes();
                for (int j = 0; j < wsNodes.getLength(); ++j) {
                    Node wsNode = wsNodes.item(j);
                    if (!wsNode.getNodeName().equals("wordstring")) continue;
                    r.addWordstring(wsNode.getTextContent());
                }
                relateds.add(r);
            }
        }
        return relateds;
    }

    static FrequencySummary buildFrequencySummary(Document doc) throws KnickerException {
        FrequencySummary fs = new FrequencySummary();
        fs.setFrequencyString(Util.getValueByXPath(doc, "/frequencySummary/frequencyString"));
        fs.setTotalCount(Util.getValueByXPathAsInt(doc, "/frequencySummary/totalCount"));
        fs.setUnknownYearCount(Util.getValueByXPathAsInt(doc, "/frequencySummary/unknownYearCount"));
        fs.setWordId(Util.getValueByXPath(doc, "/frequencySummary/wordId"));
        NodeList fNodes = doc.getElementsByTagName("frequency");
        if (fNodes != null) {
            for (int i = 0; i < fNodes.getLength(); ++i) {
                Node node = fNodes.item(i);
                fs.addFrequency(Util.getNamedChildTextContentAsInt(node, "count"), Util.getNamedChildTextContent(node, "year"));
            }
        }
        return fs;
    }

    static PunctuationFactor buildPunctuationFactor(Document doc) throws KnickerException {
        PunctuationFactor pf = new PunctuationFactor();
        pf.setExclamationPointCount(Util.getValueByXPathAsInt(doc, "/punctuationFactor/exclamationPointCount"));
        pf.setPeriodCount(Util.getValueByXPathAsInt(doc, "/punctuationFactor/periodCount"));
        pf.setQuestionMarkCount(Util.getValueByXPathAsInt(doc, "/punctuationFactor/questionMarkCount"));
        pf.setTotalCount(Util.getValueByXPathAsInt(doc, "/punctuationFactor/totalCount"));
        pf.setWordId(Util.getValueByXPath(doc, "/punctuationFactor/wordId"));
        return pf;
    }

    static List<Pronunciation> buildPronunciation(Document doc) throws KnickerException {
        ArrayList<Pronunciation> list = new ArrayList<Pronunciation>();
        NodeList nodes = doc.getElementsByTagName("textPron");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Pronunciation pron = new Pronunciation();
                pron.setId(Util.getNamedChildTextContent(node, "id"));
                pron.setRaw(Util.getNamedChildTextContent(node, "raw"));
                pron.setRawType(Util.getNamedChildTextContent(node, "rawType"));
                list.add(pron);
            }
        }
        return list;
    }

    static SearchResult buildSearchResult(Document doc) throws KnickerException {
        SearchResult result = new SearchResult();
        result.setMatches(Util.getValueByXPathAsInt(doc, "/searchResult/matches"));
        result.setMore(Util.getValueByXPathAsInt(doc, "/searchResult/more"));
        result.setSearchTermCount(Util.getValueByXPathAsInt(doc, "/searchResult/searchTerm/count"));
        result.setSearchTermWordstring(Util.getValueByXPath(doc, "/searchResult/searchTerm/wordstring"));
        NodeList matchNodes = doc.getElementsByTagName("match");
        if (matchNodes != null) {
            for (int i = 0; i < matchNodes.getLength(); ++i) {
                Node matchNode = matchNodes.item(i);
                result.addMatch(Util.getNamedChildTextContentAsInt(matchNode, "count"), Util.getNamedChildTextContent(matchNode, "wordstring"));
            }
        }
        return result;
    }

    static WordOfTheDay buildWordOfTheDay(Document doc) throws KnickerException {
        WordOfTheDay wotd = new WordOfTheDay();
        wotd.setId(Util.getValueByXPath(doc, "/wotd/@id"));
        wotd.setPublishDate(Util.getValueByXPath(doc, "/wotd/@publishDate"));
        wotd.setWordstring(Util.getValueByXPath(doc, "/wotd/wordstring"));
        NodeList nodes = Util.getNamedChildNode(doc, "wotd").getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("definition")) {
                wotd.addDefinition(Util.getNamedChildTextContent(node, "text"));
                continue;
            }
            if (node.getNodeName().equals("example")) {
                wotd.addExample(Util.getNamedChildTextContent(node, "text"));
                continue;
            }
            if (!node.getNodeName().equals("note")) continue;
            wotd.addNote(node.getTextContent());
        }
        return wotd;
    }

    static List<Word> buildWords(Document doc) throws KnickerException {
        ArrayList<Word> words = new ArrayList<Word>();
        try {
            NodeList nodes = Util.getNamedChildNode(doc, "words").getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Word word = new Word();
                word.setId(Util.getNamedChildTextContent(node, "id"));
                word.setWordstring(Util.getNamedChildTextContent(node, "wordstring"));
                words.add(word);
            }
        }
        catch (Exception e) {
            throw new KnickerException("Error parsing XML.", e);
        }
        return words;
    }

    static AuthenticationToken buildAuthenticationToken(Document doc) throws KnickerException {
        AuthenticationToken auth = new AuthenticationToken();
        auth.setToken(Util.getValueByXPath(doc, "/authenticationToken/token"));
        auth.setUserId(Util.getValueByXPath(doc, "/authenticationToken/userId"));
        return auth;
    }

    static TokenStatus buildTokenStatus(Document doc) throws KnickerException {
        TokenStatus status = new TokenStatus();
        try {
            status.setExpiresInMillis(Util.getValueByXPathAsLong(doc, "/apiTokenStatus/expiresInMillis"));
            status.setRemainingCalls(Util.getValueByXPathAsInt(doc, "/apiTokenStatus/remainingCalls"));
            status.setResetsInMillis(Util.getValueByXPathAsLong(doc, "/apiTokenStatus/resetsInMillis"));
            status.setToken(Util.getValueByXPath(doc, "/apiTokenStatus/token"));
            status.setTotalRequests(Util.getValueByXPathAsInt(doc, "/apiTokenStatus/totalRequests"));
            status.setValid(Util.getValueByXPathAsBoolean(doc, "/apiTokenStatus/valid"));
        }
        catch (Exception e) {
            throw new KnickerException("Error parsing token status.", e);
        }
        return status;
    }

    static WordList buildWordList(Document doc) throws KnickerException {
        WordList wordList = new WordList();
        try {
            wordList.setCreatedAt(Util.getValueByXPath(doc, "/wordList/createdAt"));
            wordList.setDescription(Util.getValueByXPath(doc, "/wordList/description"));
            wordList.setId(Util.getValueByXPath(doc, "/wordList/id"));
            wordList.setName(Util.getValueByXPath(doc, "/wordList/name"));
            wordList.setNumberWordsInList(Util.getValueByXPathAsInt(doc, "/wordList/numberWordsInList"));
            wordList.setPermalinkId(Util.getValueByXPath(doc, "/wordList/permalinkId"));
            wordList.setUpdatedAt(Util.getValueByXPath(doc, "/wordList/updatedAt"));
            wordList.setUserId(Util.getValueByXPath(doc, "/wordList/userId"));
            wordList.setUserName(Util.getValueByXPath(doc, "/wordList/userName"));
            String type = Util.getValueByXPath(doc, "/wordList/type");
            if (type.equalsIgnoreCase("PUBLIC")) {
                wordList.setType(Knicker.ListType.PUBLIC);
            } else if (type.equalsIgnoreCase("PRIVATE")) {
                wordList.setType(Knicker.ListType.PRIVATE);
            } else {
                wordList.setType(null);
            }
        }
        catch (Exception e) {
            throw new KnickerException("Error parsing word list XML.", e);
        }
        return wordList;
    }

    static List<WordList> buildWordLists(Document doc) throws KnickerException {
        ArrayList<WordList> list = new ArrayList<WordList>();
        try {
            NodeList wordLists = Util.getNamedChildNode(doc, "wordLists").getChildNodes();
            for (int i = 0; i < wordLists.getLength(); ++i) {
                Node listNode = wordLists.item(i);
                if (!listNode.getNodeName().equals("wordList")) continue;
                WordList wl = new WordList();
                wl.setCreatedAt(Util.getNamedChildTextContent(listNode, "createdAt"));
                wl.setDescription(Util.getNamedChildTextContent(listNode, "description"));
                wl.setId(Util.getNamedChildTextContent(listNode, "id"));
                wl.setName(Util.getNamedChildTextContent(listNode, "name"));
                wl.setNumberWordsInList(Util.getNamedChildTextContentAsInt(listNode, "numberWordsInList"));
                wl.setPermalinkId(Util.getNamedChildTextContent(listNode, "permalinkId"));
                wl.setUpdatedAt(Util.getNamedChildTextContent(listNode, "updatedAt"));
                wl.setUserId(Util.getNamedChildTextContent(listNode, "userId"));
                wl.setUserName(Util.getNamedChildTextContent(listNode, "userName"));
                String type = Util.getNamedChildTextContent(listNode, "type");
                if (type.equalsIgnoreCase("PUBLIC")) {
                    wl.setType(Knicker.ListType.PUBLIC);
                } else if (type.equalsIgnoreCase("PRIVATE")) {
                    wl.setType(Knicker.ListType.PRIVATE);
                } else {
                    wl.setType(null);
                }
                list.add(wl);
            }
        }
        catch (Exception e) {
            throw new KnickerException("Error parsing word list XML.", e);
        }
        return list;
    }

    static List<WordListWord> buildWordListWords(Document doc) throws KnickerException {
        ArrayList<WordListWord> list = new ArrayList<WordListWord>();
        NodeList wordNodes = Util.getNamedChildNode(doc, "wordListWords").getChildNodes();
        if (wordNodes != null) {
            for (int i = 0; i < wordNodes.getLength(); ++i) {
                Node node = wordNodes.item(i);
                if (!node.getNodeName().equals("wordListWord")) continue;
                WordListWord word = new WordListWord();
                word.setCreatedAt(Util.getNamedChildTextContent(node, "createdAt"));
                word.setNumberCommentsOnWord(Util.getNamedChildTextContentAsInt(node, "numberCommentsOnWord"));
                word.setNumberLists(Util.getNamedChildTextContentAsInt(node, "numberLists"));
                word.setUserId(Util.getNamedChildTextContent(node, "userId"));
                word.setUserName(Util.getNamedChildTextContent(node, "userName"));
                word.setWordstring(Util.getNamedChildTextContent(node, "wordstring"));
                list.add(word);
            }
        }
        return list;
    }

    static List<WordFrequency> buildWordFrequency(Document doc) throws KnickerException {
        ArrayList<WordFrequency> list = new ArrayList<WordFrequency>();
        NodeList wordNodes = Util.getNamedChildNode(doc, "wordFrequencies").getChildNodes();
        if (wordNodes != null) {
            for (int i = 0; i < wordNodes.getLength(); ++i) {
                Node node = wordNodes.item(i);
                if (!node.getNodeName().equals("wordFrequency")) continue;
                WordFrequency wf = new WordFrequency();
                wf.setCount(Util.getNamedChildTextContentAsInt(node, "count"));
                wf.setWordstring(Util.getNamedChildTextContent(node, "wordstring"));
                list.add(wf);
            }
        }
        return list;
    }
}

