/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class AntClassLoader
extends ClassLoader
implements SubBuildListener {
    private static final FileUtils fileUtils = FileUtils.newFileUtils();
    private static final int BUFFER_SIZE = 8192;
    private static final int NUMBER_OF_STRINGS = 256;
    private Vector pathComponents = new Vector();
    private Project project;
    private boolean parentFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable zipFiles = new Hashtable();
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;
    private static Method getProtectionDomain = null;
    private static Method defineClassProtectionDomain = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public AntClassLoader() {
        this.setParent(null);
    }

    public AntClassLoader(Project project, Path path) {
        this.setParent(null);
        this.setProject(project);
        this.setClassPath(path);
    }

    public AntClassLoader(ClassLoader classLoader, Project project, Path path, boolean bl) {
        this(project, path);
        if (classLoader != null) {
            this.setParent(classLoader);
        }
        this.setParentFirst(bl);
        this.addJavaLibraries();
    }

    public AntClassLoader(Project project, Path path, boolean bl) {
        this(null, project, path, bl);
    }

    public AntClassLoader(ClassLoader classLoader, boolean bl) {
        this.setParent(classLoader);
        this.project = null;
        this.parentFirst = bl;
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener(this);
        }
    }

    public void setClassPath(Path path) {
        this.pathComponents.removeAllElements();
        if (path != null) {
            Path path2 = path.concatSystemClasspath("ignore");
            String[] stringArray = path2.list();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    this.addPathElement(stringArray[n]);
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void setParent(ClassLoader classLoader) {
        this.parent = classLoader == null ? (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getClassLoader() : classLoader;
    }

    public void setParentFirst(boolean bl) {
        this.parentFirst = bl;
    }

    protected void log(String string, int n) {
        if (this.project != null) {
            this.project.log(string, n);
        }
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw new BuildException("Context loader has not been reset");
        }
        if (LoaderUtils.isContextLoaderAvailable()) {
            this.savedContextLoader = LoaderUtils.getContextClassLoader();
            ClassLoader classLoader = this;
            if (this.project != null && "only".equals(this.project.getProperty("build.sysclasspath"))) {
                classLoader = this.getClass().getClassLoader();
            }
            LoaderUtils.setContextClassLoader(classLoader);
            this.isContextLoaderSaved = true;
        }
    }

    public void resetThreadContextLoader() {
        if (LoaderUtils.isContextLoaderAvailable() && this.isContextLoaderSaved) {
            LoaderUtils.setContextClassLoader(this.savedContextLoader);
            this.savedContextLoader = null;
            this.isContextLoaderSaved = false;
        }
    }

    public void addPathElement(String string) throws BuildException {
        File file = this.project != null ? this.project.resolveFile(string) : new File(string);
        try {
            this.addPathFile(file);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    protected void addPathFile(File file) throws IOException {
        this.pathComponents.addElement(file);
    }

    public String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(System.getProperty("path.separator"));
            } else {
                bl = false;
            }
            stringBuffer.append(((File)enumeration.nextElement()).getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    public synchronized void setIsolated(boolean bl) {
        this.ignoreBase = bl;
    }

    public static void initializeClass(Class clazz) {
        block2: {
            Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
            if (constructorArray == null || constructorArray.length <= 0 || constructorArray[0] == null) break block2;
            Object[] objectArray = new String[256];
            try {
                constructorArray[0].newInstance(objectArray);
            }
            catch (Throwable throwable) {}
        }
    }

    public void addSystemPackageRoot(String string) {
        this.systemPackages.addElement(string + (string.endsWith(".") ? "" : "."));
    }

    public void addLoaderPackageRoot(String string) {
        this.loaderPackages.addElement(string + (string.endsWith(".") ? "" : "."));
    }

    public Class forceLoadClass(String string) throws ClassNotFoundException {
        this.log("force loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        return clazz;
    }

    public Class forceLoadSystemClass(String string) throws ClassNotFoundException {
        this.log("force system loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findBaseClass(string);
        }
        return clazz;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.isParentFirst(string)) {
            inputStream = this.loadBaseResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from parent loader", 4);
            } else {
                inputStream = this.loadResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from ant loader", 4);
                }
            }
        } else {
            inputStream = this.loadResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from ant loader", 4);
            } else {
                inputStream = this.loadBaseResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from parent loader", 4);
                }
            }
        }
        if (inputStream == null) {
            this.log("Couldn't load ResourceStream for " + string, 4);
        }
        return inputStream;
    }

    private InputStream loadResource(String string) {
        InputStream inputStream = null;
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements() && inputStream == null) {
            File file = (File)enumeration.nextElement();
            inputStream = this.getResourceStream(file, string);
        }
        return inputStream;
    }

    private InputStream loadBaseResource(String string) {
        if (this.parent == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return this.parent.getResourceAsStream(string);
    }

    private InputStream getResourceStream(File file, String string) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    return new FileInputStream(file2);
                }
            } else {
                ZipEntry zipEntry;
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    return zipFile.getInputStream(zipEntry);
                }
            }
        }
        catch (Exception exception) {
            this.log("Ignoring Exception " + exception.getClass().getName() + ": " + exception.getMessage() + " reading resource " + string + " from " + file, 3);
        }
        return null;
    }

    private boolean isParentFirst(String string) {
        Object object;
        boolean bl = this.parentFirst;
        Enumeration enumeration = this.systemPackages.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!string.startsWith((String)object)) continue;
            bl = true;
            break;
        }
        object = this.loaderPackages.elements();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            if (!string.startsWith(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public URL getResource(String string) {
        URL uRL = null;
        if (this.isParentFirst(string)) {
            URL uRL2 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
        }
        if (uRL != null) {
            this.log("Resource " + string + " loaded from parent loader", 4);
        } else {
            Enumeration enumeration = this.pathComponents.elements();
            while (enumeration.hasMoreElements() && uRL == null) {
                File file = (File)enumeration.nextElement();
                uRL = this.getResourceURL(file, string);
                if (uRL == null) continue;
                this.log("Resource " + string + " loaded from ant loader", 4);
            }
        }
        if (uRL == null && !this.isParentFirst(string)) {
            URL uRL3 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
            if (uRL != null) {
                this.log("Resource " + string + " loaded from parent loader", 4);
            }
        }
        if (uRL == null) {
            this.log("Couldn't load Resource " + string, 4);
        }
        return uRL;
    }

    protected Enumeration findResources(String string) throws IOException {
        return new ResourceEnumeration(string);
    }

    protected URL getResourceURL(File file, String string) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    try {
                        return fileUtils.getFileURL(file2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            } else {
                ZipEntry zipEntry;
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    try {
                        return new URL("jar:" + fileUtils.getFileURL(file) + "!/" + zipEntry);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isParentFirst(string)) {
            try {
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader " + "(parentFirst)", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader " + "(parentFirst)", 4);
            }
        } else {
            try {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.ignoreBase) {
                    throw classNotFoundException;
                }
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader", 4);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private String getClassFilename(String string) {
        return string.replace('.', '/') + ".class";
    }

    protected Class defineClassFromData(File file, byte[] byArray, String string) throws IOException {
        if (defineClassProtectionDomain != null) {
            try {
                Object object = getProtectionDomain.invoke((Object)(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntClassLoader.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project), new Object[0]);
                Object[] objectArray = new Object[]{string, byArray, new Integer(0), new Integer(byArray.length), object};
                return (Class)defineClassProtectionDomain.invoke((Object)this, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassFormatError) {
                    throw (ClassFormatError)throwable;
                }
                if (throwable instanceof NoClassDefFoundError) {
                    throw (NoClassDefFoundError)throwable;
                }
                if (throwable instanceof SecurityException) {
                    throw (SecurityException)throwable;
                }
                throw new IOException(throwable.toString());
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private Class getClassFromStream(InputStream inputStream, String string, File file) throws IOException, SecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return this.defineClassFromData(file, byArray2, string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        this.log("Finding class " + string, 4);
        return this.findClassInComponents(string);
    }

    protected boolean isInPath(File file) {
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements()) {
            File file2 = (File)enumeration.nextElement();
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassInComponents(String string) throws ClassNotFoundException {
        InputStream inputStream = null;
        String string2 = this.getClassFilename(string);
        try {
            Enumeration enumeration = this.pathComponents.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    throw new ClassNotFoundException(string);
                }
                File file = (File)enumeration.nextElement();
                inputStream = this.getResourceStream(file, string2);
                if (inputStream == null) continue;
                this.log("Loaded from " + file + " " + string2, 4);
                Class clazz = this.getClassFromStream(inputStream, string, file);
                Object var9_9 = null;
                try {
                    if (inputStream == null) return clazz;
                    inputStream.close();
                    return clazz;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return clazz;
                catch (SecurityException securityException) {
                    throw securityException;
                }
                catch (IOException iOException) {
                    this.log("Exception reading component " + file + " (reason: " + iOException.getMessage() + ")", 3);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
    }

    private Class findBaseClass(String string) throws ClassNotFoundException {
        if (this.parent == null) {
            return this.findSystemClass(string);
        }
        return this.parent.loadClass(string);
    }

    public synchronized void cleanup() {
        Enumeration enumeration = this.zipFiles.elements();
        while (enumeration.hasMoreElements()) {
            ZipFile zipFile = (ZipFile)enumeration.nextElement();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.zipFiles = new Hashtable();
        if (this.project != null) {
            this.project.removeBuildListener(this);
        }
        this.project = null;
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.cleanup();
    }

    public void subBuildFinished(BuildEvent buildEvent) {
        if (buildEvent.getProject() == this.project) {
            this.cleanup();
        }
    }

    public void subBuildStarted(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    public void addJavaLibraries() {
        Vector vector = JavaEnvUtils.getJrePackages();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.addSystemPackageRoot(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            getProtectionDomain = (class$java$lang$Class == null ? (class$java$lang$Class = AntClassLoader.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getProtectionDomain", new Class[0]);
            Class<?> clazz = Class.forName("java.security.ProtectionDomain");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AntClassLoader.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = AntClassLoader.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, clazz};
            defineClassProtectionDomain = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AntClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", classArray);
        }
        catch (Exception exception) {}
    }

    private class ResourceEnumeration
    implements Enumeration {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String string) {
            this.resourceName = string;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        public Object nextElement() {
            URL uRL = this.nextResource;
            this.findNextResource();
            return uRL;
        }

        private void findNextResource() {
            URL uRL = null;
            while (this.pathElementsIndex < AntClassLoader.this.pathComponents.size() && uRL == null) {
                try {
                    File file = (File)AntClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    uRL = AntClassLoader.this.getResourceURL(file, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
            }
            this.nextResource = uRL;
        }
    }
}

