/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Definer;
import org.apache.tools.ant.taskdefs.Typedef;

public class ComponentHelper {
    private AntTypeTable antTypeTable;
    private Hashtable taskClassDefinitions = new Hashtable();
    private boolean rebuildTaskClassDefinitions = true;
    private Hashtable typeClassDefinitions = new Hashtable();
    private boolean rebuildTypeClassDefinitions = true;
    private Set checkedNamespaces = new HashSet();
    private Stack antLibStack = new Stack();
    private String antLibCurrentUri = null;
    private Hashtable createdTasks = new Hashtable();
    private ComponentHelper next;
    private Project project;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskAdapter;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Property;

    public static ComponentHelper getComponentHelper(Project project) {
        ComponentHelper componentHelper = (ComponentHelper)project.getReference("ant.ComponentHelper");
        if (componentHelper != null) {
            return componentHelper;
        }
        componentHelper = new ComponentHelper();
        componentHelper.setProject(project);
        project.addReference("ant.ComponentHelper", componentHelper);
        return componentHelper;
    }

    protected ComponentHelper() {
    }

    public void setNext(ComponentHelper componentHelper) {
        this.next = componentHelper;
    }

    public ComponentHelper getNext() {
        return this.next;
    }

    public void setProject(Project project) {
        this.project = project;
        this.antTypeTable = new AntTypeTable(project);
    }

    public void initSubProject(ComponentHelper componentHelper) {
        Object object;
        AntTypeTable antTypeTable = componentHelper.antTypeTable;
        Iterator iterator = antTypeTable.values().iterator();
        while (iterator.hasNext()) {
            object = (AntTypeDefinition)iterator.next();
            this.antTypeTable.put(((AntTypeDefinition)object).getName(), object);
        }
        object = componentHelper.checkedNamespaces.iterator();
        while (object.hasNext()) {
            this.checkedNamespaces.add(object.next());
        }
    }

    public Object createComponent(UnknownElement unknownElement, String string, String string2) throws BuildException {
        Object object = this.createComponent(string2);
        if (object == null) {
            return null;
        }
        if (object instanceof Task) {
            Task task = (Task)object;
            task.setLocation(unknownElement.getLocation());
            task.setTaskType(string2);
            task.setTaskName(unknownElement.getTaskName());
            task.setOwningTarget(unknownElement.getOwningTarget());
            task.init();
            this.addCreatedTask(string2, task);
        }
        return object;
    }

    public Object createComponent(String string) {
        AntTypeDefinition antTypeDefinition = this.getDefinition(string);
        if (antTypeDefinition == null) {
            return null;
        }
        return antTypeDefinition.create(this.project);
    }

    public Class getComponentClass(String string) {
        AntTypeDefinition antTypeDefinition = this.getDefinition(string);
        if (antTypeDefinition == null) {
            return null;
        }
        return antTypeDefinition.getExposedClass(this.project);
    }

    public AntTypeDefinition getDefinition(String string) {
        this.checkNamespace(string);
        AntTypeDefinition antTypeDefinition = null;
        antTypeDefinition = this.antTypeTable.getDefinition(string);
        return antTypeDefinition;
    }

    public void initDefaultDefinitions() {
        this.initTasks();
        this.initTypes();
    }

    public void addTaskDefinition(String string, Class clazz) {
        this.checkTaskClass(clazz);
        AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
        antTypeDefinition.setName(string);
        antTypeDefinition.setClassLoader(clazz.getClassLoader());
        antTypeDefinition.setClass(clazz);
        antTypeDefinition.setAdapterClass(class$org$apache$tools$ant$TaskAdapter == null ? (class$org$apache$tools$ant$TaskAdapter = ComponentHelper.class$("org.apache.tools.ant.TaskAdapter")) : class$org$apache$tools$ant$TaskAdapter);
        antTypeDefinition.setClassName(clazz.getName());
        antTypeDefinition.setAdaptToClass(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task);
        this.updateDataTypeDefinition(antTypeDefinition);
    }

    public void checkTaskClass(Class clazz) throws BuildException {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            String string = clazz + " is not public";
            this.project.log(string, 0);
            throw new BuildException(string);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            String string = clazz + " is abstract";
            this.project.log(string, 0);
            throw new BuildException(string);
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "No public no-arg constructor in " + clazz;
            this.project.log(string, 0);
            throw new BuildException(string);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) {
            TaskAdapter.checkTaskClass(clazz, this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTaskDefinitions() {
        Hashtable hashtable = this.taskClassDefinitions;
        synchronized (hashtable) {
            AntTypeTable antTypeTable = this.antTypeTable;
            synchronized (antTypeTable) {
                if (this.rebuildTaskClassDefinitions) {
                    this.taskClassDefinitions.clear();
                    Iterator iterator = this.antTypeTable.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Class clazz = this.antTypeTable.getExposedClass(string);
                        if (clazz == null || !(class$org$apache$tools$ant$Task == null ? ComponentHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) continue;
                        this.taskClassDefinitions.put(string, this.antTypeTable.getTypeClass(string));
                    }
                    this.rebuildTaskClassDefinitions = false;
                }
            }
        }
        return this.taskClassDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDataTypeDefinitions() {
        Hashtable hashtable = this.typeClassDefinitions;
        synchronized (hashtable) {
            AntTypeTable antTypeTable = this.antTypeTable;
            synchronized (antTypeTable) {
                if (this.rebuildTypeClassDefinitions) {
                    this.typeClassDefinitions.clear();
                    Iterator iterator = this.antTypeTable.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        Class clazz = this.antTypeTable.getExposedClass(string);
                        if (clazz == null || (class$org$apache$tools$ant$Task == null ? ComponentHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) continue;
                        this.typeClassDefinitions.put(string, this.antTypeTable.getTypeClass(string));
                    }
                    this.rebuildTypeClassDefinitions = false;
                }
            }
        }
        return this.typeClassDefinitions;
    }

    public void addDataTypeDefinition(String string, Class clazz) {
        AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
        antTypeDefinition.setName(string);
        antTypeDefinition.setClass(clazz);
        this.updateDataTypeDefinition(antTypeDefinition);
        String string2 = " +User datatype: " + string + "     " + clazz.getName();
        this.project.log(string2, 4);
    }

    public void addDataTypeDefinition(AntTypeDefinition antTypeDefinition) {
        this.updateDataTypeDefinition(antTypeDefinition);
    }

    public Hashtable getAntTypeTable() {
        return this.antTypeTable;
    }

    public Task createTask(String string) throws BuildException {
        Task task = this.createNewTask(string);
        if (task == null && string.equals("property")) {
            this.addTaskDefinition("property", class$org$apache$tools$ant$taskdefs$Property == null ? (class$org$apache$tools$ant$taskdefs$Property = ComponentHelper.class$("org.apache.tools.ant.taskdefs.Property")) : class$org$apache$tools$ant$taskdefs$Property);
            task = this.createNewTask(string);
        }
        if (task != null) {
            this.addCreatedTask(string, task);
        }
        return task;
    }

    private Task createNewTask(String string) throws BuildException {
        Class clazz = this.getComponentClass(string);
        if (clazz == null) {
            return null;
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) {
            return null;
        }
        Task task = (Task)this.createComponent(string);
        if (task == null) {
            return null;
        }
        task.setTaskType(string);
        task.setTaskName(string);
        String string2 = "   +Task: " + string;
        this.project.log(string2, 4);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCreatedTask(String string, Task task) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector<WeakReference<Task>> vector = (Vector<WeakReference<Task>>)this.createdTasks.get(string);
            if (vector == null) {
                vector = new Vector<WeakReference<Task>>();
                this.createdTasks.put(string, vector);
            }
            vector.addElement(new WeakReference<Task>(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCreatedTasks(String string) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector vector = (Vector)this.createdTasks.get(string);
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    WeakReference weakReference = (WeakReference)enumeration.nextElement();
                    Task task = (Task)weakReference.get();
                    if (task == null) continue;
                    task.markInvalid();
                }
                vector.removeAllElements();
                this.createdTasks.remove(string);
            }
        }
    }

    public Object createDataType(String string) throws BuildException {
        return this.createComponent(string);
    }

    public String getElementName(Object object) {
        Class<?> clazz = object.getClass();
        Iterator iterator = this.antTypeTable.values().iterator();
        while (iterator.hasNext()) {
            AntTypeDefinition antTypeDefinition = (AntTypeDefinition)iterator.next();
            if (clazz != antTypeDefinition.getExposedClass(this.project)) continue;
            return "The <" + antTypeDefinition.getName() + "> type";
        }
        return "Class " + clazz.getName();
    }

    private boolean validDefinition(AntTypeDefinition antTypeDefinition) {
        return antTypeDefinition.getTypeClass(this.project) != null && antTypeDefinition.getExposedClass(this.project) != null;
    }

    private boolean sameDefinition(AntTypeDefinition antTypeDefinition, AntTypeDefinition antTypeDefinition2) {
        if (!this.validDefinition(antTypeDefinition) || !this.validDefinition(antTypeDefinition2)) {
            return this.validDefinition(antTypeDefinition) == this.validDefinition(antTypeDefinition2);
        }
        return antTypeDefinition.sameDefinition(antTypeDefinition2, this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeDefinition(AntTypeDefinition antTypeDefinition) {
        String string = antTypeDefinition.getName();
        AntTypeTable antTypeTable = this.antTypeTable;
        synchronized (antTypeTable) {
            this.rebuildTaskClassDefinitions = true;
            this.rebuildTypeClassDefinitions = true;
            AntTypeDefinition antTypeDefinition2 = this.antTypeTable.getDefinition(string);
            if (antTypeDefinition2 != null) {
                Class clazz;
                if (this.sameDefinition(antTypeDefinition, antTypeDefinition2)) {
                    return;
                }
                int n = 1;
                if (antTypeDefinition.similarDefinition(antTypeDefinition2, this.project)) {
                    n = 3;
                }
                boolean bl = (clazz = this.antTypeTable.getExposedClass(string)) != null && (class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(clazz);
                this.project.log("Trying to override old definition of " + (bl ? "task" : "datatype") + " " + string, n);
                if (bl) {
                    this.invalidateCreatedTasks(string);
                }
            }
            this.project.log(" +Datatype " + string + " " + antTypeDefinition.getClassName(), 4);
            this.antTypeTable.put(string, antTypeDefinition);
        }
    }

    public void enterAntLib(String string) {
        this.antLibCurrentUri = string;
        this.antLibStack.push(string);
    }

    public String getCurrentAntlibUri() {
        return this.antLibCurrentUri;
    }

    public void exitAntLib() {
        this.antLibStack.pop();
        this.antLibCurrentUri = this.antLibStack.size() != 0 ? (String)this.antLibStack.peek() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTasks() {
        ClassLoader classLoader = null;
        if (this.project.getCoreLoader() != null && !"only".equals(this.project.getProperty("build.sysclasspath"))) {
            classLoader = this.project.getCoreLoader();
        }
        String string = "/org/apache/tools/ant/taskdefs/defaults.properties";
        InputStream inputStream = null;
        try {
            try {
                Properties properties = new Properties();
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    throw new BuildException("Can't load default task list");
                }
                properties.load(inputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
                    antTypeDefinition.setName(string2);
                    antTypeDefinition.setClassName(string3);
                    antTypeDefinition.setClassLoader(classLoader);
                    antTypeDefinition.setAdaptToClass(class$org$apache$tools$ant$Task == null ? ComponentHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task);
                    antTypeDefinition.setAdapterClass(class$org$apache$tools$ant$TaskAdapter == null ? ComponentHelper.class$("org.apache.tools.ant.TaskAdapter") : class$org$apache$tools$ant$TaskAdapter);
                    this.antTypeTable.put(string2, antTypeDefinition);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Can't load default type list");
            }
            Object var10_10 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTypes() {
        ClassLoader classLoader = null;
        if (this.project.getCoreLoader() != null && !"only".equals(this.project.getProperty("build.sysclasspath"))) {
            classLoader = this.project.getCoreLoader();
        }
        String string = "/org/apache/tools/ant/types/defaults.properties";
        InputStream inputStream = null;
        try {
            try {
                Properties properties = new Properties();
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    throw new BuildException("Can't load default datatype list");
                }
                properties.load(inputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
                    antTypeDefinition.setName(string2);
                    antTypeDefinition.setClassName(string3);
                    antTypeDefinition.setClassLoader(classLoader);
                    this.antTypeTable.put(string2, antTypeDefinition);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Can't load default type list");
            }
            Object var10_10 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        return;
    }

    private synchronized void checkNamespace(String string) {
        if (string.indexOf(58) == -1) {
            return;
        }
        String string2 = ProjectHelper.extractUriFromComponentName(string);
        if (!string2.startsWith("antlib:")) {
            return;
        }
        if (this.checkedNamespaces.contains(string2)) {
            return;
        }
        this.checkedNamespaces.add(string2);
        Typedef typedef = new Typedef();
        typedef.setProject(this.project);
        typedef.setURI(string2);
        typedef.setResource(string2.substring("antlib:".length()).replace('.', '/') + "/antlib.xml");
        typedef.setOnError(new Definer.OnError("ignore"));
        typedef.init();
        typedef.execute();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AntTypeTable
    extends Hashtable {
        private Project project;

        public AntTypeTable(Project project) {
            this.project = project;
        }

        public AntTypeDefinition getDefinition(String string) {
            AntTypeDefinition antTypeDefinition = (AntTypeDefinition)super.get(string);
            return antTypeDefinition;
        }

        public Object get(Object object) {
            return this.getTypeClass((String)object);
        }

        public Object create(String string) {
            AntTypeDefinition antTypeDefinition = this.getDefinition(string);
            if (antTypeDefinition == null) {
                return null;
            }
            return antTypeDefinition.create(this.project);
        }

        public Class getTypeClass(String string) {
            AntTypeDefinition antTypeDefinition = this.getDefinition(string);
            if (antTypeDefinition == null) {
                return null;
            }
            return antTypeDefinition.getTypeClass(this.project);
        }

        public Class getExposedClass(String string) {
            AntTypeDefinition antTypeDefinition = this.getDefinition(string);
            if (antTypeDefinition == null) {
                return null;
            }
            return antTypeDefinition.getExposedClass(this.project);
        }

        public boolean contains(Object object) {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                AntTypeDefinition antTypeDefinition = (AntTypeDefinition)iterator.next();
                Class clazz = antTypeDefinition.getExposedClass(this.project);
                if (clazz != object) continue;
                return true;
            }
            return false;
        }

        public boolean containsValue(Object object) {
            return this.contains(object);
        }
    }
}

