/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;

public class DefaultLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = StringUtils.LINE_SEP;
    protected boolean emacsMode = false;

    public void setMessageOutputLevel(int n) {
        this.msgOutputLevel = n;
    }

    public void setOutputPrintStream(PrintStream printStream) {
        this.out = new PrintStream(printStream, true);
    }

    public void setErrorPrintStream(PrintStream printStream) {
        this.err = new PrintStream(printStream, true);
    }

    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.startTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent buildEvent) {
        Throwable throwable = buildEvent.getException();
        StringBuffer stringBuffer = new StringBuffer();
        if (throwable == null) {
            stringBuffer.append(StringUtils.LINE_SEP);
            stringBuffer.append("BUILD SUCCESSFUL");
        } else {
            stringBuffer.append(StringUtils.LINE_SEP);
            stringBuffer.append("BUILD FAILED");
            stringBuffer.append(StringUtils.LINE_SEP);
            if (3 <= this.msgOutputLevel || !(throwable instanceof BuildException)) {
                stringBuffer.append(StringUtils.getStackTrace(throwable));
            } else if (throwable instanceof BuildException) {
                stringBuffer.append(throwable.toString()).append(lSep);
            } else {
                stringBuffer.append(throwable.getMessage()).append(lSep);
            }
        }
        stringBuffer.append(StringUtils.LINE_SEP);
        stringBuffer.append("Total time: ");
        stringBuffer.append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
        String string = stringBuffer.toString();
        if (throwable == null) {
            this.printMessage(string, this.out, 3);
        } else {
            this.printMessage(string, this.err, 0);
        }
        this.log(string);
    }

    public void targetStarted(BuildEvent buildEvent) {
        if (2 <= this.msgOutputLevel && !buildEvent.getTarget().getName().equals("")) {
            String string = StringUtils.LINE_SEP + buildEvent.getTarget().getName() + ":";
            this.printMessage(string, this.out, buildEvent.getPriority());
            this.log(string);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
        int n = buildEvent.getPriority();
        if (n <= this.msgOutputLevel) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            if (buildEvent.getTask() != null && !this.emacsMode) {
                string = buildEvent.getTask().getTaskName();
                String string2 = "[" + string + "] ";
                int n2 = 12 - string2.length();
                StringBuffer stringBuffer2 = new StringBuffer();
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer2.append(" ");
                    ++n3;
                }
                stringBuffer2.append(string2);
                string2 = stringBuffer2.toString();
                try {
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(buildEvent.getMessage()));
                    String string3 = bufferedReader.readLine();
                    boolean bl = true;
                    while (string3 != null) {
                        if (!bl) {
                            stringBuffer.append(StringUtils.LINE_SEP);
                        }
                        bl = false;
                        stringBuffer.append(string2).append(string3);
                        string3 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    stringBuffer.append(string2).append(buildEvent.getMessage());
                }
            } else {
                stringBuffer.append(buildEvent.getMessage());
            }
            string = stringBuffer.toString();
            if (n != 0) {
                this.printMessage(string, this.out, n);
            } else {
                this.printMessage(string, this.err, n);
            }
            this.log(string);
        }
    }

    protected static String formatTime(long l) {
        return DateUtils.formatElapsedTime(l);
    }

    protected void printMessage(String string, PrintStream printStream, int n) {
        printStream.println(string);
    }

    protected void log(String string) {
    }
}

