/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.tools.ant.Project;

public class DemuxOutputStream
extends OutputStream {
    private static final int MAX_SIZE = 1024;
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private Hashtable buffers = new Hashtable();
    private Project project;
    private boolean isErrorStream;

    public DemuxOutputStream(Project project, boolean bl) {
        this.project = project;
        this.isErrorStream = bl;
    }

    private BufferInfo getBufferInfo() {
        Thread thread = Thread.currentThread();
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(thread);
        if (bufferInfo == null) {
            bufferInfo = new BufferInfo();
            bufferInfo.buffer = new ByteArrayOutputStream(132);
            bufferInfo.crSeen = false;
            this.buffers.put(thread, bufferInfo);
        }
        return bufferInfo;
    }

    private void resetBufferInfo() {
        Thread thread = Thread.currentThread();
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(thread);
        try {
            bufferInfo.buffer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bufferInfo.buffer = new ByteArrayOutputStream();
        bufferInfo.crSeen = false;
    }

    private void removeBuffer() {
        Thread thread = Thread.currentThread();
        this.buffers.remove(thread);
    }

    public void write(int n) throws IOException {
        byte by = (byte)n;
        BufferInfo bufferInfo = this.getBufferInfo();
        if (by == 10) {
            bufferInfo.buffer.write(n);
            this.processBuffer(bufferInfo.buffer);
        } else {
            if (bufferInfo.crSeen) {
                this.processBuffer(bufferInfo.buffer);
            }
            bufferInfo.buffer.write(n);
        }
        bufferInfo.crSeen = by == 13;
        if (!bufferInfo.crSeen && bufferInfo.buffer.size() > 1024) {
            this.processBuffer(bufferInfo.buffer);
        }
    }

    protected void processBuffer(ByteArrayOutputStream byteArrayOutputStream) {
        String string = byteArrayOutputStream.toString();
        this.project.demuxOutput(string, this.isErrorStream);
        this.resetBufferInfo();
    }

    protected void processFlush(ByteArrayOutputStream byteArrayOutputStream) {
        String string = byteArrayOutputStream.toString();
        this.project.demuxFlush(string, this.isErrorStream);
        this.resetBufferInfo();
    }

    public void close() throws IOException {
        this.flush();
        this.removeBuffer();
    }

    public void flush() throws IOException {
        BufferInfo bufferInfo = this.getBufferInfo();
        if (bufferInfo.buffer.size() > 0) {
            this.processFlush(bufferInfo.buffer);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var5_5 = var4_4 = var2_2;
        var6_6 = var3_3;
        var7_7 = this.getBufferInfo();
        ** GOTO lbl18
        {
            ++var4_4;
            --var6_6;
            do {
                if (var6_6 > 0 && var1_1[var4_4] != 10 && var1_1[var4_4] != 13) continue block0;
                var8_8 = var4_4 - var5_5;
                if (var8_8 > 0) {
                    BufferInfo.access$100(var7_7).write(var1_1, var5_5, var8_8);
                }
                while (var6_6 > 0 && (var1_1[var4_4] == 10 || var1_1[var4_4] == 13)) {
                    this.write(var1_1[var4_4]);
                    ++var4_4;
                    --var6_6;
                }
                var5_5 = var4_4;
lbl18:
                // 2 sources

            } while (var6_6 > 0);
        }
    }

    private static class BufferInfo {
        private ByteArrayOutputStream buffer;
        private boolean crSeen = false;

        private BufferInfo() {
        }
    }
}

