/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Main
implements AntMain {
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private Vector targets = new Vector();
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(1);
    private Vector propertyFiles = new Vector(1);
    private boolean allowInput = true;
    private boolean keepGoingMode = false;
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed = false;
    private Integer threadPriority = null;
    private static String antVersion = null;
    static /* synthetic */ Class class$org$apache$tools$ant$Main;

    private static void printMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string != null) {
            System.err.println(string);
        }
    }

    public static void start(String[] stringArray, Properties properties, ClassLoader classLoader) {
        Main main = new Main();
        main.startAnt(stringArray, properties, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startAnt(String[] stringArray, Properties properties, ClassLoader classLoader) {
        int n;
        block14: {
            try {
                Diagnostics.validateVersion();
                this.processArgs(stringArray);
            }
            catch (Throwable throwable) {
                Main.handleLogfile();
                Main.printMessage(throwable);
                System.exit(1);
            }
            if (properties != null) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    this.definedProps.put(string, string2);
                }
            }
            n = 1;
            try {
                try {
                    block12: {
                        try {
                            this.runBuild(classLoader);
                            n = 0;
                        }
                        catch (ExitStatusException exitStatusException) {
                            n = exitStatusException.getStatus();
                            if (n == 0) break block12;
                            throw exitStatusException;
                        }
                    }
                    Object var8_12 = null;
                }
                catch (BuildException buildException) {
                    if (err != System.err) {
                        Main.printMessage(buildException);
                    }
                    Object var8_13 = null;
                    Main.handleLogfile();
                    break block14;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Main.printMessage(throwable);
                    Object var8_14 = null;
                    Main.handleLogfile();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                Main.handleLogfile();
                throw throwable;
            }
            Main.handleLogfile();
        }
        System.exit(n);
    }

    private static void handleLogfile() {
        block6: {
            if (!isLogFileUsed) break block6;
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] stringArray) {
        Main.start(stringArray, null, null);
    }

    public Main() {
    }

    protected Main(String[] stringArray) throws BuildException {
        this.processArgs(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processArgs(String[] var1_1) {
        var2_2 = null;
        var3_3 = null;
        var4_4 = 0;
        while (var4_4 < var1_1.length) {
            var5_5 = var1_1[var4_4];
            if (var5_5.equals("-help") || var5_5.equals("-h")) {
                Main.printUsage();
                return;
            }
            if (var5_5.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (var5_5.equals("-diagnostics")) {
                Diagnostics.doReport(System.out);
                return;
            }
            if (var5_5.equals("-quiet") || var5_5.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (var5_5.equals("-verbose") || var5_5.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
            } else if (var5_5.equals("-debug") || var5_5.equals("-d")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
            } else if (var5_5.equals("-noinput")) {
                this.allowInput = false;
            } else {
                if (var5_5.equals("-logfile") || var5_5.equals("-l")) {
                    try {
                        var6_7 = new File(var1_1[var4_4 + 1]);
                        ++var4_4;
                        var3_3 = new PrintStream(new FileOutputStream((File)var6_7));
                        Main.isLogFileUsed = true;
                    }
                    catch (IOException var6_8) {
                        var7_15 = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                        throw new BuildException((String)var7_15);
                    }
                    catch (ArrayIndexOutOfBoundsException var7_16) {
                        var8_19 = "You must specify a log file when using the -log argument";
                        throw new BuildException(var8_19);
                    }
                }
                if (var5_5.equals("-buildfile") || var5_5.equals("-file") || var5_5.equals("-f")) {
                    try {
                        this.buildFile = new File(var1_1[var4_4 + 1].replace('/', File.separatorChar));
                        ++var4_4;
                    }
                    catch (ArrayIndexOutOfBoundsException var6_9) {
                        var7_15 = "You must specify a buildfile when using the -buildfile argument";
                        throw new BuildException((String)var7_15);
                    }
                }
                if (var5_5.equals("-listener")) {
                    try {
                        this.listeners.addElement(var1_1[var4_4 + 1]);
                        ++var4_4;
                    }
                    catch (ArrayIndexOutOfBoundsException var6_10) {
                        var7_15 = "You must specify a classname when using the -listener argument";
                        throw new BuildException((String)var7_15);
                    }
                }
                if (var5_5.startsWith("-D")) {
                    var6_7 = var5_5.substring(2, var5_5.length());
                    var7_15 = null;
                    var8_18 = var6_7.indexOf("=");
                    if (var8_18 > 0) {
                        var7_15 = var6_7.substring(var8_18 + 1);
                        var6_7 = var6_7.substring(0, var8_18);
                    } else if (var4_4 < var1_1.length - 1) {
                        var7_15 = var1_1[++var4_4];
                    } else {
                        throw new BuildException("Missing value for property " + (String)var6_7);
                    }
                    this.definedProps.put(var6_7, var7_15);
                } else {
                    if (var5_5.equals("-logger")) {
                        if (this.loggerClassname != null) {
                            throw new BuildException("Only one logger class may  be specified.");
                        }
                        try {
                            this.loggerClassname = var1_1[++var4_4];
                        }
                        catch (ArrayIndexOutOfBoundsException var6_11) {
                            throw new BuildException("You must specify a classname when using the -logger argument");
                        }
                    }
                    if (var5_5.equals("-inputhandler")) {
                        if (this.inputHandlerClassname != null) {
                            throw new BuildException("Only one input handler class may be specified.");
                        }
                        try {
                            this.inputHandlerClassname = var1_1[++var4_4];
                        }
                        catch (ArrayIndexOutOfBoundsException var6_12) {
                            throw new BuildException("You must specify a classname when using the -inputhandler argument");
                        }
                    }
                    if (var5_5.equals("-emacs") || var5_5.equals("-e")) {
                        this.emacsMode = true;
                    } else if (var5_5.equals("-projecthelp") || var5_5.equals("-p")) {
                        this.projectHelp = true;
                    } else if (var5_5.equals("-find") || var5_5.equals("-s")) {
                        var2_2 = var4_4 < var1_1.length - 1 ? var1_1[++var4_4] : "build.xml";
                    } else {
                        if (var5_5.startsWith("-propertyfile")) {
                            try {
                                this.propertyFiles.addElement(var1_1[var4_4 + 1]);
                                ++var4_4;
                            }
                            catch (ArrayIndexOutOfBoundsException var6_13) {
                                var7_15 = "You must specify a property filename when using the -propertyfile argument";
                                throw new BuildException((String)var7_15);
                            }
                        }
                        if (var5_5.equals("-k") || var5_5.equals("-keep-going")) {
                            this.keepGoingMode = true;
                        } else if (var5_5.equals("-nice")) {
                            try {
                                this.threadPriority = Integer.decode(var1_1[var4_4 + 1]);
                            }
                            catch (ArrayIndexOutOfBoundsException var6_14) {
                                throw new BuildException("You must supply a niceness value (1-10) after the -nice option");
                            }
                            catch (NumberFormatException var7_17) {
                                throw new BuildException("Unrecognized niceness value: " + var1_1[var4_4 + 1]);
                            }
                            ++var4_4;
                            if (this.threadPriority < 1 || this.threadPriority > 10) {
                                throw new BuildException("Niceness value is out of the range 1-10");
                            }
                        } else {
                            if (var5_5.startsWith("-")) {
                                var6_7 = "Unknown argument: " + var5_5;
                                System.out.println((String)var6_7);
                                Main.printUsage();
                                throw new BuildException("");
                            }
                            this.targets.addElement(var5_5);
                        }
                    }
                }
            }
            ++var4_4;
        }
        if (this.buildFile == null) {
            this.buildFile = var2_2 != null ? this.findBuildFile(System.getProperty("user.dir"), var2_2) : new File("build.xml");
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        var5_6 = 0;
        while (var5_6 < this.propertyFiles.size()) {
            block72: {
                var6_7 = (String)this.propertyFiles.elementAt(var5_6);
                var7_15 = new Properties();
                var8_20 = null;
                try {
                    var8_20 = new FileInputStream((String)var6_7);
                    var7_15.load(var8_20);
                    var11_25 = null;
                    ** if (var8_20 == null) goto lbl-1000
                }
                catch (Throwable var10_24) {
                    var11_25 = null;
                    if (var8_20 != null) {
                        try {
                            var8_20.close();
                        }
                        catch (IOException var12_26) {
                            // empty catch block
                        }
                    }
                    throw var10_24;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var8_20.close();
                    }
                    catch (IOException var12_26) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block72;
                    catch (IOException var9_22) {
                        System.out.println("Could not load property file " + (String)var6_7 + ": " + var9_22.getMessage());
                        var11_25 = null;
                        if (var8_20 != null) {
                            try {
                                var8_20.close();
                            }
                            catch (IOException var12_26) {}
                        }
                    }
                }
            }
            var9_21 = var7_15.propertyNames();
            while (var9_21.hasMoreElements()) {
                var10_23 = (String)var9_21.nextElement();
                if (this.definedProps.getProperty(var10_23) != null) continue;
                this.definedProps.put(var10_23, var7_15.getProperty(var10_23));
            }
            ++var5_6;
        }
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        if (var3_3 != null) {
            Main.out = var3_3;
            Main.err = var3_3;
            System.setOut(Main.out);
            System.setErr(Main.err);
        }
        this.readyToRun = true;
    }

    private File getParentFile(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + file2.getAbsolutePath());
        }
        return file2;
    }

    private File findBuildFile(String string, String string2) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + string2 + " ...");
        }
        File file = new File(new File(string).getAbsolutePath());
        File file2 = new File(file, string2);
        while (!file2.exists()) {
            if ((file = this.getParentFile(file)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file2 = new File(file, string2);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(ClassLoader classLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        Project project = new Project();
        project.setCoreLoader(classLoader);
        Throwable throwable = null;
        try {
            this.addBuildListeners(project);
            this.addInputHandler(project);
            PrintStream printStream = System.err;
            PrintStream printStream2 = System.out;
            InputStream inputStream = System.in;
            SecurityManager securityManager = null;
            if (!JavaEnvUtils.isJavaVersion("1.0") && !JavaEnvUtils.isJavaVersion("1.1")) {
                securityManager = System.getSecurityManager();
            }
            try {
                if (this.allowInput) {
                    project.setDefaultInputStream(System.in);
                }
                System.setIn(new DemuxInputStream(project));
                System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
                if (!this.projectHelp) {
                    project.fireBuildStarted();
                }
                if (this.threadPriority != null) {
                    try {
                        project.log("Setting Ant's thread priority to " + this.threadPriority, 3);
                        Thread.currentThread().setPriority(this.threadPriority);
                    }
                    catch (SecurityException securityException) {
                        project.log("A security manager refused to set the -nice value");
                    }
                }
                project.init();
                project.setUserProperty("ant.version", Main.getAntVersion());
                Enumeration<Object> enumeration = this.definedProps.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)this.definedProps.get(string);
                    project.setUserProperty(string, string2);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                project.setKeepGoingMode(this.keepGoingMode);
                ProjectHelper.configureProject(project, this.buildFile);
                if (this.projectHelp) {
                    Main.printDescription(project);
                    Main.printTargets(project, this.msgOutputLevel > 2);
                    return;
                }
                if (this.targets.size() == 0 && project.getDefaultTarget() != null) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            finally {
                if (securityManager != null) {
                    System.setSecurityManager(securityManager);
                }
                System.setOut(printStream2);
                System.setErr(printStream);
                System.setIn(inputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            throw runtimeException;
        }
        catch (Error error) {
            throwable = error;
            throw error;
        }
        finally {
            if (!this.projectHelp) {
                project.fireBuildFinished(throwable);
            } else if (throwable != null) {
                project.log(throwable.toString(), 0);
            }
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        int n = 0;
        while (n < this.listeners.size()) {
            String string = (String)this.listeners.elementAt(n);
            try {
                BuildListener buildListener = (BuildListener)Class.forName(string).newInstance();
                if (project != null) {
                    project.setProjectReference(buildListener);
                }
                project.addBuildListener(buildListener);
            }
            catch (Throwable throwable) {
                throw new BuildException("Unable to instantiate listener " + string, throwable);
            }
            ++n;
        }
    }

    private void addInputHandler(Project project) throws BuildException {
        InputHandler inputHandler = null;
        if (this.inputHandlerClassname == null) {
            inputHandler = new DefaultInputHandler();
        } else {
            try {
                inputHandler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
                if (project != null) {
                    project.setProjectReference(inputHandler);
                }
            }
            catch (ClassCastException classCastException) {
                String string = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(string);
            }
            catch (Exception exception) {
                String string = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + exception.getClass().getName();
                throw new BuildException(string);
            }
        }
        project.setInputHandler(inputHandler);
    }

    private BuildLogger createLogger() {
        BuildLogger buildLogger = null;
        if (this.loggerClassname != null) {
            try {
                Class<?> clazz = Class.forName(this.loggerClassname);
                buildLogger = (BuildLogger)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception exception) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + exception.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            buildLogger = new DefaultLogger();
        }
        buildLogger.setMessageOutputLevel(this.msgOutputLevel);
        buildLogger.setOutputPrintStream(out);
        buildLogger.setErrorPrintStream(err);
        buildLogger.setEmacsMode(this.emacsMode);
        return buildLogger;
    }

    private static void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ant [options] [target [target2 [target3] ...]]" + string);
        stringBuffer.append("Options: " + string);
        stringBuffer.append("  -help, -h              print this message" + string);
        stringBuffer.append("  -projecthelp, -p       print project help information" + string);
        stringBuffer.append("  -version               print the version information and exit" + string);
        stringBuffer.append("  -diagnostics           print information that might be helpful to" + string);
        stringBuffer.append("                         diagnose or report problems." + string);
        stringBuffer.append("  -quiet, -q             be extra quiet" + string);
        stringBuffer.append("  -verbose, -v           be extra verbose" + string);
        stringBuffer.append("  -debug, -d             print debugging information" + string);
        stringBuffer.append("  -emacs, -e             produce logging information without adornments" + string);
        stringBuffer.append("  -lib <path>            specifies a path to search for jars and classes" + string);
        stringBuffer.append("  -logfile <file>        use given file for log" + string);
        stringBuffer.append("    -l     <file>                ''" + string);
        stringBuffer.append("  -logger <classname>    the class which is to perform logging" + string);
        stringBuffer.append("  -listener <classname>  add an instance of class as a project listener" + string);
        stringBuffer.append("  -noinput               do not allow interactive input" + string);
        stringBuffer.append("  -buildfile <file>      use given buildfile" + string);
        stringBuffer.append("    -file    <file>              ''" + string);
        stringBuffer.append("    -f       <file>              ''" + string);
        stringBuffer.append("  -D<property>=<value>   use value for given property" + string);
        stringBuffer.append("  -keep-going, -k        execute all targets that do not depend" + string);
        stringBuffer.append("                         on failed target(s)" + string);
        stringBuffer.append("  -propertyfile <name>   load all properties from file with -D" + string);
        stringBuffer.append("                         properties taking precedence" + string);
        stringBuffer.append("  -inputhandler <class>  the class which will handle input requests" + string);
        stringBuffer.append("  -find <file>           (s)earch for buildfile towards the root of" + string);
        stringBuffer.append("    -s  <file>           the filesystem and use it" + string);
        stringBuffer.append("  -nice  number          A niceness value for the main thread:" + string + "                         1 (lowest) to 10 (highest); 5 is the default" + string);
        System.out.println(stringBuffer.toString());
    }

    private static void printVersion() throws BuildException {
        System.out.println(Main.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties properties = new Properties();
                InputStream inputStream = (class$org$apache$tools$ant$Main == null ? (class$org$apache$tools$ant$Main = Main.class$("org.apache.tools.ant.Main")) : class$org$apache$tools$ant$Main).getResourceAsStream("/org/apache/tools/ant/version.txt");
                properties.load(inputStream);
                inputStream.close();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Apache Ant version ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(" compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                antVersion = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not load the version information:" + iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static void printTargets(Project project, boolean bl) {
        String string;
        int n = 0;
        Enumeration enumeration = project.getTargets().elements();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            int n2;
            Target target = (Target)enumeration.nextElement();
            String string2 = target.getName();
            if (string2.equals("")) continue;
            String string3 = target.getDescription();
            if (string3 == null) {
                n2 = Main.findTargetPosition(vector3, string2);
                vector3.insertElementAt(string2, n2);
                continue;
            }
            n2 = Main.findTargetPosition(vector, string2);
            vector.insertElementAt(string2, n2);
            vector2.insertElementAt(string3, n2);
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        Main.printTargets(project, vector, vector2, "Main targets:", n);
        if (vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            Main.printTargets(project, vector3, null, "Other targets:", 0);
        }
        if ((string = project.getDefaultTarget()) != null && !"".equals(string)) {
            project.log("Default target: " + string);
        }
    }

    private static int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < vector.size() && n == vector.size()) {
            if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private static void printTargets(Project project, Vector vector, Vector vector2, String string, int n) {
        String string2 = System.getProperty("line.separator");
        String string3 = "    ";
        while (string3.length() <= n) {
            string3 = string3 + string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + string2);
        int n2 = 0;
        while (n2 < vector.size()) {
            stringBuffer.append(" ");
            stringBuffer.append(vector.elementAt(n2));
            if (vector2 != null) {
                stringBuffer.append(string3.substring(0, n - ((String)vector.elementAt(n2)).length() + 2));
                stringBuffer.append(vector2.elementAt(n2));
            }
            stringBuffer.append(string2);
            ++n2;
        }
        project.log(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

