/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class PropertyHelper {
    private Project project;
    private PropertyHelper next;
    private Hashtable properties = new Hashtable();
    private Hashtable userProperties = new Hashtable();
    private Hashtable inheritedProperties = new Hashtable();

    protected PropertyHelper() {
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setNext(PropertyHelper propertyHelper) {
        this.next = propertyHelper;
    }

    public PropertyHelper getNext() {
        return this.next;
    }

    public static synchronized PropertyHelper getPropertyHelper(Project project) {
        PropertyHelper propertyHelper = (PropertyHelper)project.getReference("ant.PropertyHelper");
        if (propertyHelper != null) {
            return propertyHelper;
        }
        propertyHelper = new PropertyHelper();
        propertyHelper.setProject(project);
        project.addReference("ant.PropertyHelper", propertyHelper);
        return propertyHelper;
    }

    public boolean setPropertyHook(String string, String string2, Object object, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        return this.getNext() != null && (bl4 = this.getNext().setPropertyHook(string, string2, object, bl, bl2, bl3));
    }

    public Object getPropertyHook(String string, String string2, boolean bl) {
        Object object;
        if (this.getNext() != null && (object = this.getNext().getPropertyHook(string, string2, bl)) != null) {
            return object;
        }
        if (string2.startsWith("toString:")) {
            object = this.project.getReference(string2 = string2.substring("toString:".length()));
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        return null;
    }

    public void parsePropertyString(String string, Vector vector, Vector vector2) throws BuildException {
        PropertyHelper.parsePropertyStringDefault(string, vector, vector2);
    }

    public String replaceProperties(String string, String string2, Hashtable hashtable) throws BuildException {
        if (string2 == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.parsePropertyString(string2, vector, vector2);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3 == null) {
                String string4 = (String)enumeration2.nextElement();
                Object object = null;
                if (hashtable != null) {
                    object = hashtable.get(string4);
                }
                if (object == null) {
                    object = this.getProperty(string, string4);
                }
                if (object == null) {
                    this.project.log("Property ${" + string4 + "} has not been set", 3);
                }
                string3 = object != null ? object.toString() : "${" + string4 + "}";
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public synchronized boolean setProperty(String string, String string2, Object object, boolean bl) {
        if (null != this.userProperties.get(string2)) {
            if (bl) {
                this.project.log("Override ignored for user property " + string2, 3);
            }
            return false;
        }
        boolean bl2 = this.setPropertyHook(string, string2, object, false, false, false);
        if (bl2) {
            return true;
        }
        if (null != this.properties.get(string2) && bl) {
            this.project.log("Overriding previous definition of property " + string2, 3);
        }
        if (bl) {
            this.project.log("Setting project property: " + string2 + " -> " + object, 4);
        }
        this.properties.put(string2, object);
        return true;
    }

    public synchronized void setNewProperty(String string, String string2, Object object) {
        if (null != this.properties.get(string2)) {
            this.project.log("Override ignored for property " + string2, 3);
            return;
        }
        boolean bl = this.setPropertyHook(string, string2, object, false, false, true);
        if (bl) {
            return;
        }
        this.project.log("Setting project property: " + string2 + " -> " + object, 4);
        if (string2 != null && object != null) {
            this.properties.put(string2, object);
        }
    }

    public synchronized void setUserProperty(String string, String string2, Object object) {
        this.project.log("Setting ro project property: " + string2 + " -> " + object, 4);
        this.userProperties.put(string2, object);
        boolean bl = this.setPropertyHook(string, string2, object, false, true, false);
        if (bl) {
            return;
        }
        this.properties.put(string2, object);
    }

    public synchronized void setInheritedProperty(String string, String string2, Object object) {
        this.inheritedProperties.put(string2, object);
        this.project.log("Setting ro project property: " + string2 + " -> " + object, 4);
        this.userProperties.put(string2, object);
        boolean bl = this.setPropertyHook(string, string2, object, true, false, false);
        if (bl) {
            return;
        }
        this.properties.put(string2, object);
    }

    public synchronized Object getProperty(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        Object object = this.getPropertyHook(string, string2, false);
        if (object != null) {
            return object;
        }
        return this.properties.get(string2);
    }

    public synchronized Object getUserProperty(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        Object object = this.getPropertyHook(string, string2, true);
        if (object != null) {
            return object;
        }
        return this.userProperties.get(string2);
    }

    public Hashtable getProperties() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.properties.get(k);
            hashtable.put(k, v);
        }
        return hashtable;
    }

    public Hashtable getUserProperties() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.userProperties.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.properties.get(k);
            hashtable.put(k, v);
        }
        return hashtable;
    }

    public void copyInheritedProperties(Project project) {
        Enumeration enumeration = this.inheritedProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (project.getUserProperty(string) != null) continue;
            Object v = this.inheritedProperties.get(string);
            project.setInheritedProperty(string, v.toString());
        }
    }

    public void copyUserProperties(Project project) {
        Enumeration enumeration = this.userProperties.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.inheritedProperties.containsKey(k)) continue;
            Object v = this.userProperties.get(k);
            project.setUserProperty(k.toString(), v.toString());
        }
    }

    static void parsePropertyStringDefault(String string, Vector vector, Vector vector2) throws BuildException {
        int n;
        int n2 = 0;
        while ((n = string.indexOf("$", n2)) >= 0) {
            if (n > 0) {
                vector.addElement(string.substring(n2, n));
            }
            if (n == string.length() - 1) {
                vector.addElement("$");
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n + 1) != '{') {
                if (string.charAt(n + 1) == '$') {
                    vector.addElement("$");
                    n2 = n + 2;
                    continue;
                }
                vector.addElement(string.substring(n, n + 2));
                n2 = n + 2;
                continue;
            }
            int n3 = string.indexOf(125, n);
            if (n3 < 0) {
                throw new BuildException("Syntax error in property: " + string);
            }
            String string2 = string.substring(n + 2, n3);
            vector.addElement(null);
            vector2.addElement(string2);
            n2 = n3 + 1;
        }
        if (n2 < string.length()) {
            vector.addElement(string.substring(n2));
        }
    }
}

