/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.util.CollectionUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable
implements Serializable {
    private static final String ANT_TYPE = "ant-type";
    private String elementTag = null;
    private List children = null;
    private transient Object wrappedObject = null;
    private transient IntrospectionHelper.Creator creator;
    private transient AttributeList attributes;
    private List attributeNames = null;
    private Map attributeMap = null;
    private StringBuffer characters = null;
    private boolean proxyConfigured = false;
    private String polyType = null;

    public RuntimeConfigurable(Object object, String string) {
        this.wrappedObject = object;
        this.elementTag = string;
        this.proxyConfigured = false;
        if (object instanceof Task) {
            ((Task)object).setRuntimeConfigurableWrapper(this);
        }
    }

    public void setProxy(Object object) {
        this.wrappedObject = object;
        this.proxyConfigured = false;
    }

    void setCreator(IntrospectionHelper.Creator creator) {
        this.creator = creator;
    }

    public Object getProxy() {
        return this.wrappedObject;
    }

    public String getPolyType() {
        return this.polyType;
    }

    public void setPolyType(String string) {
        this.polyType = string;
    }

    public void setAttributes(AttributeList attributeList) {
        this.attributes = new AttributeListImpl(attributeList);
        int n = 0;
        while (n < attributeList.getLength()) {
            this.setAttribute(attributeList.getName(n), attributeList.getValue(n));
            ++n;
        }
    }

    public void setAttribute(String string, String string2) {
        if (string.equalsIgnoreCase(ANT_TYPE)) {
            this.polyType = string2;
        } else {
            if (this.attributeNames == null) {
                this.attributeNames = new ArrayList();
                this.attributeMap = new HashMap();
            }
            this.attributeNames.add(string);
            this.attributeMap.put(string, string2);
        }
    }

    public Hashtable getAttributeMap() {
        if (this.attributeMap != null) {
            return new Hashtable(this.attributeMap);
        }
        return new Hashtable(1);
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void addChild(RuntimeConfigurable runtimeConfigurable) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(runtimeConfigurable);
    }

    RuntimeConfigurable getChild(int n) {
        return (RuntimeConfigurable)this.children.get(n);
    }

    public Enumeration getChildren() {
        if (this.children != null) {
            return Collections.enumeration(this.children);
        }
        return new CollectionUtils.EmptyEnumeration();
    }

    public void addText(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.characters != null) {
            this.characters.append(string);
        } else {
            this.characters = new StringBuffer(string);
        }
    }

    public void addText(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.characters == null) {
            this.characters = new StringBuffer(n2);
        }
        this.characters.append(cArray, n, n2);
    }

    public StringBuffer getText() {
        if (this.characters != null) {
            return this.characters;
        }
        return new StringBuffer(0);
    }

    public String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project project) throws BuildException {
        this.maybeConfigure(project, true);
    }

    public void maybeConfigure(Project project, boolean bl) throws BuildException {
        Object object;
        Object object2;
        String string = null;
        if (this.proxyConfigured) {
            return;
        }
        Object object3 = this.wrappedObject instanceof TypeAdapter ? ((TypeAdapter)this.wrappedObject).getProxy() : this.wrappedObject;
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(project, object3.getClass());
        if (this.attributeNames != null) {
            int n = 0;
            while (n < this.attributeNames.size()) {
                block10: {
                    object2 = (String)this.attributeNames.get(n);
                    object = (String)this.attributeMap.get(object2);
                    object = project.replaceProperties((String)object);
                    try {
                        introspectionHelper.setAttribute(project, object3, ((String)object2).toLowerCase(Locale.US), (String)object);
                    }
                    catch (BuildException buildException) {
                        if (((String)object2).equals("id")) break block10;
                        throw buildException;
                    }
                }
                ++n;
            }
            string = (String)this.attributeMap.get("id");
        }
        if (this.characters != null) {
            ProjectHelper.addText(project, this.wrappedObject, this.characters.substring(0));
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            object2 = (RuntimeConfigurable)enumeration.nextElement();
            if (((RuntimeConfigurable)object2).wrappedObject instanceof Task) {
                object = (Task)((RuntimeConfigurable)object2).wrappedObject;
                ((Task)object).setRuntimeConfigurableWrapper((RuntimeConfigurable)object2);
            }
            if (((RuntimeConfigurable)object2).creator != null && bl) {
                ((RuntimeConfigurable)object2).maybeConfigure(project);
                ((RuntimeConfigurable)object2).creator.store();
                continue;
            }
            object = ((RuntimeConfigurable)object2).getElementTag().toLowerCase(Locale.US);
            if (!bl || !introspectionHelper.supportsNestedElement((String)object)) continue;
            ((RuntimeConfigurable)object2).maybeConfigure(project);
            ProjectHelper.storeChild(project, object3, ((RuntimeConfigurable)object2).wrappedObject, (String)object);
        }
        if (string != null) {
            project.addReference(string, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }

    public void reconfigure(Project project) {
        this.proxyConfigured = false;
        this.maybeConfigure(project);
    }

    public void applyPreSet(RuntimeConfigurable runtimeConfigurable) {
        Object object;
        if (runtimeConfigurable.attributeMap != null) {
            object = runtimeConfigurable.attributeMap.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (this.attributeMap != null && this.attributeMap.get(string) != null) continue;
                this.setAttribute(string, (String)runtimeConfigurable.attributeMap.get(string));
            }
        }
        if (runtimeConfigurable.polyType != null && this.polyType == null) {
            this.polyType = runtimeConfigurable.polyType;
        }
        if (runtimeConfigurable.children != null) {
            object = new ArrayList();
            object.addAll(runtimeConfigurable.children);
            if (this.children != null) {
                object.addAll(this.children);
            }
            this.children = object;
        }
        if (runtimeConfigurable.characters != null && (this.characters == null || this.characters.toString().trim().length() == 0)) {
            this.characters = new StringBuffer(runtimeConfigurable.characters.toString());
        }
    }
}

