/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.CollectionUtils;

public class Target
implements TaskContainer {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private List dependencies = null;
    private List children = new ArrayList();
    private Location location = Location.UNKNOWN_LOCATION;
    private Project project;
    private String description = null;

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setDepends(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equals("") || string2.equals(",")) {
                    throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" has an empty string for dependency.");
                }
                this.addDependency(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens() && string2.equals(",")) continue;
                throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" ends with a , character");
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addTask(Task task) {
        this.children.add(task);
    }

    public void addDataType(RuntimeConfigurable runtimeConfigurable) {
        this.children.add(runtimeConfigurable);
    }

    public Task[] getTasks() {
        ArrayList arrayList = new ArrayList(this.children.size());
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Task)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new Task[arrayList.size()]);
    }

    public void addDependency(String string) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList(2);
        }
        this.dependencies.add(string);
    }

    public Enumeration getDependencies() {
        if (this.dependencies != null) {
            return Collections.enumeration(this.dependencies);
        }
        return new CollectionUtils.EmptyEnumeration();
    }

    public boolean dependsOn(String string) {
        if (this.getProject() != null) {
            int n;
            Vector vector = this.getProject().topoSort(this.getName(), this.getProject().getTargets());
            int n2 = vector.indexOf(this);
            return n2 >= (n = vector.indexOf(this.getProject().getTargets().get(string)));
        }
        return false;
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    public String getIf() {
        return "".equals(this.ifCondition) ? null : this.ifCondition;
    }

    public void setUnless(String string) {
        this.unlessCondition = string == null ? "" : string;
    }

    public String getUnless() {
        return "".equals(this.unlessCondition) ? null : this.unlessCondition;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            int n = 0;
            while (n < this.children.size()) {
                Object object;
                Object e = this.children.get(n);
                if (e instanceof Task) {
                    object = (Task)e;
                    ((Task)object).perform();
                } else {
                    object = (RuntimeConfigurable)e;
                    ((RuntimeConfigurable)object).maybeConfigure(this.project);
                }
                ++n;
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.project.replaceProperties(this.ifCondition) + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.project.replaceProperties(this.unlessCondition) + "' set.", 3);
        }
    }

    public final void performTasks() {
        RuntimeException runtimeException = null;
        this.project.fireTargetStarted(this);
        try {
            try {
                this.execute();
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                throw runtimeException2;
            }
            Object var4_2 = null;
            this.project.fireTargetFinished(this, runtimeException);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.project.fireTargetFinished(this, runtimeException);
            throw throwable;
        }
    }

    void replaceChild(Task task, RuntimeConfigurable runtimeConfigurable) {
        int n;
        while ((n = this.children.indexOf(task)) >= 0) {
            this.children.set(n, runtimeConfigurable);
        }
    }

    void replaceChild(Task task, Task task2) {
        int n;
        while ((n = this.children.indexOf(task)) >= 0) {
            this.children.set(n, task2);
        }
    }

    private boolean testIfCondition() {
        if ("".equals(this.ifCondition)) {
            return true;
        }
        String string = this.project.replaceProperties(this.ifCondition);
        return this.project.getProperty(string) != null;
    }

    private boolean testUnlessCondition() {
        if ("".equals(this.unlessCondition)) {
            return true;
        }
        String string = this.project.replaceProperties(this.unlessCondition);
        return this.project.getProperty(string) == null;
    }
}

