/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.UnknownElement;

public abstract class Task
extends ProjectComponent {
    protected Target target;
    protected String description;
    protected Location location = Location.UNKNOWN_LOCATION;
    protected String taskName;
    protected String taskType;
    protected RuntimeConfigurable wrapper;
    private boolean invalid;
    private UnknownElement replacement;

    public void setOwningTarget(Target target) {
        this.target = target;
    }

    public Target getOwningTarget() {
        return this.target;
    }

    public void setTaskName(String string) {
        this.taskName = string;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskType(String string) {
        this.taskType = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void init() throws BuildException {
    }

    public void execute() throws BuildException {
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public RuntimeConfigurable getRuntimeConfigurableWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new RuntimeConfigurable(this, this.getTaskName());
        }
        return this.wrapper;
    }

    public void setRuntimeConfigurableWrapper(RuntimeConfigurable runtimeConfigurable) {
        this.wrapper = runtimeConfigurable;
    }

    public void maybeConfigure() throws BuildException {
        if (!this.invalid) {
            if (this.wrapper != null) {
                this.wrapper.maybeConfigure(this.getProject());
            }
        } else {
            this.getReplacement();
        }
    }

    public void reconfigure() {
        if (this.wrapper != null) {
            this.wrapper.reconfigure(this.getProject());
        }
    }

    protected void handleOutput(String string) {
        this.log(string, 2);
    }

    protected void handleFlush(String string) {
        this.handleOutput(string);
    }

    protected int handleInput(byte[] byArray, int n, int n2) throws IOException {
        return this.getProject().defaultInput(byArray, n, n2);
    }

    protected void handleErrorOutput(String string) {
        this.log(string, 1);
    }

    protected void handleErrorFlush(String string) {
        this.handleErrorOutput(string);
    }

    public void log(String string) {
        this.log(string, 2);
    }

    public void log(String string, int n) {
        this.getProject().log(this, string, n);
    }

    public final void perform() {
        block8: {
            if (!this.invalid) {
                this.getProject().fireTaskStarted(this);
                Throwable throwable = null;
                try {
                    try {
                        this.maybeConfigure();
                        this.execute();
                    }
                    catch (BuildException buildException) {
                        if (buildException.getLocation() == Location.UNKNOWN_LOCATION) {
                            buildException.setLocation(this.getLocation());
                        }
                        throwable = buildException;
                        throw buildException;
                    }
                    catch (Exception exception) {
                        throwable = exception;
                        BuildException buildException = new BuildException(exception);
                        buildException.setLocation(this.getLocation());
                        throw buildException;
                    }
                    catch (Error error) {
                        throwable = error;
                        throw error;
                    }
                    Object var6_3 = null;
                    this.getProject().fireTaskFinished(this, throwable);
                    break block8;
                }
                catch (Throwable throwable2) {
                    Object var6_4 = null;
                    this.getProject().fireTaskFinished(this, throwable);
                    throw throwable2;
                }
            }
            UnknownElement unknownElement = this.getReplacement();
            Task task = unknownElement.getTask();
            task.perform();
        }
    }

    final void markInvalid() {
        this.invalid = true;
    }

    protected final boolean isInvalid() {
        return this.invalid;
    }

    private UnknownElement getReplacement() {
        if (this.replacement == null) {
            this.replacement = new UnknownElement(this.taskType);
            this.replacement.setProject(this.getProject());
            this.replacement.setTaskType(this.taskType);
            this.replacement.setTaskName(this.taskName);
            this.replacement.setLocation(this.location);
            this.replacement.setOwningTarget(this.target);
            this.replacement.setRuntimeConfigurableWrapper(this.wrapper);
            this.wrapper.setProxy(this.replacement);
            this.replaceChildren(this.wrapper, this.replacement);
            this.target.replaceChild(this, this.replacement);
            this.replacement.maybeConfigure();
        }
        return this.replacement;
    }

    private void replaceChildren(RuntimeConfigurable runtimeConfigurable, UnknownElement unknownElement) {
        Enumeration enumeration = runtimeConfigurable.getChildren();
        while (enumeration.hasMoreElements()) {
            RuntimeConfigurable runtimeConfigurable2 = (RuntimeConfigurable)enumeration.nextElement();
            UnknownElement unknownElement2 = new UnknownElement(runtimeConfigurable2.getElementTag());
            unknownElement.addChild(unknownElement2);
            unknownElement2.setProject(this.getProject());
            unknownElement2.setRuntimeConfigurableWrapper(runtimeConfigurable2);
            runtimeConfigurable2.setProxy(unknownElement2);
            this.replaceChildren(runtimeConfigurable2, unknownElement2);
        }
    }

    public String getTaskType() {
        return this.taskType;
    }

    protected RuntimeConfigurable getWrapper() {
        return this.wrapper;
    }
}

