/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class StripLineComments
extends BaseParamFilterReader
implements ChainableReader {
    private static final String COMMENTS_KEY = "comment";
    private Vector comments = new Vector();
    private String line = null;

    public StripLineComments() {
    }

    public StripLineComments(Reader reader) {
        super(reader);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.line != null) {
            n = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            this.line = this.readLine();
            int n2 = this.comments.size();
            while (this.line != null) {
                int n3 = 0;
                while (n3 < n2) {
                    String string = (String)this.comments.elementAt(n3);
                    if (this.line.startsWith(string)) {
                        this.line = null;
                        break;
                    }
                    ++n3;
                }
                if (this.line != null) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return n;
    }

    public final void addConfiguredComment(Comment comment) {
        this.comments.addElement(comment.getValue());
    }

    private void setComments(Vector vector) {
        this.comments = vector;
    }

    private final Vector getComments() {
        return this.comments;
    }

    public final Reader chain(Reader reader) {
        StripLineComments stripLineComments = new StripLineComments(reader);
        stripLineComments.setComments(this.getComments());
        stripLineComments.setInitialized(true);
        return stripLineComments;
    }

    private final void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            int n = 0;
            while (n < parameterArray.length) {
                if (COMMENTS_KEY.equals(parameterArray[n].getType())) {
                    this.comments.addElement(parameterArray[n].getValue());
                }
                ++n;
            }
        }
    }

    public static class Comment {
        private String value;

        public final void setValue(String string) {
            this.value = string;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

