/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectHelper2
extends ProjectHelper {
    private static AntHandler elementHandler = new ElementHandler();
    private static AntHandler targetHandler = new TargetHandler();
    private static AntHandler mainHandler = new MainHandler();
    private static AntHandler projectHandler = new ProjectHandler();
    private static FileUtils fu = FileUtils.newFileUtils();

    public UnknownElement parseUnknownElement(Project project, URL uRL) throws BuildException {
        Target target = new Target();
        target.setProject(project);
        AntXMLContext antXMLContext = new AntXMLContext(project);
        antXMLContext.addTarget(target);
        antXMLContext.setImplicitTarget(target);
        this.parse(antXMLContext.getProject(), uRL, new RootHandler(antXMLContext, elementHandler));
        Task[] taskArray = target.getTasks();
        if (taskArray.length != 1) {
            throw new BuildException("No tasks defined");
        }
        return (UnknownElement)taskArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Project project, Object object) throws BuildException {
        this.getImportStack().addElement(object);
        AntXMLContext antXMLContext = null;
        antXMLContext = (AntXMLContext)project.getReference("ant.parsing.context");
        if (antXMLContext == null) {
            antXMLContext = new AntXMLContext(project);
            project.addReference("ant.parsing.context", antXMLContext);
            project.addReference("ant.targets", antXMLContext.getTargets());
        }
        if (this.getImportStack().size() > 1) {
            antXMLContext.setIgnoreProjectTag(true);
            Target target = antXMLContext.getCurrentTarget();
            try {
                Target target2 = new Target();
                target2.setProject(project);
                target2.setName("");
                antXMLContext.setCurrentTarget(target2);
                this.parse(project, object, new RootHandler(antXMLContext, mainHandler));
                target2.execute();
                Object var7_6 = null;
                antXMLContext.setCurrentTarget(target);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                antXMLContext.setCurrentTarget(target);
                throw throwable;
            }
        } else {
            this.parse(project, object, new RootHandler(antXMLContext, mainHandler));
            antXMLContext.getImplicitTarget().execute();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Project project, Object object, RootHandler rootHandler) throws BuildException {
        AntXMLContext antXMLContext = rootHandler.context;
        File file = null;
        URL uRL = null;
        String string = null;
        if (object instanceof File) {
            file = (File)object;
            file = fu.normalize(file.getAbsolutePath());
            antXMLContext.setBuildFile(file);
            string = file.toString();
        } else {
            if (!(object instanceof URL)) throw new BuildException("Source " + object.getClass().getName() + " not supported by this plugin");
            if (rootHandler.getCurrentAntHandler() != elementHandler) {
                throw new BuildException("Source " + object.getClass().getName() + " not supported by this plugin for " + " non task xml");
            }
            uRL = (URL)object;
            string = uRL.toString();
        }
        InputStream inputStream = null;
        InputSource inputSource = null;
        try {
            try {
                XMLReader xMLReader = JAXPUtils.getNamespaceXMLReader();
                String string2 = null;
                if (file != null) {
                    string2 = fu.toURI(file.getAbsolutePath());
                    inputStream = new FileInputStream(file);
                } else {
                    inputStream = uRL.openStream();
                    string2 = uRL.toString();
                }
                inputSource = new InputSource(inputStream);
                if (string2 != null) {
                    inputSource.setSystemId(string2);
                }
                project.log("parsing buildfile " + string + " with URI = " + string2, 3);
                RootHandler rootHandler2 = rootHandler;
                xMLReader.setContentHandler(rootHandler2);
                xMLReader.setEntityResolver(rootHandler2);
                xMLReader.setErrorHandler(rootHandler2);
                xMLReader.setDTDHandler(rootHandler2);
                xMLReader.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
                Location location = new Location(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                Exception exception = sAXParseException.getException();
                if (!(exception instanceof BuildException)) throw new BuildException(sAXParseException.getMessage(), exception, location);
                BuildException buildException = (BuildException)exception;
                if (buildException.getLocation() != Location.UNKNOWN_LOCATION) throw buildException;
                buildException.setLocation(location);
                throw buildException;
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                if (!(exception instanceof BuildException)) throw new BuildException(sAXException.getMessage(), exception);
                throw (BuildException)exception;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BuildException(fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException("Encoding of project file " + string + " is invalid.", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new BuildException("Error reading project file " + string + ": " + iOException.getMessage(), iOException);
            }
            Object var16_19 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        return;
    }

    public static class AntHandler {
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
        }

        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + string3 + " \"", antXMLContext.getLocator());
        }

        public void onEndChild(String string, String string2, String string3, AntXMLContext antXMLContext) throws SAXParseException {
        }

        public void onEndElement(String string, String string2, AntXMLContext antXMLContext) {
        }

        public void characters(char[] cArray, int n, int n2, AntXMLContext antXMLContext) throws SAXParseException {
            String string = new String(cArray, n, n2).trim();
            if (string.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + string + "\"", antXMLContext.getLocator());
            }
        }

        protected void checkNamespace(String string) {
        }
    }

    public static class ElementHandler
    extends AntHandler {
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            RuntimeConfigurable runtimeConfigurable = antXMLContext.currentWrapper();
            Object object = null;
            if (runtimeConfigurable != null) {
                object = runtimeConfigurable.getProxy();
            }
            UnknownElement unknownElement = new UnknownElement(string2);
            unknownElement.setProject(antXMLContext.getProject());
            unknownElement.setNamespace(string);
            unknownElement.setQName(string3);
            unknownElement.setTaskType(ProjectHelper.genComponentName(unknownElement.getNamespace(), string2));
            unknownElement.setTaskName(string3);
            Location location = new Location(antXMLContext.getLocator().getSystemId(), antXMLContext.getLocator().getLineNumber(), antXMLContext.getLocator().getColumnNumber());
            unknownElement.setLocation(location);
            unknownElement.setOwningTarget(antXMLContext.getCurrentTarget());
            antXMLContext.configureId(unknownElement, attributes);
            if (object != null) {
                ((UnknownElement)object).addChild(unknownElement);
            } else {
                antXMLContext.getCurrentTarget().addTask(unknownElement);
            }
            RuntimeConfigurable runtimeConfigurable2 = new RuntimeConfigurable(unknownElement, unknownElement.getTaskName());
            int n = 0;
            while (n < attributes.getLength()) {
                String string4 = attributes.getLocalName(n);
                String string5 = attributes.getURI(n);
                if (string5 != null && !string5.equals("") && !string5.equals(string)) {
                    string4 = string5 + ":" + attributes.getQName(n);
                }
                String string6 = attributes.getValue(n);
                if ("ant-type".equals(string4) || "antlib:org.apache.tools.ant".equals(string5) && "ant-type".equals(attributes.getLocalName(n))) {
                    string4 = "ant-type";
                    int n2 = string6.indexOf(":");
                    if (n2 != -1) {
                        String string7 = string6.substring(0, n2);
                        String string8 = antXMLContext.getPrefixMapping(string7);
                        if (string8 == null) {
                            throw new BuildException("Unable to find XML NS prefix " + string7);
                        }
                        string6 = ProjectHelper.genComponentName(string8, string6.substring(n2 + 1));
                    }
                }
                runtimeConfigurable2.setAttribute(string4, string6);
                ++n;
            }
            if (runtimeConfigurable != null) {
                runtimeConfigurable.addChild(runtimeConfigurable2);
            }
            antXMLContext.pushWrapper(runtimeConfigurable2);
        }

        public void characters(char[] cArray, int n, int n2, AntXMLContext antXMLContext) throws SAXParseException {
            RuntimeConfigurable runtimeConfigurable = antXMLContext.currentWrapper();
            runtimeConfigurable.addText(cArray, n, n2);
        }

        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            return elementHandler;
        }

        public void onEndElement(String string, String string2, AntXMLContext antXMLContext) {
            antXMLContext.popWrapper();
        }
    }

    public static class MainHandler
    extends AntHandler {
        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            if (string2.equals("project") && (string.equals("") || string.equals("antlib:org.apache.tools.ant"))) {
                return projectHandler;
            }
            throw new SAXParseException("Unexpected element \"" + string3 + "\" " + string2, antXMLContext.getLocator());
        }
    }

    public static class ProjectHandler
    extends AntHandler {
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            Object object;
            String string4;
            String string5;
            Object var6_6 = null;
            Object object2 = null;
            boolean bl = false;
            Project project = antXMLContext.getProject();
            int n = 0;
            while (n < attributes.getLength()) {
                string5 = attributes.getURI(n);
                if (string5 == null || string5.equals("") || string5.equals(string)) {
                    string4 = attributes.getLocalName(n);
                    object = attributes.getValue(n);
                    if (string4.equals("default")) {
                        if (object != null && !((String)object).equals("") && !antXMLContext.isIgnoringProjectTag()) {
                            project.setDefault((String)object);
                        }
                    } else if (string4.equals("name")) {
                        if (object != null) {
                            antXMLContext.setCurrentProjectName((String)object);
                            bl = true;
                            if (!antXMLContext.isIgnoringProjectTag()) {
                                project.setName((String)object);
                                project.addReference((String)object, project);
                            }
                        }
                    } else if (string4.equals("id")) {
                        if (object != null && !antXMLContext.isIgnoringProjectTag()) {
                            project.addReference((String)object, project);
                        }
                    } else if (string4.equals("basedir")) {
                        if (!antXMLContext.isIgnoringProjectTag()) {
                            object2 = object;
                        }
                    } else {
                        throw new SAXParseException("Unexpected attribute \"" + attributes.getQName(n) + "\"", antXMLContext.getLocator());
                    }
                }
                ++n;
            }
            string5 = "ant.file." + antXMLContext.getCurrentProjectName();
            string4 = project.getProperty(string5);
            if (string4 != null && bl) {
                object = new File(string4);
                if (antXMLContext.isIgnoringProjectTag() && !((File)object).equals(antXMLContext.getBuildFile())) {
                    project.log("Duplicated project name in import. Project " + antXMLContext.getCurrentProjectName() + " defined first in " + string4 + " and again in " + antXMLContext.getBuildFile(), 1);
                }
            }
            if (antXMLContext.getBuildFile() != null) {
                project.setUserProperty("ant.file." + antXMLContext.getCurrentProjectName(), antXMLContext.getBuildFile().toString());
            }
            if (antXMLContext.isIgnoringProjectTag()) {
                return;
            }
            if (project.getProperty("basedir") != null) {
                project.setBasedir(project.getProperty("basedir"));
            } else if (object2 == null) {
                project.setBasedir(antXMLContext.getBuildFileParent().getAbsolutePath());
            } else if (new File((String)object2).isAbsolute()) {
                project.setBasedir((String)object2);
            } else {
                project.setBaseDir(fu.resolveFile(antXMLContext.getBuildFileParent(), (String)object2));
            }
            project.addTarget("", antXMLContext.getImplicitTarget());
            antXMLContext.setCurrentTarget(antXMLContext.getImplicitTarget());
        }

        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            if (string2.equals("target") && (string.equals("") || string.equals("antlib:org.apache.tools.ant"))) {
                return targetHandler;
            }
            return elementHandler;
        }
    }

    public static class RootHandler
    extends DefaultHandler {
        private Stack antHandlers = new Stack();
        private AntHandler currentHandler = null;
        private AntXMLContext context;

        public RootHandler(AntXMLContext antXMLContext, AntHandler antHandler) {
            this.currentHandler = antHandler;
            this.antHandlers.push(this.currentHandler);
            this.context = antXMLContext;
        }

        public AntHandler getCurrentAntHandler() {
            return this.currentHandler;
        }

        public InputSource resolveEntity(String string, String string2) {
            this.context.getProject().log("resolving systemId: " + string2, 3);
            if (string2.startsWith("file:")) {
                String string3 = fu.fromURI(string2);
                File file = new File(string3);
                if (!file.isAbsolute()) {
                    file = fu.resolveFile(this.context.getBuildFileParent(), string3);
                }
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId(fu.toURI(file.getAbsolutePath()));
                    return inputSource;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.context.getProject().log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            return null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXParseException {
            AntHandler antHandler = this.currentHandler.onStartChild(string, string2, string3, attributes, this.context);
            this.antHandlers.push(this.currentHandler);
            this.currentHandler = antHandler;
            this.currentHandler.onStartElement(string, string2, string3, attributes, this.context);
        }

        public void setDocumentLocator(Locator locator) {
            this.context.setLocator(locator);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            AntHandler antHandler;
            this.currentHandler.onEndElement(string, string2, this.context);
            this.currentHandler = antHandler = (AntHandler)this.antHandlers.pop();
            if (this.currentHandler != null) {
                this.currentHandler.onEndChild(string, string2, string3, this.context);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            this.currentHandler.characters(cArray, n, n2, this.context);
        }

        public void startPrefixMapping(String string, String string2) {
            this.context.startPrefixMapping(string, string2);
        }

        public void endPrefixMapping(String string) {
            this.context.endPrefixMapping(string);
        }
    }

    public static class TargetHandler
    extends AntHandler {
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            String string4;
            Object object;
            String string5 = null;
            String string6 = "";
            Project project = antXMLContext.getProject();
            Target target = new Target();
            target.setProject(project);
            antXMLContext.addTarget(target);
            int n = 0;
            while (n < attributes.getLength()) {
                object = attributes.getURI(n);
                if (object == null || ((String)object).equals("") || ((String)object).equals(string)) {
                    string4 = attributes.getLocalName(n);
                    String string7 = attributes.getValue(n);
                    if (string4.equals("name")) {
                        string5 = string7;
                        if ("".equals(string5)) {
                            throw new BuildException("name attribute must not be empty");
                        }
                    } else if (string4.equals("depends")) {
                        string6 = string7;
                    } else if (string4.equals("if")) {
                        target.setIf(string7);
                    } else if (string4.equals("unless")) {
                        target.setUnless(string7);
                    } else if (string4.equals("id")) {
                        if (string7 != null && !string7.equals("")) {
                            antXMLContext.getProject().addReference(string7, target);
                        }
                    } else if (string4.equals("description")) {
                        target.setDescription(string7);
                    } else {
                        throw new SAXParseException("Unexpected attribute \"" + string4 + "\"", antXMLContext.getLocator());
                    }
                }
                ++n;
            }
            if (string5 == null) {
                throw new SAXParseException("target element appears without a name attribute", antXMLContext.getLocator());
            }
            object = project.getTargets();
            if (((Hashtable)object).containsKey(string5)) {
                if (!antXMLContext.isIgnoringProjectTag()) {
                    throw new BuildException("Duplicate target '" + string5 + "'", new Location(antXMLContext.getLocator().getSystemId(), antXMLContext.getLocator().getLineNumber(), antXMLContext.getLocator().getColumnNumber()));
                }
                if (antXMLContext.getCurrentProjectName() != null) {
                    string4 = antXMLContext.getCurrentProjectName() + "." + string5;
                    project.log("Already defined in main or a previous import, define " + string5 + " as " + string4, 3);
                    string5 = string4;
                } else {
                    project.log("Already defined in main or a previous import, ignore " + string5, 3);
                    string5 = null;
                }
            }
            if (string5 != null) {
                target.setName(string5);
                project.addOrReplaceTarget(string5, target);
            }
            if (string6.length() > 0) {
                target.setDepends(string6);
            }
        }

        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            return elementHandler;
        }

        public void onEndElement(String string, String string2, AntXMLContext antXMLContext) {
            antXMLContext.setCurrentTarget(antXMLContext.getImplicitTarget());
        }
    }
}

