/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;
import org.apache.tools.ant.util.KeepAliveInputStream;

public class DefaultInputHandler
implements InputHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInput(InputRequest inputRequest) throws BuildException {
        String string = this.getPrompt(inputRequest);
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new KeepAliveInputStream(this.getInputStream()));
            do {
                System.err.println(string);
                System.err.flush();
                try {
                    String string2 = ((DataInputStream)filterInputStream).readLine();
                    inputRequest.setInput(string2);
                }
                catch (IOException iOException) {
                    throw new BuildException("Failed to read input from Console.", iOException);
                }
            } while (!inputRequest.isInputValid());
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    throw new BuildException("Failed to close input.", iOException);
                }
            }
        }
    }

    protected String getPrompt(InputRequest inputRequest) {
        String string = inputRequest.getPrompt();
        if (inputRequest instanceof MultipleChoiceInputRequest) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("(");
            Enumeration enumeration = ((MultipleChoiceInputRequest)inputRequest).getChoices().elements();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(enumeration.nextElement());
                bl = false;
            }
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        return string;
    }

    protected InputStream getInputStream() {
        return System.in;
    }
}

