/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;
import org.apache.tools.bzip2.CBZip2InputStream;

public class BUnzip2
extends Unpack {
    private static final String DEFAULT_EXTENSION = ".bz2";

    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.dest);
                fileInputStream = new FileInputStream(this.source);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                int n = bufferedInputStream.read();
                if (n != 66) {
                    throw new BuildException("Invalid bz2 file.", this.getLocation());
                }
                n = bufferedInputStream.read();
                if (n != 90) {
                    throw new BuildException("Invalid bz2 file.", this.getLocation());
                }
                inputStream = new CBZip2InputStream(bufferedInputStream);
                byte[] byArray = new byte[8192];
                int n2 = 0;
                do {
                    fileOutputStream.write(byArray, 0, n2);
                } while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1);
            }
            catch (IOException iOException) {
                String string = "Problem expanding bzip2 " + iOException.getMessage();
                throw new BuildException(string, iOException, this.getLocation());
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

