/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class BuildNumber
extends Task {
    private static final String DEFAULT_PROPERTY_NAME = "build.number";
    private static final String DEFAULT_FILENAME = "build.number";
    private File myFile;

    public void setFile(File file) {
        this.myFile = file;
    }

    public void execute() throws BuildException {
        File file = this.myFile;
        this.validate();
        Properties properties = this.loadProperties();
        int n = this.getBuildNumber(properties);
        properties.put("build.number", String.valueOf(n + 1));
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.myFile);
            String string = "Build Number for ANT. Do not edit!";
            properties.store(fileOutputStream, "Build Number for ANT. Do not edit!");
        }
        catch (IOException iOException) {
            String string = "Error while writing " + this.myFile;
            throw new BuildException(string, iOException);
        }
        finally {
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.getProject().log("error closing output stream " + iOException, 0);
                }
            }
            this.myFile = file;
        }
        this.getProject().setNewProperty("build.number", String.valueOf(n));
    }

    private int getBuildNumber(Properties properties) throws BuildException {
        String string = properties.getProperty("build.number", "0").trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = this.myFile + " contains a non integer build number: " + string;
            throw new BuildException(string2, numberFormatException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() throws BuildException {
        Properties properties;
        FileInputStream fileInputStream = null;
        try {
            Properties properties2 = new Properties();
            fileInputStream = new FileInputStream(this.myFile);
            properties2.load(fileInputStream);
            properties = properties2;
            if (null == fileInputStream) return properties;
        }
        catch (IOException iOException) {
            try {
                throw new BuildException(iOException);
            }
            catch (Throwable throwable) {
                if (null == fileInputStream) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    this.getProject().log("error closing input stream " + iOException2, 0);
                    throw throwable;
                }
            }
        }
        try {
            fileInputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            this.getProject().log("error closing input stream " + iOException, 0);
        }
        return properties;
    }

    private void validate() throws BuildException {
        if (null == this.myFile) {
            this.myFile = this.getProject().resolveFile("build.number");
        }
        if (!this.myFile.exists()) {
            try {
                FileUtils.newFileUtils().createNewFile(this.myFile);
            }
            catch (IOException iOException) {
                String string = this.myFile + " doesn't exist and new file can't be created.";
                throw new BuildException(string, iOException);
            }
        }
        if (!this.myFile.canRead()) {
            String string = "Unable to read from " + this.myFile + ".";
            throw new BuildException(string);
        }
        if (!this.myFile.canWrite()) {
            String string = "Unable to write to " + this.myFile + ".";
            throw new BuildException(string);
        }
    }
}

