/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.FileSet;

public class Checksum
extends MatchingTask
implements Condition {
    private File file = null;
    private File todir;
    private String algorithm = "MD5";
    private String provider = null;
    private String fileext;
    private String property;
    private Map allDigests = new HashMap();
    private Map relativeFilePaths = new HashMap();
    private String totalproperty;
    private boolean forceOverwrite;
    private String verifyProperty;
    private Vector filesets = new Vector();
    private Hashtable includeFileMap = new Hashtable();
    private MessageDigest messageDigest;
    private boolean isCondition;
    private int readBufferSize = 8192;

    public void setFile(File file) {
        this.file = file;
    }

    public void setTodir(File file) {
        this.todir = file;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public void setFileext(String string) {
        this.fileext = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setTotalproperty(String string) {
        this.totalproperty = string;
    }

    public void setVerifyproperty(String string) {
        this.verifyProperty = string;
    }

    public void setForceOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public void setReadBufferSize(int n) {
        this.readBufferSize = n;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        this.isCondition = false;
        boolean bl = this.validateAndExecute();
        if (this.verifyProperty != null) {
            this.getProject().setNewProperty(this.verifyProperty, new Boolean(bl).toString());
        }
    }

    public boolean eval() throws BuildException {
        this.isCondition = true;
        return this.validateAndExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAndExecute() throws BuildException {
        String string = this.fileext;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Checksum cannot be generated for directories");
        }
        if (this.file != null && this.totalproperty != null) {
            throw new BuildException("File and Totalproperty cannot co-exist.");
        }
        if (this.property != null && this.fileext != null) {
            throw new BuildException("Property and FileExt cannot co-exist.");
        }
        if (this.property != null) {
            if (this.forceOverwrite) {
                throw new BuildException("ForceOverwrite cannot be used when Property is specified");
            }
            if (this.file != null ? this.filesets.size() > 0 : this.filesets.size() > 1) {
                throw new BuildException("Multiple files cannot be used when Property is specified");
            }
        }
        if (this.verifyProperty != null) {
            this.isCondition = true;
        }
        if (this.verifyProperty != null && this.forceOverwrite) {
            throw new BuildException("VerifyProperty and ForceOverwrite cannot co-exist.");
        }
        if (this.isCondition && this.forceOverwrite) {
            throw new BuildException("ForceOverwrite cannot be used when conditions are being used.");
        }
        this.messageDigest = null;
        if (this.provider != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new BuildException(noSuchAlgorithmException, this.getLocation());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new BuildException(noSuchProviderException, this.getLocation());
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new BuildException(noSuchAlgorithmException, this.getLocation());
        }
        if (this.messageDigest == null) {
            throw new BuildException("Unable to create Message Digest", this.getLocation());
        }
        if (this.fileext == null) {
            this.fileext = "." + this.algorithm;
        } else if (this.fileext.trim().length() == 0) {
            throw new BuildException("File extension when specified must not be an empty string");
        }
        try {
            int n = this.filesets.size();
            int n2 = 0;
            while (n2 < n) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(n2);
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                int n3 = 0;
                while (n3 < stringArray.length) {
                    File file = new File(fileSet.getDir(this.getProject()), stringArray[n3]);
                    if (this.totalproperty != null || this.todir != null) {
                        String string2 = stringArray[n3].replace(File.separatorChar, '/');
                        this.relativeFilePaths.put(file, string2);
                    }
                    this.addToIncludeFileMap(file);
                    ++n3;
                }
                ++n2;
            }
            this.addToIncludeFileMap(this.file);
            boolean bl = this.generateChecksums();
            Object var11_14 = null;
            this.fileext = string;
            this.includeFileMap.clear();
            return bl;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.fileext = string;
            this.includeFileMap.clear();
            throw throwable;
        }
    }

    private void addToIncludeFileMap(File file) throws BuildException {
        if (file != null) {
            if (file.exists()) {
                if (this.property == null) {
                    File file2 = this.getChecksumFile(file);
                    if (this.forceOverwrite || this.isCondition || file.lastModified() > file2.lastModified()) {
                        this.includeFileMap.put(file, file2);
                    } else {
                        this.log(file + " omitted as " + file2 + " is up to date.", 3);
                        if (this.totalproperty != null) {
                            Object object;
                            String string = null;
                            try {
                                object = new BufferedReader(new FileReader(file2));
                                string = ((BufferedReader)object).readLine();
                            }
                            catch (IOException iOException) {
                                throw new BuildException("Couldn't read checksum file " + file2, iOException);
                            }
                            object = Checksum.decodeHex(string.toCharArray());
                            this.allDigests.put(file, object);
                        }
                    }
                } else {
                    this.includeFileMap.put(file, this.property);
                }
            } else {
                String string = "Could not find file " + file.getAbsolutePath() + " to generate checksum for.";
                this.log(string);
                throw new BuildException(string, this.getLocation());
            }
        }
    }

    private File getChecksumFile(File file) {
        File file2;
        Object object;
        if (this.todir != null) {
            object = (String)this.relativeFilePaths.get(file);
            file2 = new File(this.todir, (String)object).getParentFile();
            file2.mkdirs();
        } else {
            file2 = file.getParentFile();
        }
        object = new File(file2, file.getName() + this.fileext);
        return object;
    }

    private boolean generateChecksums() throws BuildException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[this.readBufferSize];
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Enumeration enumeration = this.includeFileMap.keys();
            while (enumeration.hasMoreElements()) {
                this.messageDigest.reset();
                object5 = (File)enumeration.nextElement();
                if (!this.isCondition) {
                    this.log("Calculating " + this.algorithm + " checksum for " + object5, 3);
                }
                fileInputStream = new FileInputStream((File)object5);
                object4 = new DigestInputStream(fileInputStream, this.messageDigest);
                while (((DigestInputStream)object4).read(byArray, 0, this.readBufferSize) != -1) {
                }
                ((FilterInputStream)object4).close();
                fileInputStream.close();
                fileInputStream = null;
                byte[] byArray2 = this.messageDigest.digest();
                if (this.totalproperty != null) {
                    this.allDigests.put(object5, byArray2);
                }
                object3 = this.createDigestString(byArray2);
                object2 = this.includeFileMap.get(object5);
                if (object2 instanceof String) {
                    object = (String)object2;
                    if (this.isCondition) {
                        bl = bl && ((String)object3).equals(this.property);
                        continue;
                    }
                    this.getProject().setNewProperty((String)object, (String)object3);
                    continue;
                }
                if (!(object2 instanceof File)) continue;
                if (this.isCondition) {
                    object = (File)object2;
                    if (((File)object).exists()) {
                        fileInputStream = new FileInputStream((File)object);
                        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        String string = bufferedReader.readLine();
                        fileInputStream.close();
                        fileInputStream = null;
                        bufferedReader.close();
                        inputStreamReader.close();
                        bl = bl && ((String)object3).equals(string);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                object = (File)object2;
                fileOutputStream = new FileOutputStream((File)object);
                fileOutputStream.write(((String)object3).getBytes());
                fileOutputStream.close();
                fileOutputStream = null;
            }
            if (this.totalproperty != null) {
                object5 = this.allDigests.keySet();
                object4 = object5.toArray();
                Arrays.sort((Object[])object4);
                this.messageDigest.reset();
                int n = 0;
                while (n < ((Object[])object4).length) {
                    object3 = (File)object4[n];
                    object2 = (byte[])this.allDigests.get(object3);
                    this.messageDigest.update((byte[])object2);
                    object = (String)this.relativeFilePaths.get(object3);
                    this.messageDigest.update(((String)object).getBytes());
                    ++n;
                }
                object3 = this.createDigestString(this.messageDigest.digest());
                this.getProject().setNewProperty(this.totalproperty, (String)object3);
            }
        }
        catch (Exception exception) {
            throw new BuildException(exception, this.getLocation());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private String createDigestString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            String string = Integer.toHexString(0xFF & byArray[n]);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] decodeHex(char[] cArray) throws BuildException {
        int n = cArray.length;
        if ((n & 1) != 0) {
            throw new BuildException("odd number of characters.");
        }
        byte[] byArray = new byte[n >> 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Character.digit(cArray[n3++], 16) << 4;
            byArray[n2] = (byte)((n4 |= Character.digit(cArray[n3++], 16)) & 0xFF);
            ++n2;
        }
        return byArray;
    }
}

