/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Chmod
extends ExecuteOn {
    private FileSet defaultSet = new FileSet();
    private boolean defaultSetDefined = false;
    private boolean havePerm = false;

    public Chmod() {
        super.setExecutable("chmod");
        super.setParallel(true);
        super.setSkipEmptyFilesets(true);
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.defaultSet.setProject(project);
    }

    public void setFile(File file) {
        FileSet fileSet = new FileSet();
        fileSet.setFile(file);
        this.addFileset(fileSet);
    }

    public void setDir(File file) {
        this.defaultSet.setDir(file);
    }

    public void setPerm(String string) {
        this.createArg().setValue(string);
        this.havePerm = true;
    }

    public PatternSet.NameEntry createInclude() {
        this.defaultSetDefined = true;
        return this.defaultSet.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        this.defaultSetDefined = true;
        return this.defaultSet.createExclude();
    }

    public PatternSet createPatternSet() {
        this.defaultSetDefined = true;
        return this.defaultSet.createPatternSet();
    }

    public void setIncludes(String string) {
        this.defaultSetDefined = true;
        this.defaultSet.setIncludes(string);
    }

    public void setExcludes(String string) {
        this.defaultSetDefined = true;
        this.defaultSet.setExcludes(string);
    }

    public void setDefaultexcludes(boolean bl) {
        this.defaultSetDefined = true;
        this.defaultSet.setDefaultexcludes(bl);
    }

    protected void checkConfiguration() {
        if (!this.havePerm) {
            throw new BuildException("Required attribute perm not set in chmod", this.getLocation());
        }
        if (this.defaultSetDefined && this.defaultSet.getDir(this.getProject()) != null) {
            this.addFileset(this.defaultSet);
        }
        super.checkConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.defaultSetDefined || this.defaultSet.getDir(this.getProject()) == null) {
            try {
                super.execute();
                return;
            }
            finally {
                if (this.defaultSetDefined && this.defaultSet.getDir(this.getProject()) != null) {
                    this.filesets.removeElement(this.defaultSet);
                }
            }
        }
        if (!this.isValidOs()) return;
        Execute execute = this.prepareExec();
        Commandline commandline = (Commandline)this.cmdl.clone();
        commandline.createArgument().setValue(this.defaultSet.getDir(this.getProject()).getPath());
        try {
            try {
                execute.setCommandline(commandline.getCommandline());
                this.runExecute(execute);
            }
            catch (IOException iOException) {
                throw new BuildException("Execute failed: " + iOException, iOException, this.getLocation());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.logFlush();
            throw throwable;
        }
        this.logFlush();
    }

    public void setExecutable(String string) {
        throw new BuildException(this.getTaskType() + " doesn't support the executable attribute", this.getLocation());
    }

    public void setCommand(Commandline commandline) {
        throw new BuildException(this.getTaskType() + " doesn't support the command attribute", this.getLocation());
    }

    public void setSkipEmptyFilesets(boolean bl) {
        throw new BuildException(this.getTaskType() + " doesn't support the skipemptyfileset attribute", this.getLocation());
    }

    public void setAddsourcefile(boolean bl) {
        throw new BuildException(this.getTaskType() + " doesn't support the addsourcefile attribute", this.getLocation());
    }

    protected boolean isValidOs() {
        return Os.isFamily("unix") && super.isValidOs();
    }
}

