/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector filesets = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    private boolean failonerror = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Hashtable completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    private Vector filterChains = new Vector();
    private Vector filterSets = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private String inputEncoding = null;
    private String outputEncoding = null;
    private long granularity = this.fileUtils.getFileTimestampGranularity();

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File file) {
        this.destFile = file;
    }

    public void setTodir(File file) {
        this.destDir = file;
    }

    public FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return filterChain;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void setPreserveLastModified(String string) {
        this.setPreserveLastModified(Project.toBoolean(string));
    }

    public void setPreserveLastModified(boolean bl) {
        this.preserveLastModified = bl;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected Vector getFilterChains() {
        return this.filterChains;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public void setOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmpty = bl;
    }

    public void setEnableMultipleMappings(boolean bl) {
        this.enableMultipleMappings = bl;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean bl) {
        this.failonerror = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void setEncoding(String string) {
        this.inputEncoding = string;
        if (this.outputEncoding == null) {
            this.outputEncoding = string;
        }
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setGranularity(long l) {
        this.granularity = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block22: {
            File file = this.file;
            File file2 = this.destFile;
            File file3 = this.destDir;
            FileSet fileSet = null;
            if (this.file == null && this.destFile != null && this.filesets.size() == 1) {
                fileSet = (FileSet)this.filesets.elementAt(0);
            }
            this.validateAttributes();
            try {
                if (this.file != null) {
                    if (this.file.exists()) {
                        if (this.destFile == null) {
                            this.destFile = new File(this.destDir, this.file.getName());
                        }
                        if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                            this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                        } else {
                            this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                        }
                    } else {
                        String string = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                        if (!this.failonerror) {
                            this.log(string);
                        } else {
                            throw new BuildException(string);
                        }
                    }
                }
                int n = 0;
                while (n < this.filesets.size()) {
                    block21: {
                        boolean bl;
                        FileSet fileSet2 = (FileSet)this.filesets.elementAt(n);
                        DirectoryScanner directoryScanner = null;
                        try {
                            directoryScanner = fileSet2.getDirectoryScanner(this.getProject());
                        }
                        catch (BuildException buildException) {
                            if (this.failonerror || !buildException.getMessage().endsWith(" not found.")) {
                                throw buildException;
                            }
                            this.log("Warning: " + buildException.getMessage());
                            break block21;
                        }
                        File file4 = fileSet2.getDir(this.getProject());
                        String[] stringArray = directoryScanner.getIncludedFiles();
                        String[] stringArray2 = directoryScanner.getIncludedDirectories();
                        boolean bl2 = bl = directoryScanner.isEverythingIncluded() && !fileSet2.hasSelectors() && !fileSet2.hasPatterns();
                        if (bl && !this.flatten && this.mapperElement == null) {
                            this.completeDirMap.put(file4, this.destDir);
                        }
                        this.scan(file4, this.destDir, stringArray, stringArray2);
                    }
                    ++n;
                }
                try {
                    this.doFileOperations();
                }
                catch (BuildException buildException) {
                    if (!this.failonerror) {
                        this.log("Warning: " + buildException.getMessage(), 0);
                        break block22;
                    }
                    throw buildException;
                }
            }
            finally {
                this.file = file;
                this.destFile = file2;
                this.destDir = file3;
                if (fileSet != null) {
                    this.filesets.insertElementAt(fileSet, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            if (this.filesets.size() > 1) {
                throw new BuildException("Cannot concatenate multiple files into a single file.");
            }
            FileSet fileSet = (FileSet)this.filesets.elementAt(0);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            if (stringArray.length == 0) {
                throw new BuildException("Cannot perform operation from directory to file.");
            }
            if (stringArray.length != 1) throw new BuildException("Cannot concatenate multiple files into a single file.");
            if (this.file != null) throw new BuildException("Cannot concatenate multiple files into a single file.");
            this.file = new File(directoryScanner.getBasedir(), stringArray[0]);
            this.filesets.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.fileUtils.getParentFile(this.destFile);
    }

    protected void scan(File file, File file2, String[] stringArray, String[] stringArray2) {
        FileNameMapper fileNameMapper = null;
        fileNameMapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        this.buildMap(file, file2, stringArray, fileNameMapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(file, file2, stringArray2, fileNameMapper, this.dirCopyMap);
        }
    }

    protected void buildMap(File file, File file2, String[] stringArray, FileNameMapper fileNameMapper, Hashtable hashtable) {
        Object object;
        Object[] objectArray = null;
        if (this.forceOverwrite) {
            object = new Vector();
            int n = 0;
            while (n < stringArray.length) {
                if (fileNameMapper.mapFileName(stringArray[n]) != null) {
                    ((Vector)object).addElement(stringArray[n]);
                }
                ++n;
            }
            objectArray = new String[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
        } else {
            object = new SourceFileScanner(this);
            objectArray = ((SourceFileScanner)object).restrict(stringArray, file, file2, fileNameMapper, this.granularity);
        }
        int n = 0;
        while (n < objectArray.length) {
            File file3 = new File(file, (String)objectArray[n]);
            String[] stringArray2 = fileNameMapper.mapFileName((String)objectArray[n]);
            if (!this.enableMultipleMappings) {
                hashtable.put(file3.getAbsolutePath(), new String[]{new File(file2, stringArray2[0]).getAbsolutePath()});
            } else {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    stringArray2[n2] = new File(file2, stringArray2[n2]).getAbsolutePath();
                    ++n2;
                }
                hashtable.put(file3.getAbsolutePath(), stringArray2);
            }
            ++n;
        }
    }

    protected void doFileOperations() {
        Object object;
        int n;
        String[] stringArray;
        Enumeration<Object> enumeration;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringArray = (String[])this.fileCopyMap.get(string);
                n = 0;
                while (n < stringArray.length) {
                    object = stringArray[n];
                    if (string.equals(object)) {
                        this.log("Skipping self-copy of " + string, this.verbosity);
                    } else {
                        Object object2;
                        try {
                            this.log("Copying " + string + " to " + (String)object, this.verbosity);
                            FilterSetCollection filterSetCollection = new FilterSetCollection();
                            if (this.filtering) {
                                filterSetCollection.addFilterSet(this.getProject().getGlobalFilterSet());
                            }
                            object2 = this.filterSets.elements();
                            while (object2.hasMoreElements()) {
                                filterSetCollection.addFilterSet((FilterSet)object2.nextElement());
                            }
                            this.fileUtils.copyFile(string, (String)object, filterSetCollection, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                        }
                        catch (IOException iOException) {
                            object2 = "Failed to copy " + string + " to " + (String)object + " due to " + iOException.getMessage();
                            File file = new File((String)object);
                            if (file.exists() && !file.delete()) {
                                object2 = (String)object2 + " and I couldn't delete the corrupt " + (String)object;
                            }
                            throw new BuildException((String)object2, iOException, this.getLocation());
                        }
                    }
                    ++n;
                }
            }
        }
        if (this.includeEmpty) {
            enumeration = this.dirCopyMap.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                n = 0;
                while (n < stringArray.length) {
                    object = new File(stringArray[n]);
                    if (!((File)object).exists()) {
                        if (!((File)object).mkdirs()) {
                            this.log("Unable to create directory " + ((File)object).getAbsolutePath(), 0);
                        } else {
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            if (n2 > 0) {
                this.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + n2 + " empty director" + (n2 == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }
}

