/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.ProcessDestroyer;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;

public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private boolean useVMLauncher = true;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;
    private boolean spawn = false;
    private static ProcessDestroyer processDestroyer = new ProcessDestroyer();
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Runtime;

    public void setSpawn(boolean bl) {
        this.spawn = bl;
    }

    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Execute execute = new Execute(new PumpStreamHandler(byteArrayOutputStream));
            execute.setCommandline(Execute.getProcEnvCommand());
            execute.setNewenvironment(true);
            int n = execute.execute();
            if (n != 0) {
                // empty if block
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(Execute.toString(byteArrayOutputStream)));
            if (Os.isFamily("openvms")) {
                procEnvironment = Execute.addVMSLogicals(procEnvironment, bufferedReader);
                return procEnvironment;
            }
            String string2 = null;
            String string3 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(61) == -1) {
                    if (string2 == null) {
                        string2 = string3 + string;
                        continue;
                    }
                    string2 = string2 + string3 + string;
                    continue;
                }
                if (string2 != null) {
                    procEnvironment.addElement(string2);
                }
                string2 = string;
            }
            if (string2 != null) {
                procEnvironment.addElement(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                return new String[]{"command.com", "/c", "set"};
            }
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("z/os") || Os.isFamily("unix")) {
            String[] stringArray = new String[]{new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")};
            return stringArray;
        }
        if (Os.isFamily("netware") || Os.isFamily("os/400")) {
            return new String[]{"env"};
        }
        if (Os.isFamily("openvms")) {
            return new String[]{"show", "logical"};
        }
        return null;
    }

    public static String toString(ByteArrayOutputStream byteArrayOutputStream) {
        block6: {
            if (Os.isFamily("z/os")) {
                try {
                    return byteArrayOutputStream.toString("Cp1047");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    break block6;
                }
            }
            if (Os.isFamily("os/400")) {
                try {
                    return byteArrayOutputStream.toString("Cp500");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                {
                }
            }
        }
        return byteArrayOutputStream.toString();
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler) {
        this(executeStreamHandler, null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler, ExecuteWatchdog executeWatchdog) {
        this.setStreamHandler(executeStreamHandler);
        this.watchdog = executeWatchdog;
    }

    public void setStreamHandler(ExecuteStreamHandler executeStreamHandler) {
        this.streamHandler = executeStreamHandler;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] stringArray) {
        this.cmdl = stringArray;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] stringArray) {
        this.env = stringArray;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file == null || file.getAbsolutePath().equals(antWorkingDirectory) ? null : file;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean bl) {
        this.useVMLauncher = bl;
    }

    public static Process launch(Project project, String[] stringArray, String[] stringArray2, File file, boolean bl) throws IOException {
        CommandLauncher commandLauncher;
        CommandLauncher commandLauncher2 = commandLauncher = vmLauncher != null ? vmLauncher : shellLauncher;
        if (!bl) {
            commandLauncher = shellLauncher;
        }
        if (file != null && !file.exists()) {
            throw new BuildException(file + " doesn't exist.");
        }
        return commandLauncher.exec(project, stringArray, stringArray2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException {
        int n;
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            process.destroy();
            throw iOException;
        }
        this.streamHandler.start();
        try {
            processDestroyer.add(process);
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            this.waitFor(process);
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            this.streamHandler.stop();
            Execute.closeStreams(process);
            if (this.watchdog != null) {
                this.watchdog.checkException();
            }
            n = this.getExitValue();
            Object var4_4 = null;
            processDestroyer.remove(process);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            processDestroyer.remove(process);
            throw throwable;
        }
        return n;
    }

    public void spawn() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        if (Os.isFamily("windows")) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                this.project.log("interruption in the sleep after having spawned a process", 3);
            }
        }
        OutputStream outputStream = new OutputStream(){

            public void write(int n) throws IOException {
            }
        };
        PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(outputStream);
        pumpStreamHandler.setProcessErrorStream(process.getErrorStream());
        pumpStreamHandler.setProcessOutputStream(process.getInputStream());
        pumpStreamHandler.start();
        process.getOutputStream().close();
        this.project.log("spawned process " + process.toString(), 3);
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
        }
    }

    protected void setExitValue(int n) {
        this.exitValue = n;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public static boolean isFailure(int n) {
        if (Os.isFamily("openvms")) {
            return n % 2 == 0;
        }
        return n != 0;
    }

    public boolean killedProcess() {
        return this.watchdog != null && this.watchdog.killedProcess();
    }

    private String[] patchEnvironment() {
        if (Os.isFamily("openvms")) {
            return this.env;
        }
        Vector vector = (Vector)Execute.getProcEnvironment().clone();
        int n = 0;
        while (n < this.env.length) {
            int n2 = this.env[n].indexOf(61);
            String string = this.env[n].substring(0, n2 + 1);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (((String)vector.elementAt(n4)).startsWith(string)) {
                    vector.removeElementAt(n4);
                    break;
                }
                ++n4;
            }
            vector.addElement(this.env[n]);
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void runCommand(Task task, String[] stringArray) throws BuildException {
        try {
            task.log(Commandline.describeCommand(stringArray), 3);
            Execute execute = new Execute(new LogStreamHandler(task, 2, 0));
            execute.setAntRun(task.getProject());
            execute.setCommandline(stringArray);
            int n = execute.execute();
            if (Execute.isFailure(n)) {
                throw new BuildException(stringArray[0] + " failed with return code " + n, task.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not launch " + stringArray[0] + ": " + iOException, task.getLocation());
        }
    }

    public static void closeStreams(Process process) {
        try {
            process.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {}
    }

    private static Vector addVMSLogicals(Vector vector, BufferedReader bufferedReader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        String string2 = null;
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            int n;
            String string4;
            if (string3.startsWith("\t=")) {
                if (string == null) continue;
                string2 = string2 + "," + string3.substring(4, string3.length() - 1);
                continue;
            }
            if (!string3.startsWith("  \"")) continue;
            if (string != null) {
                hashMap.put(string, string2);
            }
            if (hashMap.containsKey(string4 = string3.substring(3, (n = string3.indexOf(61)) - 2))) {
                string = null;
                continue;
            }
            string = string4;
            string2 = string3.substring(n + 3, string3.length() - 1);
        }
        if (string != null) {
            hashMap.put(string, string2);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            vector.add(string5 + "=" + hashMap.get(string5));
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            if (Os.isFamily("openvms")) {
                vmLauncher = new VmsCommandLauncher();
            } else if (!Os.isFamily("os/2")) {
                vmLauncher = new Java13CommandLauncher();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (Os.isFamily("mac") && !Os.isFamily("unix")) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("os/2")) {
            shellLauncher = new OS2CommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("windows")) {
            CommandLauncher commandLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = !Os.isFamily("win9x") ? new WinNTCommandLauncher(commandLauncher) : new ScriptCommandLauncher("bin/antRun.bat", commandLauncher);
        } else if (Os.isFamily("netware")) {
            CommandLauncher commandLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = new PerlScriptCommandLauncher("bin/antRun.pl", commandLauncher);
        } else {
            shellLauncher = Os.isFamily("openvms") ? vmLauncher : new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    private static class CommandLauncher {
        private CommandLauncher() {
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            if (project != null) {
                project.log("Execute:CommandLauncher: " + Commandline.describeCommand(stringArray), 4);
            }
            return Runtime.getRuntime().exec(stringArray, stringArray2);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher myLauncher;

        CommandLauncherProxy(CommandLauncher commandLauncher) {
            this.myLauncher = commandLauncher;
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            return this.myLauncher.exec(project, stringArray, stringArray2);
        }
    }

    private static class Java11CommandLauncher
    extends CommandLauncher {
        private Java11CommandLauncher() {
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            String[] stringArray3 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray3[n] = Commandline.quoteArgument(stringArray[n]);
                ++n;
            }
            if (project != null) {
                project.log("Execute:Java11CommandLauncher: " + Commandline.describeCommand(stringArray3), 4);
            }
            return Runtime.getRuntime().exec(stringArray3, stringArray2);
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method myExecWithCWD = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Execute.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("exec", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Execute.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Execute.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$File == null ? (class$java$io$File = Execute.class$("java.io.File")) : class$java$io$File);

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            try {
                if (project != null) {
                    project.log("Execute:Java13CommandLauncher: " + Commandline.describeCommand(stringArray), 4);
                }
                Object[] objectArray = new Object[]{stringArray, stringArray2, file};
                return (Process)this.myExecWithCWD.invoke((Object)Runtime.getRuntime(), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new BuildException("Unable to execute command", throwable);
            }
            catch (Exception exception) {
                throw new BuildException("Unable to execute command", exception);
            }
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        MacCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            Process process;
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            System.getProperties().put("user.dir", file.getAbsolutePath());
            try {
                process = this.exec(project, stringArray, stringArray2);
                Object var7_6 = null;
                System.getProperties().put("user.dir", antWorkingDirectory);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                System.getProperties().put("user.dir", antWorkingDirectory);
                throw throwable;
            }
            return process;
        }
    }

    private static class OS2CommandLauncher
    extends CommandLauncherProxy {
        OS2CommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            int n = 7;
            String string = file2.getAbsolutePath();
            String[] stringArray3 = new String[stringArray.length + 7];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = string.substring(0, 2);
            stringArray3[3] = "&&";
            stringArray3[4] = "cd";
            stringArray3[5] = string.substring(2);
            stringArray3[6] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 7, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class PerlScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        PerlScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this.myScript = string;
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = project.resolveFile(string + File.separator + this.myScript).toString();
            File file2 = file;
            if (file == null && project != null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 3];
            stringArray3[0] = "perl";
            stringArray3[1] = string2;
            stringArray3[2] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 3, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        ScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this.myScript = string;
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = project.resolveFile(string + File.separator + this.myScript).toString();
            File file2 = file;
            if (file == null && project != null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 2];
            stringArray3[0] = string2;
            stringArray3[1] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class VmsCommandLauncher
    extends Java13CommandLauncher {
        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            String[] stringArray3 = new String[]{this.createCommandFile(stringArray, stringArray2).getPath()};
            return super.exec(project, stringArray3, stringArray2);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            String[] stringArray3 = new String[]{this.createCommandFile(stringArray, stringArray2).getPath()};
            return super.exec(project, stringArray3, stringArray2, file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createCommandFile(String[] stringArray, String[] stringArray2) throws IOException {
            File file = File.createTempFile("ANT", ".COM");
            file.deleteOnExit();
            PrintWriter printWriter = null;
            try {
                int n;
                printWriter = new PrintWriter(new FileWriter(file));
                if (stringArray2 != null) {
                    int n2 = 1;
                    while (n2 < stringArray2.length) {
                        n = stringArray2[n2].indexOf(61);
                        if (n != -1) {
                            printWriter.print("$ DEFINE/NOLOG ");
                            printWriter.print(stringArray2[n2].substring(0, n));
                            printWriter.print(" \"");
                            printWriter.print(stringArray2[n2].substring(n + 1));
                            printWriter.println('\"');
                        }
                        ++n2;
                    }
                }
                printWriter.print("$ " + stringArray[0]);
                n = 1;
                while (n < stringArray.length) {
                    printWriter.println(" -");
                    printWriter.print(stringArray[n]);
                    ++n;
                }
                Object var8_7 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
            return file;
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        WinNTCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            int n = 6;
            String[] stringArray3 = new String[stringArray.length + 6];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = "cd";
            stringArray3[3] = "/d";
            stringArray3[4] = file2.getAbsolutePath();
            stringArray3[5] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 6, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }
}

