/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

public class ExecuteJava
implements Runnable,
TimeoutObserver {
    private Commandline javaCommand = null;
    private Path classpath = null;
    private CommandlineJava.SysProperties sysProperties = null;
    private Permissions perm = null;
    private Method main = null;
    private Long timeout = null;
    private Throwable caught = null;
    private boolean timedOut = false;
    private Thread thread = null;

    public void setJavaCommand(Commandline commandline) {
        this.javaCommand = commandline;
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setSystemProperties(CommandlineJava.SysProperties sysProperties) {
        this.sysProperties = sysProperties;
    }

    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    public void setOutput(PrintStream printStream) {
    }

    public void setTimeout(Long l) {
        this.timeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Project project) throws BuildException {
        String string = this.javaCommand.getExecutable();
        AntClassLoader antClassLoader = null;
        try {
            if (this.sysProperties != null) {
                this.sysProperties.setSystem();
            }
            Class[] classArray = new Class[]{Class.forName("[Ljava.lang.String;")};
            Class<?> clazz = null;
            if (this.classpath == null) {
                clazz = Class.forName(string);
            } else {
                antClassLoader = project.createClassLoader(this.classpath);
                antClassLoader.setParent(project.getCoreLoader());
                antClassLoader.setParentFirst(false);
                antClassLoader.addJavaLibraries();
                antClassLoader.setIsolated(true);
                antClassLoader.setThreadContextLoader();
                antClassLoader.forceLoadClass(string);
                clazz = Class.forName(string, true, antClassLoader);
            }
            this.main = clazz.getMethod("main", classArray);
            if (this.main == null) {
                throw new BuildException("Could not find main() method in " + string);
            }
            if ((this.main.getModifiers() & 8) == 0) {
                throw new BuildException("main() method in " + string + " is not declared static");
            }
            if (this.timeout == null) {
                this.run();
            } else {
                this.thread = new Thread((Runnable)this, "ExecuteJava");
                Task task = project.getThreadTask(Thread.currentThread());
                project.registerThreadTask(this.thread, task);
                this.thread.setDaemon(true);
                Watchdog watchdog = new Watchdog(this.timeout);
                watchdog.addTimeoutObserver(this);
                ExecuteJava executeJava = this;
                synchronized (executeJava) {
                    this.thread.start();
                    watchdog.start();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.timedOut) {
                        project.log("Timeout: sub-process interrupted", 1);
                    } else {
                        this.thread = null;
                        watchdog.stop();
                    }
                }
            }
            if (this.caught != null) {
                throw this.caught;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("Could not find " + string + "." + " Make sure you have it in your" + " classpath");
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Throwable throwable) {
            throw new BuildException(throwable);
        }
        finally {
            if (antClassLoader != null) {
                antClassLoader.resetThreadContextLoader();
                antClassLoader.cleanup();
            }
            if (this.sysProperties != null) {
                this.sysProperties.restoreSystem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Object[] objectArray = new Object[]{this.javaCommand.getArguments()};
        try {
            if (this.perm != null) {
                this.perm.setSecurityManager();
            }
            this.main.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = invocationTargetException.getTargetException();
            if (!(object instanceof InterruptedException)) {
                this.caught = object;
            }
        }
        catch (Throwable throwable) {
            this.caught = throwable;
        }
        finally {
            if (this.perm != null) {
                this.perm.restoreSecurityManager();
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    public synchronized void timeoutOccured(Watchdog watchdog) {
        if (this.thread != null) {
            this.timedOut = true;
            this.thread.interrupt();
        }
        this.notifyAll();
    }

    public synchronized boolean killedProcess() {
        return this.timedOut;
    }
}

