/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class ExecuteOn
extends ExecTask {
    protected Vector filesets = new Vector();
    private Vector filelists = new Vector();
    private boolean relative = false;
    private boolean parallel = false;
    private boolean forwardSlash = false;
    protected String type = "file";
    protected Commandline.Marker srcFilePos = null;
    private boolean skipEmpty = false;
    protected Commandline.Marker targetFilePos = null;
    protected Mapper mapperElement = null;
    protected FileNameMapper mapper = null;
    protected File destDir = null;
    private int maxParallel = -1;
    private boolean addSourceFile = true;
    private boolean verbose = false;
    private boolean ignoreMissing = true;
    protected boolean srcIsFirst = true;

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addDirset(DirSet dirSet) {
        this.filesets.addElement(dirSet);
    }

    public void addFilelist(FileList fileList) {
        this.filelists.addElement(fileList);
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    public void setParallel(boolean bl) {
        this.parallel = bl;
    }

    public void setType(FileDirBoth fileDirBoth) {
        this.type = fileDirBoth.getValue();
    }

    public void setSkipEmptyFilesets(boolean bl) {
        this.skipEmpty = bl;
    }

    public void setDest(File file) {
        this.destDir = file;
    }

    public void setForwardslash(boolean bl) {
        this.forwardSlash = bl;
    }

    public void setMaxParallel(int n) {
        this.maxParallel = n;
    }

    public void setAddsourcefile(boolean bl) {
        this.addSourceFile = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setIgnoremissing(boolean bl) {
        this.ignoreMissing = bl;
    }

    public Commandline.Marker createSrcfile() {
        if (this.srcFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple " + "srcfile elements.", this.getLocation());
        }
        this.srcFilePos = this.cmdl.createMarker();
        return this.srcFilePos;
    }

    public Commandline.Marker createTargetfile() {
        if (this.targetFilePos != null) {
            throw new BuildException(this.getTaskType() + " doesn't support multiple " + "targetfile elements.", this.getLocation());
        }
        this.targetFilePos = this.cmdl.createMarker();
        this.srcIsFirst = this.srcFilePos != null;
        return this.targetFilePos;
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    protected void checkConfiguration() {
        if ("execon".equals(this.getTaskName())) {
            this.log("!! execon is deprecated. Use apply instead. !!");
        }
        super.checkConfiguration();
        if (this.filesets.size() == 0 && this.filelists.size() == 0) {
            throw new BuildException("no filesets and no filelists specified", this.getLocation());
        }
        if (this.targetFilePos != null || this.mapperElement != null || this.destDir != null) {
            if (this.mapperElement == null) {
                throw new BuildException("no mapper specified", this.getLocation());
            }
            if (this.destDir == null) {
                throw new BuildException("no dest attribute specified", this.getLocation());
            }
            this.mapper = this.mapperElement.getImplementation();
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        return this.redirectorElement == null ? super.createHandler() : new PumpStreamHandler();
    }

    protected void setupRedirector() {
        super.setupRedirector();
        this.redirector.setAppendProperties(true);
    }

    protected void runExec(Execute execute) throws BuildException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try {
            block28: {
                try {
                    Object object;
                    File file;
                    DataType dataType;
                    Vector<Object> vector = new Vector<Object>();
                    Vector<File> vector2 = new Vector<File>();
                    int n3 = 0;
                    while (n3 < this.filesets.size()) {
                        int n4;
                        Object[] objectArray;
                        String string = this.type;
                        dataType = (AbstractFileSet)this.filesets.elementAt(n3);
                        if (dataType instanceof DirSet && !"dir".equals(this.type)) {
                            this.log("Found a nested dirset but type is " + this.type + ". " + "Temporarily switching to type=\"dir\" on the" + " assumption that you really did mean" + " <dirset> not <fileset>.", 4);
                            string = "dir";
                        }
                        file = ((AbstractFileSet)dataType).getDir(this.getProject());
                        object = new ExtendedDirectoryScanner();
                        ((AbstractFileSet)dataType).setupDirectoryScanner((FileScanner)object, this.getProject());
                        ((DirectoryScanner)object).setFollowSymlinks(((AbstractFileSet)dataType).isFollowSymlinks());
                        ((DirectoryScanner)object).scan();
                        if (!"dir".equals(string)) {
                            objectArray = this.getFiles(file, (DirectoryScanner)object);
                            n4 = 0;
                            while (n4 < objectArray.length) {
                                ++n;
                                vector.addElement(objectArray[n4]);
                                vector2.addElement(file);
                                ++n4;
                            }
                        }
                        if (!"file".equals(string)) {
                            objectArray = this.getDirs(file, (DirectoryScanner)object);
                            n4 = 0;
                            while (n4 < objectArray.length) {
                                ++n2;
                                vector.addElement(objectArray[n4]);
                                vector2.addElement(file);
                                ++n4;
                            }
                        }
                        if (vector.size() == 0 && this.skipEmpty) {
                            int n5 = (!"dir".equals(string) ? ((ExtendedDirectoryScanner)object).getIncludedFilesCount() : 0) + (!"file".equals(string) ? ((ExtendedDirectoryScanner)object).getIncludedDirsCount() : 0);
                            this.log("Skipping fileset for directory " + file + ". It is " + (n5 > 0 ? "up to date." : "empty."), 2);
                        } else if (!this.parallel) {
                            objectArray = new String[vector.size()];
                            vector.copyInto(objectArray);
                            n4 = 0;
                            while (n4 < objectArray.length) {
                                String[] stringArray = this.getCommandline((String)objectArray[n4], file);
                                this.log(Commandline.describeCommand(stringArray), 3);
                                execute.setCommandline(stringArray);
                                if (this.redirectorElement != null) {
                                    this.setupRedirector();
                                    this.redirectorElement.configure(this.redirector, (String)objectArray[n4]);
                                }
                                if (this.redirectorElement != null || bl) {
                                    execute.setStreamHandler(this.redirector.createHandler());
                                }
                                this.runExecute(execute);
                                bl = true;
                                ++n4;
                            }
                            vector.removeAllElements();
                            vector2.removeAllElements();
                        }
                        ++n3;
                    }
                    int n6 = 0;
                    while (n6 < this.filelists.size()) {
                        dataType = (FileList)this.filelists.elementAt(n6);
                        file = ((FileList)dataType).getDir(this.getProject());
                        object = this.getFilesAndDirs((FileList)dataType);
                        int n7 = 0;
                        while (n7 < ((String[])object).length) {
                            File file2 = new File(file, (String)object[n7]);
                            if (!this.ignoreMissing || file2.isFile() && !"dir".equals(this.type) || file2.isDirectory() && !"file".equals(this.type)) {
                                if (this.ignoreMissing || file2.isFile()) {
                                    ++n;
                                } else {
                                    ++n2;
                                }
                                vector.addElement(object[n7]);
                                vector2.addElement(file);
                            }
                            ++n7;
                        }
                        if (vector.size() == 0 && this.skipEmpty) {
                            ExtendedDirectoryScanner extendedDirectoryScanner = new ExtendedDirectoryScanner();
                            extendedDirectoryScanner.setBasedir(file);
                            extendedDirectoryScanner.setIncludes(((FileList)dataType).getFiles(this.getProject()));
                            extendedDirectoryScanner.scan();
                            int n8 = extendedDirectoryScanner.getIncludedFilesCount() + extendedDirectoryScanner.getIncludedDirsCount();
                            this.log("Skipping filelist for directory " + file + ". It is " + (n8 > 0 ? "up to date." : "empty."), 2);
                        } else if (!this.parallel) {
                            Object[] objectArray = new String[vector.size()];
                            vector.copyInto(objectArray);
                            int n9 = 0;
                            while (n9 < objectArray.length) {
                                String[] stringArray = this.getCommandline((String)objectArray[n9], file);
                                this.log(Commandline.describeCommand(stringArray), 3);
                                execute.setCommandline(stringArray);
                                if (this.redirectorElement != null) {
                                    this.setupRedirector();
                                    this.redirectorElement.configure(this.redirector, (String)objectArray[n9]);
                                }
                                if (this.redirectorElement != null || bl) {
                                    execute.setStreamHandler(this.redirector.createHandler());
                                }
                                this.runExecute(execute);
                                bl = true;
                                ++n9;
                            }
                            vector.removeAllElements();
                            vector2.removeAllElements();
                        }
                        ++n6;
                    }
                    if (this.parallel && (vector.size() > 0 || !this.skipEmpty)) {
                        this.runParallel(execute, vector, vector2);
                        bl = true;
                    }
                    if (!bl) break block28;
                    this.log("Applied " + this.cmdl.getExecutable() + " to " + n + " file" + (n != 1 ? "s" : "") + " and " + n2 + " director" + (n2 != 1 ? "ies" : "y") + ".", this.verbose ? 2 : 3);
                }
                catch (IOException iOException) {
                    throw new BuildException("Execute failed: " + iOException, iOException, this.getLocation());
                }
            }
            Object var17_26 = null;
        }
        catch (Throwable throwable) {
            Object var17_27 = null;
            this.logFlush();
            this.redirector.setAppendProperties(false);
            this.redirector.setProperties();
            throw throwable;
        }
        this.logFlush();
        this.redirector.setAppendProperties(false);
        this.redirector.setProperties();
    }

    protected String[] getCommandline(String[] stringArray, File[] fileArray) {
        int n;
        String[] stringArray2;
        Object[] objectArray;
        char c = File.separatorChar;
        Vector<String> vector = new Vector<String>();
        if (this.targetFilePos != null) {
            objectArray = new Hashtable();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray2 = this.mapper.mapFileName(stringArray[n2]);
                if (stringArray2 != null) {
                    n = 0;
                    while (n < stringArray2.length) {
                        String string = null;
                        string = !this.relative ? new File(this.destDir, stringArray2[n]).getAbsolutePath() : stringArray2[n];
                        if (this.forwardSlash && c != '/') {
                            string = string.replace(c, '/');
                        }
                        if (!objectArray.contains(string)) {
                            vector.addElement(string);
                            objectArray.put(string, string);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (!this.addSourceFile) {
            stringArray = new String[]{};
        }
        String[] stringArray3 = this.cmdl.getCommandline();
        stringArray2 = new String[stringArray3.length + stringArray.length + objectArray.length];
        n = stringArray3.length;
        if (this.srcFilePos != null) {
            n = this.srcFilePos.getPosition();
        }
        if (this.targetFilePos != null) {
            int n3 = this.targetFilePos.getPosition();
            if (n < n3 || n == n3 && this.srcIsFirst) {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, n3 - n);
                System.arraycopy(objectArray, 0, stringArray2, n3 + stringArray.length, objectArray.length);
                System.arraycopy(stringArray3, n3, stringArray2, n3 + stringArray.length + objectArray.length, stringArray3.length - n3);
            } else {
                System.arraycopy(stringArray3, 0, stringArray2, 0, n3);
                System.arraycopy(objectArray, 0, stringArray2, n3, objectArray.length);
                System.arraycopy(stringArray3, n3, stringArray2, n3 + objectArray.length, n - n3);
                System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length + objectArray.length, stringArray3.length - n);
                n += objectArray.length;
            }
        } else {
            System.arraycopy(stringArray3, 0, stringArray2, 0, n);
            System.arraycopy(stringArray3, n, stringArray2, n + stringArray.length, stringArray3.length - n);
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringArray2[n + n4] = !this.relative ? new File(fileArray[n4], stringArray[n4]).getAbsolutePath() : stringArray[n4];
            if (this.forwardSlash && c != '/') {
                stringArray2[n + n4] = stringArray2[n + n4].replace(c, '/');
            }
            ++n4;
        }
        return stringArray2;
    }

    protected String[] getCommandline(String string, File file) {
        return this.getCommandline(new String[]{string}, new File[]{file});
    }

    protected String[] getFiles(File file, DirectoryScanner directoryScanner) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(directoryScanner.getIncludedFiles(), file, this.destDir, this.mapper);
        }
        return directoryScanner.getIncludedFiles();
    }

    protected String[] getDirs(File file, DirectoryScanner directoryScanner) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(directoryScanner.getIncludedDirectories(), file, this.destDir, this.mapper);
        }
        return directoryScanner.getIncludedDirectories();
    }

    protected String[] getFilesAndDirs(FileList fileList) {
        if (this.mapper != null) {
            SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
            return sourceFileScanner.restrict(fileList.getFiles(this.getProject()), fileList.getDir(this.getProject()), this.destDir, this.mapper);
        }
        return fileList.getFiles(this.getProject());
    }

    protected void runParallel(Execute execute, Vector vector, Vector vector2) throws IOException, BuildException {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new File[vector2.size()];
        vector2.copyInto(objectArray2);
        if (this.maxParallel <= 0 || objectArray.length == 0) {
            String[] stringArray = this.getCommandline((String[])objectArray, (File[])objectArray2);
            this.log(Commandline.describeCommand(stringArray), 3);
            execute.setCommandline(stringArray);
            this.runExecute(execute);
        } else {
            int n = vector.size();
            int n2 = 0;
            while (n > 0) {
                int n3 = Math.min(n, this.maxParallel);
                String[] stringArray = new String[n3];
                System.arraycopy(objectArray, n2, stringArray, 0, n3);
                File[] fileArray = new File[n3];
                System.arraycopy(objectArray2, n2, fileArray, 0, n3);
                String[] stringArray2 = this.getCommandline(stringArray, fileArray);
                this.log(Commandline.describeCommand(stringArray2), 3);
                execute.setCommandline(stringArray2);
                if (this.redirectorElement != null) {
                    this.setupRedirector();
                    this.redirectorElement.configure(this.redirector, null);
                }
                if (this.redirectorElement != null || n2 > 0) {
                    execute.setStreamHandler(this.redirector.createHandler());
                }
                this.runExecute(execute);
                n -= n3;
                n2 += n3;
            }
        }
    }

    private class ExtendedDirectoryScanner
    extends DirectoryScanner {
        private ExtendedDirectoryScanner() {
        }

        public int getIncludedFilesCount() {
            if (this.filesIncluded == null) {
                throw new IllegalStateException();
            }
            return this.filesIncluded.size();
        }

        public int getIncludedDirsCount() {
            if (this.dirsIncluded == null) {
                throw new IllegalStateException();
            }
            return this.dirsIncluded.size();
        }
    }

    public static class FileDirBoth
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"file", "dir", "both"};
        }
    }
}

