/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Expand
extends Task {
    private File dest;
    private File source;
    private boolean overwrite = true;
    private Vector patternsets = new Vector();
    private Vector filesets = new Vector();
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";

    public void execute() throws BuildException {
        if ("expand".equals(this.getTaskType())) {
            this.log("!! expand is deprecated. Use unzip instead. !!");
        }
        if (this.source == null && this.filesets.size() == 0) {
            throw new BuildException("src attribute and/or filesets must be specified");
        }
        if (this.dest == null) {
            throw new BuildException("Dest attribute must be specified");
        }
        if (this.dest.exists() && !this.dest.isDirectory()) {
            throw new BuildException("Dest must be a directory.", this.getLocation());
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        if (this.source != null) {
            if (this.source.isDirectory()) {
                throw new BuildException("Src must not be a directory. Use nested filesets instead.", this.getLocation());
            }
            this.expandFile(fileUtils, this.source, this.dest);
        }
        if (this.filesets.size() > 0) {
            int n = 0;
            while (n < this.filesets.size()) {
                FileSet fileSet = (FileSet)this.filesets.elementAt(n);
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                File file = fileSet.getDir(this.getProject());
                String[] stringArray = directoryScanner.getIncludedFiles();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    File file2 = new File(file, stringArray[n2]);
                    this.expandFile(fileUtils, file2, this.dest);
                    ++n2;
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandFile(FileUtils fileUtils, File file, File file2) {
        this.log("Expanding: " + file + " into " + file2, 2);
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file, this.encoding);
                Enumeration enumeration = zipFile.getEntries();
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        this.log("expand complete", 3);
                        break;
                    }
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    this.extractFile(fileUtils, file, file2, zipFile.getInputStream(zipEntry), zipEntry.getName(), new Date(zipEntry.getTime()), zipEntry.isDirectory());
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Error while expanding " + file.getPath(), iOException);
            }
            Object var8_8 = null;
            if (zipFile == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        zipFile.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(FileUtils fileUtils, File file, File file2, InputStream inputStream, String string, Date date, boolean bl) throws IOException {
        Object object;
        Object object2;
        if (this.patternsets != null && this.patternsets.size() > 0) {
            object2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            boolean bl2 = false;
            int n = 0;
            while (n < this.patternsets.size()) {
                Object object3;
                PatternSet patternSet = (PatternSet)this.patternsets.elementAt(n);
                object = patternSet.getIncludePatterns(this.getProject());
                if (object == null || ((String[])object).length == 0) {
                    object = new String[]{"**"};
                }
                int n2 = 0;
                while (n2 < ((String[])object).length) {
                    object3 = object[n2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    if (((String)object3).endsWith(File.separator)) {
                        object3 = (String)object3 + "**";
                    }
                    if (bl2 = SelectorUtils.matchPath((String)object3, (String)object2)) break;
                    ++n2;
                }
                if (!bl2) break;
                object3 = patternSet.getExcludePatterns(this.getProject());
                if (object3 != null) {
                    int n3 = 0;
                    while (n3 < ((Object)object3).length) {
                        String string2 = ((String)object3[n3]).replace('/', File.separatorChar).replace('\\', File.separatorChar);
                        if (string2.endsWith(File.separator)) {
                            string2 = string2 + "**";
                        }
                        boolean bl3 = bl2 = !SelectorUtils.matchPath(string2, (String)object2);
                        if (!bl2) break;
                        ++n3;
                    }
                }
                ++n;
            }
            if (!bl2) {
                return;
            }
        }
        object2 = fileUtils.resolveFile(file2, string);
        try {
            block22: {
                if (!this.overwrite && ((File)object2).exists() && ((File)object2).lastModified() >= date.getTime()) {
                    this.log("Skipping " + object2 + " as it is up-to-date", 4);
                    return;
                }
                this.log("expanding " + string + " to " + object2, 3);
                File file3 = fileUtils.getParentFile((File)object2);
                if (file3 != null) {
                    file3.mkdirs();
                }
                if (bl) {
                    ((File)object2).mkdirs();
                } else {
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    object = null;
                    try {
                        object = new FileOutputStream((File)object2);
                        while (true) {
                            if ((n = inputStream.read(byArray)) < 0) {
                                ((FileOutputStream)object).close();
                                object = null;
                                Object var18_21 = null;
                                if (object == null) break block22;
                                break;
                            }
                            ((FileOutputStream)object).write(byArray, 0, n);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        if (object == null) throw throwable;
                        try {
                            ((FileOutputStream)object).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    ((FileOutputStream)object).close();
                }
            }
            fileUtils.setFileLastModified((File)object2, date.getTime());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("Unable to expand to file " + ((File)object2).getPath(), 1);
            return;
        }
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setSrc(File file) {
        this.source = file;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public void addPatternset(PatternSet patternSet) {
        this.patternsets.addElement(patternSet);
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void setEncoding(String string) {
        if (NATIVE_ENCODING.equals(string)) {
            string = null;
        }
        this.encoding = string;
    }
}

