/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class FixCRLF
extends MatchingTask {
    private static final int UNDEF = -1;
    private static final int NOTJAVA = 0;
    private static final int LOOKING = 1;
    private static final int IN_CHAR_CONST = 2;
    private static final int IN_STR_CONST = 3;
    private static final int IN_SINGLE_COMMENT = 4;
    private static final int IN_MULTI_COMMENT = 5;
    private static final int ASIS = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CRLF = 3;
    private static final int ADD = 1;
    private static final int REMOVE = -1;
    private static final int SPACES = -1;
    private static final int TABS = 1;
    private static final int INBUFLEN = 8192;
    private static final int LINEBUFLEN = 200;
    private static final char CTRLZ = '\u001a';
    private int tablength = 8;
    private String spaces = "        ";
    private StringBuffer linebuf = new StringBuffer(1024);
    private StringBuffer linebuf2 = new StringBuffer(1024);
    private int eol;
    private String eolstr;
    private int ctrlz;
    private int tabs = 0;
    private boolean javafiles = false;
    private boolean fixlast = true;
    private File srcDir;
    private File destDir = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private String encoding = null;

    public FixCRLF() {
        if (Os.isFamily("mac")) {
            this.ctrlz = -1;
            this.eol = 1;
            this.eolstr = "\r";
        } else if (Os.isFamily("dos")) {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        } else {
            this.ctrlz = -1;
            this.eol = 2;
            this.eolstr = "\n";
        }
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setJavafiles(boolean bl) {
        this.javafiles = bl;
    }

    public void setEol(CrLf crLf) {
        String string = crLf.getValue();
        if (string.equals("asis")) {
            this.eol = 0;
        } else if (string.equals("cr") || string.equals("mac")) {
            this.eol = 1;
            this.eolstr = "\r";
        } else if (string.equals("lf") || string.equals("unix")) {
            this.eol = 2;
            this.eolstr = "\n";
        } else {
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setCr(AddAsisRemove addAsisRemove) {
        this.log("DEPRECATED: The cr attribute has been deprecated,", 1);
        this.log("Please use the eol attribute instead", 1);
        String string = addAsisRemove.getValue();
        CrLf crLf = new CrLf();
        if (string.equals("remove")) {
            crLf.setValue("lf");
        } else if (string.equals("asis")) {
            crLf.setValue("asis");
        } else {
            crLf.setValue("crlf");
        }
        this.setEol(crLf);
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.tabs = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTablength(int n) throws BuildException {
        if (n < 2 || n > 80) {
            throw new BuildException("tablength must be between 2 and 80", this.getLocation());
        }
        this.tablength = n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.tablength) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.spaces = stringBuffer.toString();
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.ctrlz = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setFixlast(boolean bl) {
        this.fixlast = bl;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: eol=" + (this.eol == 0 ? "asis" : (this.eol == 1 ? "cr" : (this.eol == 2 ? "lf" : "crlf"))) + " tab=" + (this.tabs == 1 ? "add" : (this.tabs == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength + " encoding=" + (this.encoding == null ? "default" : this.encoding), 3);
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            this.processFile(stringArray[n]);
            ++n;
        }
    }

    private Reader getReader(File file) throws IOException {
        return this.encoding == null ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
    }

    /*
     * Unable to fully structure code
     */
    private void processFile(String var1_1) throws BuildException {
        var2_2 = new File(this.srcDir, var1_1);
        var3_3 = this.destDir == null ? this.srcDir : this.destDir;
        var4_4 = null;
        var7_5 = new OneLiner(var2_2);
        try {
            block48: {
                try {
                    var4_4 = this.fileUtils.createTempFile("fixcrlf", "", null);
                    var4_4.deleteOnExit();
                    var8_6 = this.encoding == null ? new FileWriter(var4_4) : new OutputStreamWriter((OutputStream)new FileOutputStream(var4_4), this.encoding);
                    var5_13 = new BufferedWriter((Writer)var8_6);
                    if (true) ** GOTO lbl73
                }
                catch (IOException var8_7) {
                    throw new BuildException(var8_7);
                }
                do {
                    try {
                        var6_14 = (OneLiner.BufferLine)var7_5.nextElement();
                    }
                    catch (NoSuchElementException var9_16) {
                        throw new BuildException(var9_16);
                    }
                    var9_15 = var6_14.getLineString();
                    var10_18 = var6_14.length();
                    if (this.tabs != 0) ** GOTO lbl66
                    try {
                        var5_13.write(var9_15);
                    }
                    catch (IOException var11_20) {
                        throw new BuildException(var11_20);
                    }
lbl-1000:
                    // 1 sources

                    {
                        switch (var7_5.getState()) {
                            case 0: {
                                this.notInConstant(var6_14, var6_14.length(), var5_13);
                                break;
                            }
                            case 5: {
                                var8_8 = var9_15.indexOf("*/", var6_14.getNext());
                                if (var8_8 >= 0) {
                                    var8_8 += 2;
                                    var7_5.setState(1);
                                } else {
                                    var8_8 = var10_18;
                                }
                                this.notInConstant(var6_14, var8_8, var5_13);
                                break;
                            }
                            case 4: {
                                this.notInConstant(var6_14, var6_14.length(), var5_13);
                                var7_5.setState(1);
                                break;
                            }
                            case 2: 
                            case 3: {
                                var11_19 = var6_14.getNext();
                                var12_22 = var7_5.getState() == 3 ? '\"' : '\'';
                                this.endOfCharConst(var6_14, var12_22);
                                while (var6_14.getNext() < var6_14.getLookahead()) {
                                    if (var6_14.getNextCharInc() == '\t') {
                                        var6_14.setColumn(var6_14.getColumn() + this.tablength - var6_14.getColumn() % this.tablength);
                                        continue;
                                    }
                                    var6_14.incColumn();
                                }
                                try {
                                    var5_13.write(var6_14.substring(var11_19, var6_14.getNext()));
                                }
                                catch (IOException var13_23) {
                                    throw new BuildException(var13_23);
                                }
                                var7_5.setState(1);
                                break;
                            }
                            case 1: {
                                this.nextStateChange(var6_14);
                                this.notInConstant(var6_14, var6_14.getLookahead(), var5_13);
                            }
                        }
lbl66:
                        // 7 sources

                        ** while (var6_14.getNext() < var10_18)
                    }
lbl67:
                    // 2 sources

                    if ("".equals(var6_14.getEol()) && !this.fixlast) continue;
                    try {
                        var5_13.write(this.eolstr);
                    }
                    catch (IOException var11_21) {
                        throw new BuildException(var11_21);
                    }
lbl73:
                    // 3 sources

                } while (var7_5.hasMoreElements());
                if (this.ctrlz == 0) {
                    var5_13.write(var7_5.getEofStr());
                    break block48;
                }
                if (this.ctrlz != 1) break block48;
                var5_13.write(26);
            }
            var15_24 = null;
            try {
                var5_13.close();
            }
            catch (IOException var16_26) {
                throw new BuildException(var16_26);
            }
            {
                catch (IOException var8_9) {
                    throw new BuildException(var8_9);
                }
            }
            catch (Throwable var14_28) {
                var15_25 = null;
                try {
                    var5_13.close();
                }
                catch (IOException var16_27) {
                    throw new BuildException(var16_27);
                }
                throw var14_28;
            }
            try {
                var7_5.close();
                var7_5 = null;
            }
            catch (IOException var8_10) {
                throw new BuildException("Unable to close source file " + var2_2);
            }
            var8_6 = new File(var3_3, var1_1);
            var9_17 = true;
            if (var8_6.exists()) {
                this.log("destFile exists", 4);
                if (!this.fileUtils.contentEquals((File)var8_6, var4_4)) {
                    this.log(var8_6 + " is being written", 4);
                } else {
                    this.log(var8_6 + " is not written, as the contents " + "are identical", 4);
                    var9_17 = false;
                }
            }
            if (var9_17) {
                this.fileUtils.rename(var4_4, (File)var8_6);
                var4_4 = null;
            }
        }
        catch (IOException var8_12) {
            throw new BuildException(var8_12);
        }
        finally {
            try {
                if (var7_5 != null) {
                    var7_5.close();
                }
            }
            catch (IOException var18_30) {
                this.log("Error closing " + var2_2, 0);
            }
            if (var4_4 != null) {
                var4_4.delete();
            }
        }
    }

    private void nextStateChange(OneLiner.BufferLine bufferLine) throws BuildException {
        int n = bufferLine.length();
        int n2 = bufferLine.getNext();
        while (n2 < n) {
            switch (bufferLine.getChar(n2++)) {
                case '\'': {
                    bufferLine.setState(2);
                    bufferLine.setLookahead(--n2);
                    return;
                }
                case '\"': {
                    bufferLine.setState(3);
                    bufferLine.setLookahead(--n2);
                    return;
                }
                case '/': {
                    if (n2 >= n) break;
                    if (bufferLine.getChar(n2) == '*') {
                        bufferLine.setState(5);
                        bufferLine.setLookahead(--n2);
                        return;
                    }
                    if (bufferLine.getChar(n2) != '/') break;
                    bufferLine.setState(4);
                    bufferLine.setLookahead(--n2);
                    return;
                }
            }
        }
        bufferLine.setLookahead(n2);
    }

    private void endOfCharConst(OneLiner.BufferLine bufferLine, char c) throws BuildException {
        int n = bufferLine.getNext();
        int n2 = bufferLine.length();
        ++n;
        while (n < n2) {
            char c2;
            if ((c2 = bufferLine.getChar(n++)) == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            bufferLine.setLookahead(n);
            return;
        }
        throw new BuildException("endOfCharConst: unterminated char constant");
    }

    private void notInConstant(OneLiner.BufferLine bufferLine, int n, BufferedWriter bufferedWriter) {
        int n2;
        String string = bufferLine.substring(bufferLine.getNext(), n);
        int n3 = 0;
        int n4 = bufferLine.getColumn();
        this.linebuf = new StringBuffer();
        while ((n2 = string.indexOf(9, n3)) >= 0) {
            this.linebuf.append(string.substring(n3, n2));
            int n5 = this.tablength - (n4 += n2 - n3) % this.tablength;
            this.linebuf.append(this.spaces.substring(0, n5));
            n4 += n5;
            n3 = n2 + 1;
        }
        this.linebuf.append(string.substring(n3, string.length()));
        String string2 = new String(this.linebuf.substring(0));
        if (this.tabs == -1) {
            try {
                bufferedWriter.write(string2);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        }
        this.linebuf2 = new StringBuffer();
        n3 = 0;
        n4 = bufferLine.getColumn();
        int n6 = n4 - 0;
        int n7 = n4 + (this.tablength - n4 % this.tablength);
        if (n7 - n4 < 2) {
            this.linebuf2.append(string2.substring(n3, n7 - n6));
            n3 = n7 - n6;
            n7 += this.tablength;
        }
        while (n7 - n6 <= string2.length()) {
            int n8 = n7;
            while (--n8 - n6 >= n3 && string2.charAt(n8 - n6) == ' ') {
            }
            if (n7 - n8 > 2) {
                this.linebuf2.append(string2.substring(n3, ++n8 - n6));
                this.linebuf2.append('\t');
            } else {
                this.linebuf2.append(string2.substring(n3, n7 - n6));
            }
            n3 = n7 - n6;
            n7 += this.tablength;
        }
        this.linebuf2.append(string2.substring(n3, string2.length()));
        try {
            bufferedWriter.write(this.linebuf2.substring(0));
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
        bufferLine.setColumn(bufferLine.getColumn() + string2.length());
        bufferLine.setNext(n);
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }

    public static class CrLf
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"asis", "cr", "lf", "crlf", "mac", "unix", "dos"};
        }
    }

    class OneLiner
    implements Enumeration {
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private StringBuffer line;
        private boolean reachedEof;
        private File srcFile;

        public OneLiner(File file) throws BuildException {
            this.state = FixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.line = new StringBuffer();
            this.reachedEof = false;
            this.srcFile = file;
            try {
                this.reader = new BufferedReader(FixCRLF.this.getReader(file), 8192);
                this.nextLine();
            }
            catch (IOException iOException) {
                throw new BuildException(file + ": " + iOException.getMessage(), iOException, FixCRLF.this.getLocation());
            }
        }

        protected void nextLine() throws BuildException {
            int n = -1;
            int n2 = 0;
            this.eolStr = new StringBuffer();
            this.line = new StringBuffer();
            try {
                n = this.reader.read();
                while (n != -1 && n != 13 && n != 10) {
                    this.line.append((char)n);
                    n = this.reader.read();
                }
                if (n == -1 && this.line.length() == 0) {
                    this.reachedEof = true;
                    return;
                }
                block1 : switch ((char)n) {
                    case '\r': {
                        ++n2;
                        this.eolStr.append('\r');
                        this.reader.mark(2);
                        n = this.reader.read();
                        switch (n) {
                            case 13: {
                                n = this.reader.read();
                                if ((char)n == '\n') {
                                    n2 += 2;
                                    this.eolStr.append("\r\n");
                                    break block1;
                                }
                                this.reader.reset();
                                break block1;
                            }
                            case 10: {
                                ++n2;
                                this.eolStr.append('\n');
                                break block1;
                            }
                            case -1: {
                                break block1;
                            }
                        }
                        this.reader.reset();
                        break;
                    }
                    case '\n': {
                        ++n2;
                        this.eolStr.append('\n');
                    }
                }
                if (n2 == 0) {
                    int n3 = this.line.length();
                    while (--n3 >= 0 && this.line.charAt(n3) == '\u001a') {
                    }
                    if (n3 < this.line.length() - 1) {
                        this.eofStr.append(this.line.toString().substring(n3 + 1));
                        if (n3 < 0) {
                            this.line.setLength(0);
                            this.reachedEof = true;
                        } else {
                            this.line.setLength(n3 + 1);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException(this.srcFile + ": " + iOException.getMessage(), iOException, FixCRLF.this.getLocation());
            }
        }

        public String getEofStr() {
            return this.eofStr.substring(0);
        }

        public int getState() {
            return this.state;
        }

        public void setState(int n) {
            this.state = n;
        }

        public boolean hasMoreElements() {
            return !this.reachedEof;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine bufferLine = new BufferLine(this.line.toString(), this.eolStr.substring(0));
            this.nextLine();
            return bufferLine;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        class BufferLine {
            private int next = 0;
            private int column = 0;
            private int lookahead = -1;
            private String line;
            private String eolStr;

            public BufferLine(String string, String string2) throws BuildException {
                this.line = string;
                this.eolStr = string2;
            }

            public int getNext() {
                return this.next;
            }

            public void setNext(int n) {
                this.next = n;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public void setLookahead(int n) {
                this.lookahead = n;
            }

            public char getChar(int n) {
                return this.line.charAt(n);
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getColumn() {
                return this.column;
            }

            public void setColumn(int n) {
                this.column = n;
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public String getEol() {
                return this.eolStr;
            }

            public String substring(int n) {
                return this.line.substring(n);
            }

            public String substring(int n, int n2) {
                return this.line.substring(n, n2);
            }

            public void setState(int n) {
                OneLiner.this.setState(n);
            }

            public int getState() {
                return OneLiner.this.getState();
            }
        }
    }
}

