/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;

public class GUnzip
extends Unpack {
    private static final String DEFAULT_EXTENSION = ".gz";

    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream fileOutputStream = null;
            GZIPInputStream gZIPInputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.dest);
                fileInputStream = new FileInputStream(this.source);
                gZIPInputStream = new GZIPInputStream(fileInputStream);
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    fileOutputStream.write(byArray, 0, n);
                } while ((n = gZIPInputStream.read(byArray, 0, byArray.length)) != -1);
            }
            catch (IOException iOException) {
                String string = "Problem expanding gzip " + iOException.getMessage();
                throw new BuildException(string, iOException, this.getLocation());
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (gZIPInputStream != null) {
                    try {
                        gZIPInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

