/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Get
extends Task {
    private URL source;
    private File dest;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private boolean ignoreErrors = false;
    private String uname = null;
    private String pword = null;
    static /* synthetic */ Class array$B;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.source == null) {
            throw new BuildException("src attribute is required", this.getLocation());
        }
        if (this.dest == null) {
            throw new BuildException("dest attribute is required", this.getLocation());
        }
        if (this.dest.exists() && this.dest.isDirectory()) {
            throw new BuildException("The specified destination is a directory", this.getLocation());
        }
        if (this.dest.exists() && !this.dest.canWrite()) {
            throw new BuildException("Can't write to " + this.dest.getAbsolutePath(), this.getLocation());
        }
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            this.log("Getting: " + this.source);
            long l = 0L;
            boolean bl = false;
            if (this.useTimestamp && this.dest.exists()) {
                l = this.dest.lastModified();
                if (this.verbose) {
                    object3 = new Date(l);
                    this.log("local file date : " + ((Date)object3).toString());
                }
                bl = true;
            }
            object3 = this.source.openConnection();
            if (this.useTimestamp && bl) {
                ((URLConnection)object3).setIfModifiedSince(l);
            }
            if (this.uname != null || this.pword != null) {
                object2 = this.uname + ":" + this.pword;
                try {
                    object = Class.forName("sun.misc.BASE64Encoder").newInstance();
                    string = (String)object.getClass().getMethod("encode", array$B == null ? (array$B = Get.class$("[B")) : array$B).invoke(object, new Object[]{((String)object2).getBytes()});
                }
                catch (Exception exception) {
                    Base64Converter base64Converter = new Base64Converter();
                    string = base64Converter.encode(((String)object2).getBytes());
                }
                ((URLConnection)object3).setRequestProperty("Authorization", "Basic " + string);
            }
            ((URLConnection)object3).connect();
            if (object3 instanceof HttpURLConnection) {
                object2 = (HttpURLConnection)object3;
                if (((HttpURLConnection)object2).getResponseCode() == 304) {
                    this.log("Not modified - so not downloaded");
                    return;
                }
                if (((HttpURLConnection)object2).getResponseCode() == 401) {
                    string = "HTTP Authorization failure";
                    if (this.ignoreErrors) {
                        this.log(string, 1);
                        return;
                    }
                    throw new BuildException(string);
                }
            }
            object2 = null;
            int n = 0;
            while (n < 3) {
                try {
                    object2 = ((URLConnection)object3).getInputStream();
                    break;
                }
                catch (IOException iOException) {
                    this.log("Error opening connection " + iOException);
                    ++n;
                }
            }
            if (object2 == null) {
                this.log("Can't get " + this.source + " to " + this.dest);
                if (this.ignoreErrors) {
                    return;
                }
                throw new BuildException("Can't get " + this.source + " to " + this.dest, this.getLocation());
            }
            object = new FileOutputStream(this.dest);
            boolean bl2 = false;
            try {
                int n2;
                byte[] byArray = new byte[102400];
                int n3 = 0;
                while ((n2 = ((InputStream)object2).read(byArray)) >= 0) {
                    ((FileOutputStream)object).write(byArray, 0, n2);
                    if (!this.verbose) continue;
                    System.out.print(".");
                    if (n3++ <= 50) continue;
                    System.out.flush();
                    n3 = 0;
                }
                if (this.verbose) {
                    System.out.println();
                }
                bl2 = true;
            }
            finally {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
                ((InputStream)object2).close();
                if (!bl2) {
                    this.dest.delete();
                }
            }
            if (this.useTimestamp) {
                long l2 = ((URLConnection)object3).getLastModified();
                if (this.verbose) {
                    Date date = new Date(l2);
                    this.log("last modified = " + date.toString() + (l2 == 0L ? " - using current time instead" : ""));
                }
                if (l2 != 0L) {
                    FileUtils.newFileUtils().setFileLastModified(this.dest, l2);
                }
            }
        }
        catch (IOException iOException) {
            this.log("Error getting " + this.source + " to " + this.dest);
            if (this.ignoreErrors) {
                return;
            }
            throw new BuildException(iOException, this.getLocation());
        }
    }

    public void setSrc(URL uRL) {
        this.source = uRL;
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setIgnoreErrors(boolean bl) {
        this.ignoreErrors = bl;
    }

    public void setUseTimestamp(boolean bl) {
        if (!JavaEnvUtils.isJavaVersion("1.1")) {
            this.useTimestamp = bl;
        }
    }

    public void setUsername(String string) {
        this.uname = string;
    }

    public void setPassword(String string) {
        this.pword = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Base64Converter {
        public final char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        private Base64Converter() {
        }

        public String encode(String string) {
            return this.encode(string.getBytes());
        }

        public String encode(byte[] byArray) {
            int n;
            int n2;
            char[] cArray = new char[((byArray.length - 1) / 3 + 1) * 4];
            int n3 = 0;
            int n4 = 0;
            while (n4 + 3 <= byArray.length) {
                n2 = (byArray[n4++] & 0xFF) << 16;
                n = ((n2 |= (byArray[n4++] & 0xFF) << 8) & 0xFC0000) >> 18;
                cArray[n3++] = this.alphabet[n];
                n = (n2 & 0x3F000) >> 12;
                cArray[n3++] = this.alphabet[n];
                n = (n2 & 0xFC0) >> 6;
                cArray[n3++] = this.alphabet[n];
                n = n2 & 0x3F;
                cArray[n3++] = this.alphabet[n];
            }
            if (byArray.length - n4 == 2) {
                n2 = (byArray[n4] & 0xFF) << 16;
                n = ((n2 |= (byArray[n4 + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
                cArray[n3++] = this.alphabet[n];
                n = (n2 & 0x3F000) >> 12;
                cArray[n3++] = this.alphabet[n];
                n = (n2 & 0xFC0) >> 6;
                cArray[n3++] = this.alphabet[n];
                cArray[n3++] = 61;
            } else if (byArray.length - n4 == 1) {
                n2 = (byArray[n4] & 0xFF) << 16;
                n = (n2 & 0xFC0000) >> 18;
                cArray[n3++] = this.alphabet[n];
                n = (n2 & 0x3F000) >> 12;
                cArray[n3++] = this.alphabet[n];
                cArray[n3++] = 61;
                cArray[n3++] = 61;
            }
            return new String(cArray);
        }
    }
}

