/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;

public class ImportTask
extends Task {
    private String file;
    private boolean optional;
    private static final FileUtils FILE_UTILS = FileUtils.newFileUtils();

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public void execute() {
        if (this.file == null) {
            throw new BuildException("import requires file attribute");
        }
        if (this.getOwningTarget() == null || !"".equals(this.getOwningTarget().getName())) {
            throw new BuildException("import only allowed as a top-level task");
        }
        ProjectHelper projectHelper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        Vector vector = projectHelper.getImportStack();
        if (vector.size() == 0) {
            throw new BuildException("import requires support in ProjectHelper");
        }
        if (this.getLocation() == null || this.getLocation().getFileName() == null) {
            throw new BuildException("Unable to get location of import task");
        }
        File file = new File(this.getLocation().getFileName());
        file = new File(file.getAbsolutePath());
        this.getProject().log("Importing file " + this.file + " from " + file.getAbsolutePath(), 3);
        File file2 = new File(file.getParent());
        File file3 = FILE_UTILS.resolveFile(file2, this.file);
        if (!file3.exists()) {
            String string = "Cannot find " + this.file + " imported from " + file.getAbsolutePath();
            if (this.optional) {
                this.getProject().log(string, 3);
                return;
            }
            throw new BuildException(string);
        }
        if (vector.contains(file3)) {
            this.getProject().log("Skipped already imported file:\n   " + file3 + "\n", 3);
            return;
        }
        try {
            projectHelper.parse(this.getProject(), file3);
        }
        catch (BuildException buildException) {
            throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
        }
    }
}

