/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector rootEntries;
    private Path indexJars;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void setWhenempty(Zip.WhenEmpty whenEmpty) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setJarfile(File file) {
        this.setDestFile(file);
    }

    public void setIndex(boolean bl) {
        this.index = bl;
    }

    public void setManifestEncoding(String string) {
        this.manifestEncoding = string;
    }

    public void addConfiguredManifest(Manifest manifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = manifest;
        } else {
            this.configuredManifest.merge(manifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File file) {
        if (!file.exists()) {
            throw new BuildException("Manifest file: " + file + " does not exist.", this.getLocation());
        }
        this.manifestFile = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File file) {
        Manifest manifest = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                inputStreamReader = this.manifestEncoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, this.manifestEncoding);
                manifest = this.getManifest(inputStreamReader);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException("Unsupported encoding while reading manifest: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new BuildException("Unable to read manifest file: " + file + " (" + iOException.getMessage() + ")", iOException);
            }
            Object var8_5 = null;
            if (inputStreamReader == null) return manifest;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        inputStreamReader.close();
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifestFromJar(File var1_1) throws IOException {
        block7: {
            var2_2 = null;
            try {
                var2_2 = new java.util.zip.ZipFile(var1_1);
                var3_3 = var2_2.entries();
                do {
                    if (var3_3.hasMoreElements()) continue;
                    var4_4 = null;
                    break block7;
                } while (!(var4_4 = var3_3.nextElement()).getName().equalsIgnoreCase("META-INF/MANIFEST.MF"));
                var5_5 = new InputStreamReader(var2_2.getInputStream(var4_4), "UTF-8");
                var6_6 = this.getManifest(var5_5);
                var8_7 = null;
                if (var2_2 == null) return var6_6;
            }
            catch (Throwable var7_13) {
                var8_9 = null;
                if (var2_2 == null) throw var7_13;
                try {
                    var2_2.close();
                    throw var7_13;
                }
                catch (IOException var9_12) {
                    throw var7_13;
                }
            }
            ** try [egrp 1[TRYBLOCK] [3 : 106->113)] { 
lbl27:
            // 1 sources

            var2_2.close();
            return var6_6;
lbl29:
            // 1 sources

            catch (IOException var9_10) {
                // empty catch block
            }
            return var6_6;
        }
        var8_8 = null;
        if (var2_2 == null) return var4_4;
        ** try [egrp 1[TRYBLOCK] [3 : 106->113)] { 
lbl36:
        // 1 sources

        var2_2.close();
        return var4_4;
lbl38:
        // 1 sources

        catch (IOException var9_11) {
            // empty catch block
        }
        return var4_4;
    }

    private Manifest getManifest(Reader reader) {
        Manifest manifest = null;
        try {
            manifest = new Manifest(reader);
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, manifestException, this.getLocation());
        }
        catch (IOException iOException) {
            throw new BuildException("Unable to read manifest file (" + iOException.getMessage() + ")", iOException);
        }
        return manifest;
    }

    public void setFilesetmanifest(FilesetManifestConfig filesetManifestConfig) {
        this.filesetManifestConfig = filesetManifestConfig;
        this.mergeManifestsMain = "merge".equals(filesetManifestConfig.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addMetainf(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("META-INF/");
        super.addFileset(zipFileSet);
    }

    public void addConfiguredIndexJars(Path path) {
        if (this.indexJars == null) {
            this.indexJars = new Path(this.getProject());
        }
        this.indexJars.append(path);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (!this.skipWriting) {
            Manifest manifest = this.createManifest();
            this.writeManifest(zipOutputStream, manifest);
        }
    }

    private Manifest createManifest() throws BuildException {
        try {
            Manifest manifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                manifest.merge(this.originalManifest);
            }
            manifest.merge(this.filesetManifest);
            manifest.merge(this.configuredManifest);
            manifest.merge(this.manifest, !this.mergeManifestsMain);
            return manifest;
        }
        catch (ManifestException manifestException) {
            this.log("Manifest is invalid: " + manifestException.getMessage(), 0);
            throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
        }
    }

    private void writeManifest(ZipOutputStream zipOutputStream, Manifest manifest) throws IOException {
        Enumeration enumeration = manifest.getWarnings();
        while (enumeration.hasMoreElements()) {
            this.log("Manifest warning: " + (String)enumeration.nextElement(), 1);
        }
        this.zipDir(null, zipOutputStream, "META-INF/", 16877);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        manifest.write(printWriter);
        printWriter.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        super.zipFile(byteArrayInputStream, zipOutputStream, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zipOutputStream);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.index) {
            this.createIndexList(zipOutputStream);
        }
    }

    private void createIndexList(ZipOutputStream zipOutputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8"));
        printWriter.println("JarIndex-Version: 1.0");
        printWriter.println();
        printWriter.println(this.zipFile.getName());
        this.writeIndexLikeList(new ArrayList(this.addedDirs.keySet()), this.rootEntries, printWriter);
        printWriter.println();
        if (this.indexJars != null) {
            int n;
            Object object2;
            object = this.createManifest();
            Manifest.Attribute attribute = ((Manifest)object).getMainSection().getAttribute("Class-Path");
            String[] stringArray = null;
            if (attribute != null) {
                object2 = new StringTokenizer(attribute.getValue(), " ");
                stringArray = new String[((StringTokenizer)object2).countTokens()];
                n = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray[n++] = ((StringTokenizer)object2).nextToken();
                }
            }
            object2 = this.indexJars.list();
            n = 0;
            while (n < ((Object)object2).length) {
                String string = Jar.findJarName((String)object2[n], stringArray);
                if (string != null) {
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    Jar.grabFilesAndDirs((String)object2[n], arrayList, arrayList2);
                    if (arrayList.size() + arrayList2.size() > 0) {
                        printWriter.println(string);
                        this.writeIndexLikeList(arrayList, arrayList2, printWriter);
                        printWriter.println();
                    }
                }
                ++n;
            }
        }
        printWriter.flush();
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        super.zipFile((InputStream)object, zipOutputStream, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    protected void zipFile(InputStream inputStream, ZipOutputStream zipOutputStream, String string, long l, File file, int n) throws IOException {
        if (MANIFEST_NAME.equalsIgnoreCase(string)) {
            if (!this.doubleFilePass || this.doubleFilePass && this.skipWriting) {
                this.filesetManifest(file, inputStream);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(string) && this.index) {
            this.log("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.", 1);
        } else {
            if (this.index && string.indexOf("/") == -1) {
                this.rootEntries.addElement(string);
            }
            super.zipFile(inputStream, zipOutputStream, string, l, file, n);
        }
    }

    private void filesetManifest(File file, InputStream inputStream) throws IOException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            try {
                if (inputStream != null) {
                    InputStreamReader inputStreamReader = this.manifestEncoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.manifestEncoding);
                    this.manifest = this.getManifest(inputStreamReader);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException("Unsupported encoding while reading manifest: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.log("Found manifest to merge in file " + file, 3);
            try {
                Manifest manifest = null;
                if (inputStream != null) {
                    InputStreamReader inputStreamReader = this.manifestEncoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.manifestEncoding);
                    manifest = this.getManifest(inputStreamReader);
                } else {
                    manifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = manifest;
                } else {
                    this.filesetManifest.merge(manifest);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BuildException("Unsupported encoding while reading manifest: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
            catch (ManifestException manifestException) {
                this.log("Manifest in file " + file + " is invalid: " + manifestException.getMessage(), 0);
                throw new BuildException("Invalid Manifest", manifestException, this.getLocation());
            }
        }
    }

    protected Zip.ArchiveState getResourcesToAdd(FileSet[] fileSetArray, File file, boolean bl) throws BuildException {
        if (file.exists()) {
            try {
                this.originalManifest = this.getManifestFromJar(file);
                if (this.originalManifest == null) {
                    this.log("Updating jar since the current jar has no manifest", 3);
                    bl = true;
                } else {
                    Manifest manifest = this.createManifest();
                    if (!manifest.equals(this.originalManifest)) {
                        this.log("Updating jar since jar manifest has changed", 3);
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                this.log("error while reading original manifest: " + throwable.getMessage(), 1);
                bl = true;
            }
        } else {
            bl = true;
        }
        this.createEmpty = bl;
        return super.getResourcesToAdd(fileSetArray, file, bl);
    }

    protected boolean createEmptyZip(File file) throws BuildException {
        if (!this.createEmpty) {
            return true;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            this.log("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            zipOutputStream = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
            zipOutputStream.setEncoding(this.getEncoding());
            if (this.isCompress()) {
                zipOutputStream.setMethod(8);
            } else {
                zipOutputStream.setMethod(0);
            }
            this.initZipOutputStream(zipOutputStream);
            this.finalizeZipOutputStream(zipOutputStream);
        }
        catch (IOException iOException) {
            throw new BuildException("Could not create almost empty JAR archive (" + iOException.getMessage() + ")", iOException, this.getLocation());
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            this.createEmpty = false;
        }
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        if (!this.doubleFilePass || this.doubleFilePass && !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List list, List list2, PrintWriter printWriter) throws IOException {
        Collections.sort(list);
        Collections.sort(list2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((string = string.replace('\\', '/')).startsWith("./")) {
                string = string.substring(2);
            }
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (string.startsWith("META-INF")) continue;
            printWriter.println(string);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            printWriter.println(iterator.next());
        }
    }

    protected static final String findJarName(String string, String[] stringArray) {
        if (stringArray == null) {
            return new File(string).getName();
        }
        string = string.replace(File.separatorChar, '/');
        TreeMap<String, String> treeMap = new TreeMap<String, String>(new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof String && object2 instanceof String) {
                    return ((String)object2).length() - ((String)object).length();
                }
                return 0;
            }
        });
        int n = 0;
        while (n < stringArray.length) {
            if (string.endsWith(stringArray[n])) {
                treeMap.put(stringArray[n], stringArray[n]);
            } else {
                int n2 = stringArray[n].indexOf("/");
                String string2 = stringArray[n];
                while (n2 > -1) {
                    if (string.endsWith(string2 = string2.substring(n2 + 1))) {
                        treeMap.put(string2, stringArray[n]);
                        break;
                    }
                    n2 = string2.indexOf("/");
                }
            }
            ++n;
        }
        return treeMap.size() == 0 ? null : (String)treeMap.get(treeMap.firstKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final void grabFilesAndDirs(String string, List list, List list2) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string, "utf-8");
            Enumeration enumeration = zipFile.getEntries();
            HashSet<String> hashSet = new HashSet<String>();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string2 = zipEntry.getName();
                if (string2.startsWith("META-INF/")) continue;
                if (zipEntry.isDirectory()) {
                    hashSet.add(string2);
                    continue;
                }
                if (string2.indexOf("/") == -1) {
                    list2.add(string2);
                    continue;
                }
                hashSet.add(string2.substring(0, string2.lastIndexOf("/") + 1));
            }
            list.addAll(hashSet);
            Object var9_8 = null;
            if (zipFile == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

