/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class LoadProperties
extends Task {
    private File srcFile = null;
    private String resource = null;
    private Path classpath = null;
    private final Vector filterChains = new Vector();
    private String encoding = null;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$LoadProperties;

    public final void setSrcFile(File file) {
        this.srcFile = file;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public final void execute() throws BuildException {
        InputStream inputStream;
        Object object;
        if (this.srcFile == null && this.resource == null) {
            throw new BuildException("One of \"srcfile\" or \"resource\" is required.");
        }
        BufferedInputStream bufferedInputStream = null;
        if (this.srcFile != null) {
            if (!this.srcFile.exists()) {
                throw new BuildException("Source file does not exist.");
            }
            if (!this.srcFile.isFile()) {
                throw new BuildException("Source file is not a file.");
            }
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(this.srcFile));
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
        } else {
            object = this.classpath != null ? this.getProject().createClassLoader(this.classpath) : (class$org$apache$tools$ant$taskdefs$LoadProperties == null ? (class$org$apache$tools$ant$taskdefs$LoadProperties = LoadProperties.class$("org.apache.tools.ant.taskdefs.LoadProperties")) : class$org$apache$tools$ant$taskdefs$LoadProperties).getClassLoader();
            InputStream inputStream2 = inputStream = object == null ? ClassLoader.getSystemResourceAsStream(this.resource) : ((ClassLoader)object).getResourceAsStream(this.resource);
            if (inputStream != null) {
                bufferedInputStream = new BufferedInputStream(inputStream);
            } else {
                this.log("Unable to find resource " + this.resource, 1);
                return;
            }
        }
        object = null;
        inputStream = null;
        try {
            object = this.encoding == null ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, this.encoding);
            ChainReaderHelper chainReaderHelper = new ChainReaderHelper();
            chainReaderHelper.setPrimaryReader((Reader)object);
            chainReaderHelper.setFilterChains(this.filterChains);
            chainReaderHelper.setProject(this.getProject());
            object = chainReaderHelper.getAssembledReader();
            String string = chainReaderHelper.readFully((Reader)object);
            if (string != null) {
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                inputStream = this.encoding == null ? new ByteArrayInputStream(string.getBytes()) : new ByteArrayInputStream(string.getBytes(this.encoding));
                Properties properties = new Properties();
                properties.load(inputStream);
                Property property = (Property)this.getProject().createTask("property");
                property.setTaskName(this.getTaskName());
                property.addProperties(properties);
            }
        }
        catch (IOException iOException) {
            String string = "Unable to load file: " + iOException.toString();
            throw new BuildException(string, iOException, this.getLocation());
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    ((ByteArrayInputStream)inputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public final void addFilterChain(FilterChain filterChain) {
        this.filterChains.addElement(filterChain);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

