/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MacroDef;

public class MacroInstance
extends Task
implements DynamicAttribute,
TaskContainer {
    private MacroDef macroDef;
    private Map map = new HashMap();
    private Map nsElements = null;
    private Map presentElements = new HashMap();
    private Hashtable localProperties = new Hashtable();
    private String text = null;
    private String implicitTag = null;
    private List unknownElements = new ArrayList();
    private static final int STATE_NORMAL = 0;
    private static final int STATE_EXPECT_BRACKET = 1;
    private static final int STATE_EXPECT_NAME = 2;

    public void setMacroDef(MacroDef macroDef) {
        this.macroDef = macroDef;
    }

    public MacroDef getMacroDef() {
        return this.macroDef;
    }

    public void setDynamicAttribute(String string, String string2) {
        this.map.put(string, string2);
    }

    public Object createDynamicElement(String string) throws BuildException {
        throw new BuildException("Not implemented any more");
    }

    private Map getNsElements() {
        if (this.nsElements == null) {
            this.nsElements = new HashMap();
            Iterator iterator = this.macroDef.getElements().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.nsElements.put((String)entry.getKey(), entry.getValue());
                MacroDef.TemplateElement templateElement = (MacroDef.TemplateElement)entry.getValue();
                if (!templateElement.isImplicit()) continue;
                this.implicitTag = templateElement.getName();
            }
        }
        return this.nsElements;
    }

    public void addTask(Task task) {
        this.unknownElements.add(task);
    }

    private void processTasks() {
        if (this.implicitTag != null) {
            return;
        }
        Iterator iterator = this.unknownElements.iterator();
        while (iterator.hasNext()) {
            UnknownElement unknownElement = (UnknownElement)iterator.next();
            String string = ProjectHelper.extractNameFromComponentName(unknownElement.getTag()).toLowerCase(Locale.US);
            if (this.getNsElements().get(string) == null) {
                throw new BuildException("unsupported element " + string);
            }
            if (this.presentElements.get(string) != null) {
                throw new BuildException("Element " + string + " already present");
            }
            this.presentElements.put(string, unknownElement.getChildren());
        }
    }

    private String macroSubs(String string, Map map) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (n) {
                case 0: {
                    if (c == '@') {
                        n = 1;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    if (c == '{') {
                        n = 2;
                        stringBuffer2 = new StringBuffer();
                        break;
                    }
                    if (c == '@') {
                        n = 0;
                        stringBuffer.append('@');
                        break;
                    }
                    n = 0;
                    stringBuffer.append('@');
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    if (c == '}') {
                        n = 0;
                        String string2 = stringBuffer2.toString().toLowerCase(Locale.US);
                        String string3 = (String)map.get(string2);
                        if (string3 == null) {
                            stringBuffer.append("@{" + string2 + "}");
                        } else {
                            stringBuffer.append(string3);
                        }
                        stringBuffer2 = null;
                        break;
                    }
                    stringBuffer2.append(c);
                    break;
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append('@');
                break;
            }
            case 2: {
                stringBuffer.append("@{");
                stringBuffer.append(stringBuffer2.toString());
                break;
            }
        }
        return stringBuffer.toString();
    }

    public void addText(String string) {
        this.text = string;
    }

    private UnknownElement copy(UnknownElement unknownElement) {
        Object object;
        Object object2;
        UnknownElement unknownElement2 = new UnknownElement(unknownElement.getTag());
        unknownElement2.setNamespace(unknownElement.getNamespace());
        unknownElement2.setProject(this.getProject());
        unknownElement2.setQName(unknownElement.getQName());
        unknownElement2.setTaskType(unknownElement.getTaskType());
        unknownElement2.setTaskName(unknownElement.getTaskName());
        unknownElement2.setLocation(unknownElement.getLocation());
        if (this.getOwningTarget() == null) {
            object2 = new Target();
            ((Target)object2).setProject(this.getProject());
            unknownElement2.setOwningTarget((Target)object2);
        } else {
            unknownElement2.setOwningTarget(this.getOwningTarget());
        }
        object2 = new RuntimeConfigurable(unknownElement2, unknownElement.getTaskName());
        ((RuntimeConfigurable)object2).setPolyType(unknownElement.getWrapper().getPolyType());
        Hashtable hashtable = unknownElement.getWrapper().getAttributeMap();
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            ((RuntimeConfigurable)object2).setAttribute((String)object.getKey(), this.macroSubs((String)object.getValue(), this.localProperties));
        }
        ((RuntimeConfigurable)object2).addText(this.macroSubs(unknownElement.getWrapper().getText().toString(), this.localProperties));
        object = unknownElement.getWrapper().getChildren();
        while (object.hasMoreElements()) {
            Object object3;
            Object object4;
            MacroDef.TemplateElement templateElement;
            RuntimeConfigurable runtimeConfigurable = (RuntimeConfigurable)object.nextElement();
            UnknownElement unknownElement3 = (UnknownElement)runtimeConfigurable.getProxy();
            String string = unknownElement3.getTaskType();
            if (string != null) {
                string = string.toLowerCase(Locale.US);
            }
            if ((templateElement = (MacroDef.TemplateElement)this.getNsElements().get(string)) == null) {
                object4 = this.copy(unknownElement3);
                ((RuntimeConfigurable)object2).addChild(((UnknownElement)object4).getWrapper());
                unknownElement2.addChild((UnknownElement)object4);
                continue;
            }
            if (templateElement.isImplicit()) {
                if (this.unknownElements.size() == 0 && !templateElement.isOptional()) {
                    throw new BuildException("Missing nested elements for implicit element " + templateElement.getName());
                }
                object4 = this.unknownElements.iterator();
                while (object4.hasNext()) {
                    object3 = (UnknownElement)object4.next();
                    ((RuntimeConfigurable)object2).addChild(((UnknownElement)object3).getWrapper());
                    unknownElement2.addChild((UnknownElement)object3);
                }
                continue;
            }
            object4 = (List)this.presentElements.get(string);
            if (object4 == null) {
                if (templateElement.isOptional()) continue;
                throw new BuildException("Required nested element " + templateElement.getName() + " missing");
            }
            object3 = object4.iterator();
            while (object3.hasNext()) {
                UnknownElement unknownElement4 = (UnknownElement)object3.next();
                ((RuntimeConfigurable)object2).addChild(unknownElement4.getWrapper());
                unknownElement2.addChild(unknownElement4);
            }
        }
        return unknownElement2;
    }

    public void execute() {
        Object object;
        this.getNsElements();
        this.processTasks();
        this.localProperties = new Hashtable();
        HashSet hashSet = new HashSet(this.map.keySet());
        Iterator iterator = this.macroDef.getAttributes().iterator();
        while (iterator.hasNext()) {
            object = (MacroDef.Attribute)iterator.next();
            String string = (String)this.map.get(((MacroDef.Attribute)object).getName());
            if (string == null && "description".equals(((MacroDef.Attribute)object).getName())) {
                string = this.getDescription();
            }
            if (string == null) {
                string = ((MacroDef.Attribute)object).getDefault();
                string = this.macroSubs(string, this.localProperties);
            }
            if (string == null) {
                throw new BuildException("required attribute " + ((MacroDef.Attribute)object).getName() + " not set");
            }
            this.localProperties.put(((MacroDef.Attribute)object).getName(), string);
            hashSet.remove(((MacroDef.Attribute)object).getName());
        }
        if (hashSet.contains("id")) {
            hashSet.remove("id");
        }
        if (this.macroDef.getText() != null) {
            if (this.text == null) {
                if (!this.macroDef.getText().getOptional()) {
                    throw new BuildException("required text missing");
                }
                this.text = "";
            }
            if (this.macroDef.getText().getTrim()) {
                this.text = this.text.trim();
            }
            this.localProperties.put(this.macroDef.getText().getName(), this.text);
        } else if (this.text != null && !this.text.trim().equals("")) {
            throw new BuildException("The \"" + this.getTaskName() + "\" macro does not support" + " nested text data.");
        }
        if (hashSet.size() != 0) {
            throw new BuildException("Unknown attribute" + (hashSet.size() > 1 ? "s " : " ") + hashSet);
        }
        object = this.copy(this.macroDef.getNestedTask());
        ((Task)object).init();
        try {
            ((Task)object).perform();
        }
        catch (BuildException buildException) {
            throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
        }
    }

    public static class Element
    implements TaskContainer {
        private List unknownElements = new ArrayList();

        public void addTask(Task task) {
            this.unknownElements.add(task);
        }

        public List getUnknownElements() {
            return this.unknownElements;
        }
    }
}

