/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.util.ConcatFileInputStream;
import org.apache.tools.ant.util.KeepAliveOutputStream;
import org.apache.tools.ant.util.LazyFileOutputStream;
import org.apache.tools.ant.util.LeadPipeInputStream;
import org.apache.tools.ant.util.OutputStreamFunneler;
import org.apache.tools.ant.util.ReaderInputStream;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class Redirector {
    private static final String defaultEncoding = System.getProperty("file.encoding");
    private File[] input;
    private File[] out;
    private File[] error;
    private boolean logError = false;
    private PropertyOutputStream baos = null;
    private PropertyOutputStream errorBaos = null;
    private String outputProperty;
    private String errorProperty;
    private String inputString;
    private boolean append = false;
    private boolean createEmptyFiles = true;
    private Task managingTask;
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    private InputStream inputStream = null;
    private PrintStream outPrintStream = null;
    private PrintStream errorPrintStream = null;
    private Vector outputFilterChains;
    private Vector errorFilterChains;
    private Vector inputFilterChains;
    private String outputEncoding = defaultEncoding;
    private String errorEncoding = defaultEncoding;
    private String inputEncoding = defaultEncoding;
    private boolean appendProperties = true;
    private ThreadGroup threadGroup = new ThreadGroup("redirector");

    public Redirector(Task task) {
        this.managingTask = task;
    }

    public void setInput(File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this.setInput(fileArray);
    }

    public synchronized void setInput(File[] fileArray) {
        this.input = fileArray;
    }

    public synchronized void setInputString(String string) {
        this.inputString = string;
    }

    public void setOutput(File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this.setOutput(fileArray);
    }

    public synchronized void setOutput(File[] fileArray) {
        this.out = fileArray;
    }

    public synchronized void setOutputEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("outputEncoding must not be null");
        }
        this.outputEncoding = string;
    }

    public synchronized void setErrorEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("errorEncoding must not be null");
        }
        this.errorEncoding = string;
    }

    public synchronized void setInputEncoding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inputEncoding must not be null");
        }
        this.inputEncoding = string;
    }

    public synchronized void setLogError(boolean bl) {
        this.logError = bl;
    }

    public synchronized void setAppendProperties(boolean bl) {
        this.appendProperties = bl;
    }

    public void setError(File file) {
        File[] fileArray;
        if (file == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        this.setError(fileArray);
    }

    public synchronized void setError(File[] fileArray) {
        this.error = fileArray;
    }

    public synchronized void setOutputProperty(String string) {
        if (string == null || !string.equals(this.outputProperty)) {
            this.outputProperty = string;
            this.baos = null;
        }
    }

    public synchronized void setAppend(boolean bl) {
        this.append = bl;
    }

    public void setCreateEmptyFiles(boolean bl) {
        this.createEmptyFiles = bl;
    }

    public synchronized void setErrorProperty(String string) {
        if (string == null || !string.equals(this.errorProperty)) {
            this.errorProperty = string;
            this.errorBaos = null;
        }
    }

    public synchronized void setInputFilterChains(Vector vector) {
        this.inputFilterChains = vector;
    }

    public void setOutputFilterChains(Vector vector) {
        this.outputFilterChains = vector;
    }

    public void setErrorFilterChains(Vector vector) {
        this.errorFilterChains = vector;
    }

    private void setPropertyFromBAOS(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(Execute.toString(byteArrayOutputStream)));
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(StringUtils.LINE_SEP);
            }
            stringBuffer.append(string2);
        }
        this.managingTask.getProject().setNewProperty(string, stringBuffer.toString());
    }

    public synchronized void createStreams() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if ((this.out == null || this.out.length == 0) && this.outputProperty == null) {
            this.outputStream = new LogOutputStream(this.managingTask, 2);
        } else {
            if (this.out != null && this.out.length > 0) {
                object4 = "Output " + (this.append ? "appended" : "redirected") + " to ";
                this.outputStream = this.foldFiles(this.out, (String)object4, 3);
            }
            if (this.outputProperty != null) {
                if (this.baos == null) {
                    this.baos = new PropertyOutputStream(this.outputProperty);
                    this.managingTask.log("Output redirected to property: " + this.outputProperty, 3);
                }
                object4 = new KeepAliveOutputStream(this.baos);
                this.outputStream = this.outputStream == null ? object4 : new TeeOutputStream(this.outputStream, (OutputStream)object4);
            } else {
                this.baos = null;
            }
            this.errorStream = this.outputStream;
        }
        if (this.error != null && this.error.length > 0) {
            object4 = "Error " + (this.append ? "appended" : "redirected") + " to ";
            this.errorStream = this.foldFiles(this.error, (String)object4, 3);
        } else if (this.logError || this.errorStream == null) {
            this.errorStream = new LogOutputStream(this.managingTask, 1);
        } else {
            long l = 0L;
            object3 = new OutputStreamFunneler(this.outputStream, l);
            try {
                this.outputStream = ((OutputStreamFunneler)object3).getFunnelInstance();
                this.errorStream = ((OutputStreamFunneler)object3).getFunnelInstance();
            }
            catch (IOException iOException) {
                throw new BuildException("error splitting output/error streams", iOException);
            }
        }
        if (this.errorProperty != null) {
            if (this.errorBaos == null) {
                this.errorBaos = new PropertyOutputStream(this.errorProperty);
                this.managingTask.log("Error redirected to property: " + this.errorProperty, 3);
            }
            object4 = new KeepAliveOutputStream(this.errorBaos);
            this.errorStream = this.error == null || this.error.length == 0 ? object4 : new TeeOutputStream(this.errorStream, (OutputStream)object4);
        } else {
            this.errorBaos = null;
        }
        if (this.outputFilterChains != null && this.outputFilterChains.size() > 0 || !this.outputEncoding.equalsIgnoreCase(this.inputEncoding)) {
            try {
                object4 = new LeadPipeInputStream();
                ((LeadPipeInputStream)object4).setManagingTask(this.managingTask);
                object2 = object4;
                object3 = new InputStreamReader((InputStream)object2, this.inputEncoding);
                if (this.outputFilterChains != null && this.outputFilterChains.size() > 0) {
                    object = new ChainReaderHelper();
                    ((ChainReaderHelper)object).setPrimaryReader((Reader)object3);
                    ((ChainReaderHelper)object).setFilterChains(this.outputFilterChains);
                    object3 = ((ChainReaderHelper)object).getAssembledReader();
                }
                object2 = new ReaderInputStream((Reader)object3, this.outputEncoding);
                object = new Thread(this.threadGroup, new StreamPumper((InputStream)object2, this.outputStream, true), "output pumper");
                ((Thread)object).setPriority(10);
                this.outputStream = new PipedOutputStream((PipedInputStream)object4);
                ((Thread)object).start();
            }
            catch (IOException iOException) {
                throw new BuildException("error setting up output stream", iOException);
            }
        }
        if (this.errorFilterChains != null && this.errorFilterChains.size() > 0 || !this.errorEncoding.equalsIgnoreCase(this.inputEncoding)) {
            try {
                object4 = new LeadPipeInputStream();
                ((LeadPipeInputStream)object4).setManagingTask(this.managingTask);
                object2 = object4;
                object3 = new InputStreamReader((InputStream)object2, this.inputEncoding);
                if (this.errorFilterChains != null && this.errorFilterChains.size() > 0) {
                    object = new ChainReaderHelper();
                    ((ChainReaderHelper)object).setPrimaryReader((Reader)object3);
                    ((ChainReaderHelper)object).setFilterChains(this.errorFilterChains);
                    object3 = ((ChainReaderHelper)object).getAssembledReader();
                }
                object2 = new ReaderInputStream((Reader)object3, this.errorEncoding);
                object = new Thread(this.threadGroup, new StreamPumper((InputStream)object2, this.errorStream, true), "error pumper");
                ((Thread)object).setPriority(10);
                this.errorStream = new PipedOutputStream((PipedInputStream)object4);
                ((Thread)object).start();
            }
            catch (IOException iOException) {
                throw new BuildException("error setting up error stream", iOException);
            }
        }
        if (this.input != null && this.input.length > 0) {
            this.managingTask.log("Redirecting input from file" + (this.input.length == 1 ? "" : "s"), 3);
            try {
                this.inputStream = new ConcatFileInputStream(this.input);
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            ((ConcatFileInputStream)this.inputStream).setManagingTask(this.managingTask);
        } else if (this.inputString != null) {
            this.managingTask.log("Using input \"" + this.inputString + "\"", 3);
            this.inputStream = new ByteArrayInputStream(this.inputString.getBytes());
        }
        if (this.inputStream != null && this.inputFilterChains != null && this.inputFilterChains.size() > 0) {
            object4 = new ChainReaderHelper();
            try {
                ((ChainReaderHelper)object4).setPrimaryReader(new InputStreamReader(this.inputStream, this.inputEncoding));
            }
            catch (IOException iOException) {
                throw new BuildException("error setting up input stream", iOException);
            }
            ((ChainReaderHelper)object4).setFilterChains(this.inputFilterChains);
            this.inputStream = new ReaderInputStream(((ChainReaderHelper)object4).getAssembledReader(), this.inputEncoding);
        }
    }

    public synchronized ExecuteStreamHandler createHandler() throws BuildException {
        this.createStreams();
        return new PumpStreamHandler(this.outputStream, this.errorStream, this.inputStream);
    }

    protected synchronized void handleOutput(String string) {
        if (this.outPrintStream == null) {
            this.outPrintStream = new PrintStream(this.outputStream);
        }
        this.outPrintStream.print(string);
    }

    protected synchronized int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.inputStream == null) {
            return this.managingTask.getProject().defaultInput(byArray, n, n2);
        }
        return this.inputStream.read(byArray, n, n2);
    }

    protected synchronized void handleFlush(String string) {
        if (this.outPrintStream == null) {
            this.outPrintStream = new PrintStream(this.outputStream);
        }
        this.outPrintStream.print(string);
        this.outPrintStream.flush();
    }

    protected synchronized void handleErrorOutput(String string) {
        if (this.errorPrintStream == null) {
            this.errorPrintStream = new PrintStream(this.errorStream);
        }
        this.errorPrintStream.print(string);
    }

    protected synchronized void handleErrorFlush(String string) {
        if (this.errorPrintStream == null) {
            this.errorPrintStream = new PrintStream(this.errorStream);
        }
        this.errorPrintStream.print(string);
    }

    public synchronized OutputStream getOutputStream() {
        return this.outputStream;
    }

    public synchronized OutputStream getErrorStream() {
        return this.errorStream;
    }

    public synchronized InputStream getInputStream() {
        return this.inputStream;
    }

    public synchronized void complete() throws IOException {
        System.out.flush();
        System.err.flush();
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.outputStream.flush();
        this.outputStream.close();
        this.errorStream.flush();
        this.errorStream.close();
        while (this.threadGroup.activeCount() > 0) {
            try {
                this.managingTask.log("waiting for " + this.threadGroup.activeCount() + " Threads:", 4);
                Thread[] threadArray = new Thread[this.threadGroup.activeCount()];
                this.threadGroup.enumerate(threadArray);
                int n = 0;
                while (n < threadArray.length && threadArray[n] != null) {
                    try {
                        this.managingTask.log(threadArray[n].toString(), 4);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    ++n;
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setProperties();
        this.inputStream = null;
        this.errorPrintStream = null;
        this.outPrintStream = null;
        this.errorStream = null;
        this.outputStream = null;
    }

    public synchronized void setProperties() {
        block5: {
            if (this.baos != null) {
                try {
                    this.baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.errorBaos == null) break block5;
            try {
                this.errorBaos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private OutputStream foldFiles(File[] fileArray, String string, int n) {
        LazyFileOutputStream lazyFileOutputStream = new LazyFileOutputStream(fileArray[0], this.append, this.createEmptyFiles);
        this.managingTask.log(string + fileArray[0], n);
        char[] cArray = new char[string.length()];
        Arrays.fill(cArray, ' ');
        String string2 = new String(cArray);
        int n2 = 1;
        while (n2 < fileArray.length) {
            this.outputStream = new TeeOutputStream(this.outputStream, new LazyFileOutputStream(fileArray[n2], this.append, this.createEmptyFiles));
            this.managingTask.log(string2 + fileArray[n2], n);
            ++n2;
        }
        return lazyFileOutputStream;
    }

    private class PropertyOutputStream
    extends ByteArrayOutputStream {
        String property;
        boolean closed = false;

        PropertyOutputStream(String string) {
            this.property = string;
        }

        public void close() throws IOException {
            if (!(this.closed || Redirector.this.append && Redirector.this.appendProperties)) {
                Redirector.this.setPropertyFromBAOS(this, this.property);
                this.closed = true;
            }
        }
    }
}

