/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamPumper
implements Runnable {
    private static final int SIZE = 128;
    private InputStream is;
    private OutputStream os;
    private boolean finished;
    private boolean closeWhenExhausted;

    public StreamPumper(InputStream inputStream, OutputStream outputStream, boolean bl) {
        this.is = inputStream;
        this.os = outputStream;
        this.closeWhenExhausted = bl;
    }

    public StreamPumper(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.finished = false;
        }
        byte[] byArray = new byte[128];
        try {
            int n;
            while ((n = this.is.read(byArray)) > 0) {
                this.os.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            StreamPumper streamPumper2 = this;
            synchronized (streamPumper2) {
                this.finished = true;
                this.notifyAll();
            }
        }
        finally {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException iOException) {}
            }
            StreamPumper streamPumper3 = this;
            synchronized (streamPumper3) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }
}

