/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Touch
extends Task {
    private File file;
    private long millis = -1L;
    private String dateTime;
    private Vector filesets = new Vector();
    private Vector filelists = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public void setDatetime(String string) {
        this.dateTime = string;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.filelists.addElement(fileList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        long l = this.millis;
        if (this.file == null && this.filesets.size() == 0 && this.filelists.size() == 0) {
            throw new BuildException("Specify at least one source - a file, filelist or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to touch directories.");
        }
        try {
            if (this.dateTime != null) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
                try {
                    this.setMillis(dateFormat.parse(this.dateTime).getTime());
                }
                catch (ParseException parseException) {
                    dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.US);
                    try {
                        this.setMillis(dateFormat.parse(this.dateTime).getTime());
                    }
                    catch (ParseException parseException2) {
                        throw new BuildException(parseException2.getMessage(), parseException, this.getLocation());
                    }
                }
                if (this.millis < 0L) {
                    throw new BuildException("Date of " + this.dateTime + " results in negative " + "milliseconds value " + "relative to epoch " + "(January 1, 1970, " + "00:00:00 GMT).");
                }
            }
            this.touch();
            Object var7_5 = null;
            this.millis = l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.millis = l;
            throw throwable;
        }
    }

    protected void touch() throws BuildException {
        String[] stringArray;
        File file;
        Object object;
        boolean bl = false;
        if (this.millis < 0L) {
            bl = true;
            this.millis = System.currentTimeMillis();
        }
        if (this.file != null) {
            this.touch(this.file);
        }
        int n = 0;
        while (n < this.filesets.size()) {
            FileSet fileSet = (FileSet)this.filesets.elementAt(n);
            object = fileSet.getDirectoryScanner(this.getProject());
            file = fileSet.getDir(this.getProject());
            stringArray = ((DirectoryScanner)object).getIncludedFiles();
            String[] stringArray2 = ((DirectoryScanner)object).getIncludedDirectories();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.touch(new File(file, stringArray[n2]));
                ++n2;
            }
            int n3 = 0;
            while (n3 < stringArray2.length) {
                this.touch(new File(file, stringArray2[n3]));
                ++n3;
            }
            ++n;
        }
        int n4 = 0;
        while (n4 < this.filelists.size()) {
            object = (FileList)this.filelists.elementAt(n4);
            file = ((FileList)object).getDir(this.getProject());
            stringArray = ((FileList)object).getFiles(this.getProject());
            int n5 = 0;
            while (n5 < stringArray.length) {
                this.touch(new File(file, stringArray[n5]));
                ++n5;
            }
            ++n4;
        }
        if (bl) {
            this.millis = -1L;
        }
    }

    protected void touch(File file) throws BuildException {
        if (!file.exists()) {
            this.log("Creating " + file, 2);
            try {
                this.fileUtils.createNewFile(file);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not create " + file, iOException, this.getLocation());
            }
        }
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        this.fileUtils.setFileLastModified(file, this.millis);
    }
}

