/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.net.URL;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class WhichResource
extends Task {
    private Path classpath;
    private String classname;
    private String resource;
    private String property;

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    private void validate() {
        int n = 0;
        if (this.classname != null) {
            ++n;
        }
        if (this.resource != null) {
            ++n;
        }
        if (n == 0) {
            throw new BuildException("One of classname or resource must be specified");
        }
        if (n > 1) {
            throw new BuildException("Only one of classname or resource can be specified");
        }
        if (this.property == null) {
            throw new BuildException("No property defined");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        if (this.classpath != null) {
            this.getProject().log("using user supplied classpath: " + this.classpath, 4);
            this.classpath = this.classpath.concatSystemClasspath("ignore");
        } else {
            this.classpath = new Path(this.getProject());
            this.classpath = this.classpath.concatSystemClasspath("only");
            this.getProject().log("using system classpath: " + this.classpath, 4);
        }
        AntClassLoader antClassLoader = new AntClassLoader(this.getProject().getCoreLoader(), this.getProject(), this.classpath, false);
        String string = null;
        if (this.classname != null) {
            this.resource = this.classname.replace('.', '/') + ".class";
        }
        if (this.resource == null) {
            throw new BuildException("One of class or resource is required");
        }
        if (this.resource.startsWith("/")) {
            this.resource = this.resource.substring(1);
        }
        this.log("Searching for " + this.resource, 3);
        URL uRL = antClassLoader.getResource(this.resource);
        if (uRL != null) {
            string = uRL.toExternalForm();
            this.getProject().setNewProperty(this.property, string);
        }
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void setClass(String string) {
        this.classname = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }
}

